/*
 * Decompiled with CFR 0.152.
 */
package com.wmdigit.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.RemoteException;
import com.wmdigit.common.model.ProductsDTO;
import com.wmdigit.service.ICateringInterface;
import com.wmdigit.service.IOnDetectionListener;
import com.wmdigit.service.IOnInitListener;
import com.wmdigit.service.WmSdkInterface;
import com.wmdigit.service.aidl.model.DetectResult;
import com.wmdigit.service.listener.OnServiceConnectListener;
import java.util.List;

public class WmSdk
implements WmSdkInterface {
    private static final String SERVICE_PACKAGE = "com.wmdigit.cateringdetect";
    private static final String SERVICE_ACTION = "com.wmdigit.service";
    private static WmSdk instance;
    private Context context;
    private ICateringInterface aidlInterface;
    private OnServiceConnectListener onServiceConnectListener;
    private boolean isServiceConnected = false;
    private final IBinder.DeathRecipient deathRecipient = new IBinder.DeathRecipient(){

        public void binderDied() {
            if (WmSdk.this.aidlInterface != null) {
                WmSdk.this.aidlInterface.asBinder().unlinkToDeath((IBinder.DeathRecipient)this, 0);
            }
        }
    };
    private ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            WmSdk.this.isServiceConnected = true;
            WmSdk.this.aidlInterface = ICateringInterface.Stub.asInterface(service);
            try {
                WmSdk.this.aidlInterface.asBinder().linkToDeath(WmSdk.this.deathRecipient, 0);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            if (WmSdk.this.onServiceConnectListener != null) {
                WmSdk.this.onServiceConnectListener.onConnected(name, service);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            WmSdk.this.isServiceConnected = false;
            if (WmSdk.this.onServiceConnectListener != null) {
                WmSdk.this.onServiceConnectListener.onDisconnected(name);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WmSdk getInstance() {
        if (instance != null) return instance;
        Class<WmSdk> clazz = WmSdk.class;
        synchronized (WmSdk.class) {
            if (instance != null) return instance;
            instance = new WmSdk();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void bindService(Context context, OnServiceConnectListener listener) {
        this.context = context;
        this.onServiceConnectListener = listener;
        Intent intent = new Intent();
        intent.setPackage(SERVICE_PACKAGE);
        intent.setAction(SERVICE_ACTION);
        context.bindService(intent, this.serviceConnection, 1);
    }

    @Override
    public void unbindService() {
        if (this.serviceConnection != null) {
            this.context.unbindService(this.serviceConnection);
        }
    }

    @Override
    public void init(IOnInitListener listener) {
        try {
            this.aidlInterface.init(listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void importProducts(List<ProductsDTO> products) {
        try {
            this.aidlInterface.importProducts(products);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void registerDetectionListener(boolean generateBitmap, IOnDetectionListener listener) {
        try {
            this.aidlInterface.registerDetectionListener(generateBitmap, listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unregisterDetectionListener() {
        try {
            this.aidlInterface.unregisterDetectionListener();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public DetectResult autoDetect(boolean generateBitmap) {
        DetectResult detectResult = null;
        try {
            detectResult = this.aidlInterface.autoDetect(generateBitmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return detectResult;
    }

    @Override
    public boolean checkServiceAppInstalled(Context context) {
        try {
            context.getPackageManager().getPackageInfo(SERVICE_PACKAGE, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean checkServiceConnected() {
        return this.isServiceConnected;
    }

    @Override
    public boolean checkActivation() {
        boolean result = false;
        try {
            result = this.aidlInterface.checkActivation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean checkCameraCrop() {
        boolean result = false;
        try {
            result = this.aidlInterface.checkCameraCrop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean checkLearningDataInitCompleted() {
        boolean result = false;
        try {
            result = this.aidlInterface.checkLearningDataInited();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void openSettingPage() {
        try {
            this.aidlInterface.openSettingPage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void resetCameraBackground() {
        try {
            this.aidlInterface.resetCameraBackground();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

