package com.wmdigit.cateringservicedemo.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    public static final String DATE_FORMATTER_1 = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMATTER = "yyyy:MM:dd HH:mm:ss";
    public static final String DATE_FORMATTER_2 = "yyyy-MM-dd";
    public static final String DATE_FORMATTER_3 = "yyyyMMdd";
    public static final String DATE_FORMATTER_4 = "HH:mm";
    public static final String DATE_FORMATTER_5 = "HH:mm:ss";
    public static final String DATE_FORMATTER_6 = "MM.dd";
    public static final String DATE_FORMATTER_7 = "MM月dd日";
    public static final String DATE_FORMATTER_8 = "yyyy.MM.dd";
    public static final String DATE_FORMATTER_9 = "yy/MM/dd";
    public static final String DATE_FORMATTER_10 = "yy.MM.dd";
    public static final String DATE_FORMATTER_11 = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_FORMATTER_12 = "yyyy/MM/dd HH:mm:ss";


    public static final String DATE_FORMATTER_13 = "yy-MM-dd";
    public static final String DATE_FORMATTER_14 = "yyMMdd";

    public static Calendar getCalendar(String time) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMATTER_2);
            Date date = sdf.parse(time);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        } catch (ParseException e) {
        }
        return null;

    }

    /**
     * 返回当前时间的字符串格式
     */
    public static String getTodayTime() {
        Date date = new Date();
        DateFormat df = new SimpleDateFormat(DATE_FORMATTER_1);
        String todyStr = df.format(date);
        return todyStr;
    }

    /**
     * 返回当前时间的字符串格式
     */
    public static String getTodayTime2() {
        Date date = new Date();
        DateFormat df = new SimpleDateFormat(DATE_FORMATTER);
        String todyStr = df.format(date);
        return todyStr;
    }

    /**
     * 返回当前日期的字符串格式
     */
    public static String getTodayDate() {
        Date date = new Date();
        DateFormat df = new SimpleDateFormat(DATE_FORMATTER_2);
        return df.format(date);
    }

    /**
     * 返回当前日期的字符串格式
     */
    public static String getTodayDateAdd(int day) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_MONTH, +day);
        Date date2 = calendar.getTime();
        DateFormat df = new SimpleDateFormat(DATE_FORMATTER_2);
        String todyStr = df.format(date2);
        return todyStr;
    }

    /**
     * 返回当前日期的字符串格式
     */
    public static String getTodayDate8() {
        Date date = new Date();
        DateFormat df = new SimpleDateFormat(DATE_FORMATTER_8);
        String todyStr = df.format(date);
        return todyStr;
    }


    /**
     * 返回当前日期的字符串格式
     */
    public static String getTodayDate8Add(int day) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_MONTH, +day);
        Date date2 = calendar.getTime();
        DateFormat df = new SimpleDateFormat(DATE_FORMATTER_8);
        String todyStr = df.format(date2);
        return todyStr;
    }

    public static String getTodayDate13() {
        Date date = new Date();
        DateFormat df = new SimpleDateFormat(DATE_FORMATTER_13);
        String todyStr = df.format(date);
        return todyStr;
    }

    /**
     * 返回当前日期的字符串格式
     */
    public static String getTodayDate13Add(int day) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_MONTH, +day);
        Date date2 = calendar.getTime();
        DateFormat df = new SimpleDateFormat(DATE_FORMATTER_13);
        String todyStr = df.format(date2);
        return todyStr;
    }

    /**
     * 返回当前日期的字符串格式
     */
    public static String getTodayDate14Add(int day) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_MONTH, +day);
        Date date2 = calendar.getTime();
        DateFormat df = new SimpleDateFormat(DATE_FORMATTER_14);
        String todyStr = df.format(date2);
        return todyStr;
    }


    /**
     * 返回当前日期的字符串格式
     */
    public static String getTodayDate4() {
        Date date = new Date();
        DateFormat df = new SimpleDateFormat(DATE_FORMATTER_4);
        String todyStr = df.format(date);
        return todyStr;
    }

    /**
     * 返回当前日期的字符串格式
     */
    public static String getTodayDate9() {
        Date date = new Date();
        DateFormat df1 = new SimpleDateFormat(DATE_FORMATTER_9);
        DateFormat df2 = new SimpleDateFormat(DATE_FORMATTER_5);
        String todyStr1 = df1.format(date);
        String todyStr2 = df2.format(date);
        return todyStr1 + "\n" + todyStr2;
    }

    /**
     * 返回当前日期的字符串格式
     */
    public static String getTodayDate5() {
        Date date = new Date();
        DateFormat df2 = new SimpleDateFormat(DATE_FORMATTER_5);
        String todyStr2 = df2.format(date);
        return todyStr2;
    }

    /**
     * 返回当前日期的字符串格式
     */
    public static String getTodayDate10() {
        Date date = new Date();
        DateFormat df1 = new SimpleDateFormat(DATE_FORMATTER_10);
        String todyStr1 = df1.format(date);
        return todyStr1;
    }

    /**
     * 获取开始时间
     */
    public static String getDayStart(String dateStr) {
        return dateStr + " 00:00:00";
    }

    /**
     * 获取结束时间
     */
    public static String getDayEnd(String dateStr) {
        return dateStr + " 23:59:59";
    }

    /**
     * 返回当前月日
     */
    public static String getMonthDay() {
        Date date = new Date();
        DateFormat df = new SimpleDateFormat(DATE_FORMATTER_6);
        String todyStr = df.format(date);
        return todyStr;
    }

    /**
     * yyyy-MM-dd 转  MM月dd日
     *
     * @return
     */
    public static String forMatStringToString(String stringDate) throws ParseException {
        Date date = stringToDate(stringDate, DATE_FORMATTER_2);
        return formatDate(date, DATE_FORMATTER_7);
    }

    /**
     * yyyy-MM-dd 转  MM.dd
     *
     * @return
     */
    public static String forMatStringToString2(String stringDate) throws ParseException {
        Date date = stringToDate(stringDate, DATE_FORMATTER_2);
        return formatDate(date, DATE_FORMATTER_6);
    }

    public static String formatDate(Date date, String formatStr) {
        DateFormat df = new SimpleDateFormat(formatStr);
        String todyStr = df.format(date);
        return todyStr;
    }


    public static Date calendarToDate(Calendar mCalendar) {
        Date date = mCalendar.getTime();
        return date;
    }

    public static String fomatforDate(Date date, String fomat) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(fomat);
        String time = df.format(date);
        return time;
    }


    // date类型转换为String类型
    // formatType格式为yyyy-MM-dd HH:mm:ss//yyyy年MM月dd日 HH时mm分ss秒
    // data Date类型的时间
    public static String dateToString(Date data, String formatType) {
        return new SimpleDateFormat(formatType).format(data);
    }

    // long类型转换为String类型
    // currentTime要转换的long类型的时间
    // formatType要转换的string类型的时间格式
    public static String longToString(long currentTime, String formatType)
            throws ParseException {
        Date date = longToDate(currentTime, formatType); // long类型转成Date类型
        String strTime = dateToString(date, formatType); // date类型转成String
        return strTime;
    }

    // string类型转换为date类型
    // strTime要转换的string类型的时间，formatType要转换的格式yyyy-MM-dd HH:mm:ss//yyyy年MM月dd日
    // HH时mm分ss秒，
    // strTime的时间格式必须要与formatType的时间格式相同
    public static Date stringToDate(String strTime, String formatType)
            throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(formatType);
        Date date = null;
        date = formatter.parse(strTime);
        return date;
    }

    // long转换为Date类型
    // currentTime要转换的long类型的时间
    // formatType要转换的时间格式yyyy-MM-dd HH:mm:ss//yyyy年MM月dd日 HH时mm分ss秒
    public static Date longToDate(long currentTime, String formatType)
            throws ParseException {
        Date dateOld = new Date(currentTime); // 根据long类型的毫秒数生命一个date类型的时间
        String sDateTime = dateToString(dateOld, formatType); // 把date类型的时间转换为string
        Date date = stringToDate(sDateTime, formatType); // 把String类型转换为Date类型
        return date;
    }

    // string类型转换为long类型
    // strTime要转换的String类型的时间
    // formatType时间格式
    // strTime的时间格式和formatType的时间格式必须相同
    public static long stringToLong(String strTime, String formatType)
            throws ParseException {
        Date date = stringToDate(strTime, formatType); // String类型转成date类型
        if (date == null) {
            return 0;
        } else {
            long currentTime = dateToLong(date); // date类型转成long类型
            return currentTime;
        }
    }

    // date类型转换为long类型
    // date要转换的date类型的时间
    public static long dateToLong(Date date) {
        return date.getTime();
    }

    /**
     * 判断时间是否在时间段内
     *
     * @param nowTime
     * @param beginTime
     * @param endTime
     * @return
     */
    public static boolean belongCalendar(Date nowTime, Date beginTime, Date endTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        if (date.after(begin) && date.before(end)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 格式化时间(00:00:00)
     *
     * @param l
     * @return
     */
    public static String formatLongToTimeStr(long l) {
        long hour = 0;
        long minute = 0;
        long second = l;
        if (second > 60) {
            minute = second / 60; //取整
            second = second % 60;//取余
        }
        if (minute > 60) {
            hour = minute / 60;
            minute = minute % 60;
        }
        String hourString;
        if (hour > 9) {
            hourString = "" + hour + ":";
        } else {
            hourString = "0" + hour + ":";
        }
        String minuteString;
        if (minute > 9) {
            minuteString = "" + minute + ":";
        } else {
            minuteString = "0" + minute + ":";
        }
        String secondString;
        if (second > 9) {
            secondString = "" + second + ":";
        } else {
            secondString = "0" + second + ":";
        }
        String strtime = hourString + minuteString + secondString;
        return strtime;
    }

    /**
     * 判断Date是否是今天
     *
     * @param date
     * @return
     */
    public static boolean isToday(Date date) {
        //当前时间
        Date now = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        //获取今天的日期
        String nowDay = sf.format(now);
        //对比的时间
        String day = sf.format(date);
        return day.equals(nowDay);
    }

    public static int getDateHour(Date date) {
        int hour = 0;
        SimpleDateFormat sf = new SimpleDateFormat("HH");
        try {
            hour = Integer.parseInt(sf.format(date));
        } catch (Exception e) {
        }
        return hour;
    }

    public static int getDateMinute(Date date) {
        int minute = 0;
        SimpleDateFormat sf = new SimpleDateFormat("mm");
        try {
            minute = Integer.parseInt(sf.format(date));
        } catch (Exception e) {
        }
        return minute;
    }

    public static int getDateSecond(Date date) {
        int second = 0;
        SimpleDateFormat sf = new SimpleDateFormat("ss");
        try {
            second = Integer.parseInt(sf.format(date));
        } catch (Exception e) {
        }
        return second;
    }



    /**
     * 两天之后时间
     *
     * @return
     */
    public static String getAfterDayDate(int amount) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_FORMATTER_8);
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DAY_OF_MONTH, amount);
        return dateFormatter.format(cal.getTime());
    }

    /**
     * 两天之后时间
     *
     * @return
     */
    public static String getAfterDayDate10(int amount) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_FORMATTER_10);
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DAY_OF_MONTH, amount);
        return dateFormatter.format(cal.getTime());
    }

    /**
     * 两天之后时间
     *
     * @return
     */
    public static String getAfterDayDate13(int amount) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_FORMATTER_13);
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DAY_OF_MONTH, amount);
        return dateFormatter.format(cal.getTime());
    }

    public static String getWeighingDate(String dateFormat, int amount) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(dateFormat, Locale.CHINA);
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DAY_OF_MONTH, amount);
        return dateFormatter.format(cal.getTime());
    }

    /**
     * 一个月之前的时间
     *
     * @return
     */
    public static long getBeforeMonthDate() {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.MONTH, -1);
        return cal.getTime().getTime();
    }

    public static long getWeightingStartTime(String time) {
        SimpleDateFormat sf = new SimpleDateFormat(DATE_FORMATTER_11, Locale.CHINA);
        try {
            Date date = sf.parse(time);
            return date.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static String getWeightingTime() {
        return formatDate(new Date(), DATE_FORMATTER_12);
    }

    public static boolean isIncludeTime(String beginTime, String endTime, long currentTime) {
        try {
            long begin = stringToLong(beginTime, DATE_FORMATTER_1);
            long end = stringToLong(endTime, DATE_FORMATTER_1);
//            XLog.i(begin + "/" + end + "/" + currentTime);
            return (currentTime > begin && currentTime < end);

        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    //将字符串时间格式转为long形
    public static long getToLong(String DateTime) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMATTER_1, Locale.CHINA);
        Date time = sdf.parse(DateTime);
        return time.getTime();
    }

    public static String getLogTime(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMATTER_11, Locale.CHINA);
        Date date = new Date(time);
        String format = sdf.format(date);
        return format;
    }

    public static String getCurrentMsTime(long time) {
        DateFormat df = new SimpleDateFormat(DATE_FORMATTER_11, Locale.CHINA);
        Date date = new Date(time);
        String currents = df.format(date);
        return currents;
    }
}
