import json
import time
import redis, requests
from app.utils.config import REDIS_HOST, REDIS_PASWORD, REDIS_PORT, REDIS_DB


# 初始化redis
redis_client = redis.Redis(host=REDIS_HOST, password=REDIS_PASWORD, port=REDIS_PORT, db=REDIS_DB)


def translate2en_by_wmcms(content, retry=0):
    # 如果失败，每隔retry_sleep秒重试一次，共retry_all_times次
    retry_sleep = 2
    retry_all_times = 10
    print("从缓存获取 wmcms_token")
    wmcms_token = redis_client.get('wmcms_token')
    if not wmcms_token:
        print(f"login_wmcms 获取 wmcms_token")
        wmcms_token = login_wmcms()
        redis_client.set('wmcms_token', wmcms_token, ex=3600)  # 有效期1小时，3600秒
    else:
        wmcms_token = wmcms_token.decode('utf-8')

    req_info = "====== begin request ======>\n" + str(content)
    # print(req_info)
    print(req_info)
    try:
        resp = requests.post('https://wmminiportal.wmdigit.com/wmcms/chatgpt',
                             json={"module": "work", "user": 27, "ask": str(content), "topic": 186},
                             headers={'content-type': 'application/json;charset=utf8',
                                      'Authorization': 'Bearer ' + wmcms_token},
                             verify=True)
        # print('Status code:', resp.status_code)
        # print('Headers:', resp.headers)
        # print('Response body:', resp.text)
        resp_dic = json.loads(resp.text)
        resp_info = '====== response is ======>\n' + str(resp_dic)
        # print(resp_info)
        print(resp_info)
        if 'answer' in resp_dic:
            mess = resp_dic['answer']
            mess = mess.strip().strip('\n')
            return str(mess)
        elif 'code' in resp_dic:
            if resp_dic['code'] == 10041 or resp_dic['code'] == 10051:
                print(f"access token 损坏或过期，重新 login 获取 wmcms_token")
                wmcms_token = login_wmcms()
                redis_client.set('wmcms_token', wmcms_token, ex=3600)  # 有效期1小时，3600秒
                return translate2en_by_wmcms(content)
            elif resp_dic['code'] == 10200:
                print(resp_dic['message'])
                return translate2en_by_wmcms(content)
            else:
                print("与wmcms通讯失败：" + str(resp_dic))
                raise str(resp_dic)
        else:
            print("与wmcms通讯失败：" + str(resp_dic))
            raise str(resp_dic)
    except Exception as e:
        retry += 1
        if retry == retry_all_times:
            raise f"经过{retry_all_times}次重试,chatgpt依然失败。" + str(e)
        print(f"请求chatgpt翻译失败：{str(e)}，{retry_sleep}秒后第{retry}次重试……")
        time.sleep(retry_sleep)
        return translate2en_by_wmcms(content, retry)



def login_wmcms():
    try:
        url = 'https://wmminiportal.wmdigit.com/wmcms/user/login'
        para = {"captcha": "", "username": "wm_video", "password": "WMdigit.2018"}
        req_info = "====== begin request ======>\n" + str(url) + '\n' + str(para)
        # print(req_info)
        print(req_info)
        req = requests.post(url,
                            json=para,
                            headers={'content-type': 'application/json'},
                            verify=True)
        req_dic = json.loads(req.text)
        resp_info = '====== response is ======>\n' + str(req_dic)
        # print(resp_info)
        print(resp_info)
        if 'access_token' in req_dic:
            return req_dic['access_token']
        else:
            print("login_wmcms失败：" + str(req_dic))
            raise "login_wmcms失败：" + str(req_dic)
    except Exception as e:
        print("login_wmcms失败：" + str(e))
        raise "login_wmcms失败：" + str(e)


if __name__ == "__main__":
    translate2en_by_wmcms("请你作为一个翻译器，将”阳光，美女，沙滩“翻译为英文，只返回翻译的内容。")