import argparse

from app.video_cut.autocut import whisper_model
from app.video_cut.autocut.type import WhisperMode, WhisperModel


def main_args(logger, debug):
    logger.info('loading augument')
    parser = argparse.ArgumentParser()
    parser.add_argument("--inputs", type=str, help="Inputs filenames/folders")
    parser.add_argument(
        "--lang",
        type=str,
        default="zh",
        choices=[
            "zh",
            "en",
            "Afrikaans",
            "Arabic",
            "Armenian",
            "Azerbaijani",
            "Belarusian",
            "Bosnian",
            "Bulgarian",
            "Catalan",
            "Croatian",
            "Czech",
            "Danish",
            "Dutch",
            "Estonian",
            "Finnish",
            "French",
            "Galician",
            "German",
            "Greek",
            "Hebrew",
            "Hindi",
            "Hungarian",
            "Icelandic",
            "Indonesian",
            "Italian",
            "Japanese",
            "Kannada",
            "Kazakh",
            "Korean",
            "Latvian",
            "Lithuanian",
            "Macedonian",
            "Malay",
            "Marathi",
            "Maori",
            "Nepali",
            "Norwegian",
            "Persian",
            "Polish",
            "Portuguese",
            "Romanian",
            "Russian",
            "Serbian",
            "Slovak",
            "Slovenian",
            "Spanish",
            "Swahili",
            "Swedish",
            "Tagalog",
            "Tamil",
            "Thai",
            "Turkish",
            "Ukrainian",
            "Urdu",
            "Vietnamese",
            "Welsh",
        ],
        help="The output language of transcription",
    )
    parser.add_argument(
        "--prompt", type=str, default="", help="initial prompt feed into whisper"
    )
    parser.add_argument(
        "--whisper-mode",
        type=str,
        default=WhisperMode.WHISPER.value,
        choices=WhisperMode.get_values(),
        help="Whisper inference mode: whisper: run whisper locally; openai: use openai api.",
    )
    parser.add_argument(
        "--openai-rpm",
        type=int,
        default=3,
        choices=[3, 50],
        help="Openai Whisper API REQUESTS PER MINUTE(FREE USERS: 3RPM; PAID USERS: 50RPM). "
        "More info: https://platform.openai.com/docs/guides/rate-limits/overview",
    )
    parser.add_argument(
        "--whisper-model",
        type=str,
        default=WhisperModel.SMALL.value,
        choices=WhisperModel.get_values(),
        help="The whisper model used to transcribe.",
    )
    parser.add_argument(
        "--bitrate",
        type=str,
        default="10m",
        help="The bitrate to export the cutted video, such as 10m, 1m, or 500k",
    )
    parser.add_argument(
        "--vad", help="If or not use VAD", choices=["1", "0", "auto"], default="0"
    )
    parser.add_argument(
        "--force",
        help="Force write even if files exist",
        action=argparse.BooleanOptionalAction,
    )
    parser.add_argument(
        "--encoding", type=str, default="utf-8", help="Document encoding format"
    )
    parser.add_argument(
        "--device",
        type=str,
        default=None,
        choices=["cpu", "cuda"],
        help="Force to CPU or GPU for transcribing. In default automatically use GPU if available.",
    )
    parser.add_argument(
        "--wmdigit",
        help="Convert video to different language",
        action=argparse.BooleanOptionalAction,
    )

    args = parser.parse_args(args=[])
    args.wmdigit = True
    args.force = True
    args.vad = "0"

    if not debug:
        # args.whisper_model = "large-v2"
        args.whisper_model = "medium"
        args.device = "cuda"
    else:
        args.whisper_model = "medium"

    logger.info(f'loading whisper_model: {args.whisper_model}, device: {args.device}')
    whispermodel = whisper_model.WhisperModel(16000)
    whispermodel.load(args.whisper_model, args.device)
    logger.info(f'done.')

    return args, whispermodel