from flask import abort, request, jsonify
import datetime, os, time
from app.video_cut.autocut import wmdigit_cut, wmdigit_transcribe, utils


def error(msg):
    abort(jsonify({"error": msg}))


# 校验请求参数
def validate_request():
    if not request.json or 'instances' not in request.json:
        error("参数错误: 缺少instances参数")

    instance = request.json['instances']
    if len(instance) <= 0 or 'video' not in instance[0] or 'lang' not in instance[0]:
        error('参数错误: instances缺少:video,lang')

    video = instance[0]['video']
    lang = instance[0]['lang']
    with_sub = True if instance[0]['with_sub'] == 'true' else False

    if len(video) <= 0:
        error('参数错误: video 参数不可为空')
    if len(lang) <= 0:
        error('参数错误: lang 参数不可为空')

    # if not video.startswith('http'):
    #     error('video 必须是网络路径')

    return video, lang, with_sub


# 主线
def video_cut_pipeline(logger, args, whispermodel):
    # print(args)
    time_record = []
    media_file, lang, with_sub = validate_request()
    all_start_time = time.time()
    srt_fn = utils.change_ext(media_file, "srt")
    md_fn = utils.change_ext(media_file, "md")
    args.lang = lang

    # 1、视频生成srt和md
    start_time = time.time()
    if lang != "zh":
        prompt = f"Subtitles must be fully translated into {lang}"
    else:
        prompt = ""
    logger.info(f"Transcribe {media_file} lang={lang} promt={prompt}")

    args.inputs = [media_file]
    wmdigit_transcribe.Transcribe(args, whispermodel).run()
    time_record.append(f"视频生成srt和md。耗时: {time.time() - start_time:.4f} 秒")

    # 2、从字幕生成cut视频
    start_time = time.time()
    args.inputs = [media_file, md_fn, srt_fn]
    final_video_fn, new_srt_fn = wmdigit_cut.Cutter(args).run()
    time_record.append(f"从字幕生成cut视频。耗时: {time.time() - start_time:.4f} 秒")
    
    # 3、加字幕
    if with_sub:
        start_time = time.time()
        final_video_fn = utils.combine_video_with_subtitle(final_video_fn, new_srt_fn)
        time_record.append(f"加字幕耗时: {time.time() - start_time:.4f} 秒")

    time_record.append(f"所有步骤处理完毕。耗时: {time.time() - all_start_time:.4f} 秒")
    for i in time_record:
        print(i)

    return final_video_fn, srt_fn



