#!/usr/bin/env python
# -*- coding: utf-8 -*-
from flask import Flask, abort, request, jsonify, send_file
import datetime, os, sys, time
import logging
from app.utils import util
from app.models.wm_option import db
from app.video_cut.load_args import main_args
from app.video_cut.main import video_cut_pipeline

logging.basicConfig(level = logging.INFO,format = '%(asctime)s - %(name)s - %(levelname)s - %(message)s')
logger = logging.getLogger(__name__)

app = Flask(__name__)

app.config['PERMANENT_SESSION_LIFETIME'] = 600  # 10 minutes timeout
app.config['TIMEOUT'] = 600
app.config['SQLALCHEMY_DATABASE_URI'] = 'mysql+pymysql://root:WMdigit.2018@rm-2zex762o7g65303359o.mysql.rds.aliyuncs.com:3306/lincmsprod'
db.init_app(app)
logger.info("start services")

# 全局路径
root = './'
app_root = os.path.join(root, 'app')
input_root = os.path.join(root, 'inputs')
output_root = os.path.join(root, 'outputs')

# 预加载模型
args, whispermodel = main_args(logger, app.config['DEBUG'])

# 对外接口
@app.route('/wm_video_cut', methods=['POST'])
def wm_video_cut():
    final_video_url, srt_url = video_cut_pipeline(logger, args, whispermodel)
    return jsonify({"result": {"final_video_url": final_video_url, "srt_url": srt_url}})


@app.route('/upload_file', methods=['POST'])
def upload_file():
    # check if the post request has the file part
    if 'file' not in request.files:
        return 'No file part', 403
    file = request.files['file']
    if file.filename == '':
        return 'No selected file', 403
    file_url = util.upload_file(file)
    if not file_url:
        return '上传文件失败', 500
    else:
        return jsonify({"result": {"file_url": file_url}})


@app.route('/download/<path:file_path>')
def download_file(file_path):
    if not file_path.startswith('input'):
        return '文件不存在', 404
    # 发送文件给浏览器进行下载
    return send_file(file_path, as_attachment=True)


if __name__ == "__main__":
    app.run()
