//
//  OrderListTableViewCell.m
//  Car
//
//  Created by Javen on 2016/12/26.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "OrderListTableViewCell.h"
#import "OrderListModel.h"
#import "UIImageView+WebCache.h"
@interface OrderListTableViewCell ()
@property (strong, nonatomic) OrderListModel *model;
@end
@implementation OrderListTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
}

- (void)configCellWithModel:(ProductOrderEntity *)model; {
    [self.imgLogo sd_setImageWithURL:[NSURL URLWithString:model.productImageUrl]];
    self.labelTitle.text = model.productName;
    self.labelBillNumber.text = model.billNumber;
    self.labelMoney.text = [model.realPayTotal stringValue];
    self.imgState.hidden = ![model.state isEqualToString:@"checked"];
    
    
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
