//
//  OrderListFilterViewController.m
//  Car
//
//  Created by Javen on 2016/12/26.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "OrderListFilterViewController.h"

@interface OrderListFilterViewController ()
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *constraintHeight;

/**
 阴影
 */
@property (strong, nonatomic) UIView *shadow;

/**
 整个输入面板
 */
@property (weak, nonatomic) IBOutlet UIView *board;

/**
 单号
 */
@property (weak, nonatomic) IBOutlet UITextField *textFieldBillNumber;

/**
 日期开始时间
 */
@property (weak, nonatomic) IBOutlet DateTextField *textFieldDate;
@property (weak, nonatomic) IBOutlet DateTextField *textFieldEndDate;

@end

@implementation OrderListFilterViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor clearColor];
    // Do any additional setup after loading the view.
    self.textFieldDate.type = DateTextFieldTime;
    self.textFieldEndDate.type = DateTextFieldTime;
    self.textFieldDate.text = [[[NSDate date] yearMonthDayString] stringByAppendingString:@" 00:00:00"];
    self.shadow = [[UIView alloc] initWithFrame:self.view.bounds];
    self.shadow.backgroundColor = [UIColor clearColor];
    [self.view insertSubview:self.shadow belowSubview:self.board];
}

- (IBAction)actionBac:(id)sender {
    [self hideFilterView];
}

- (void)configParam {
    self.param.billNumberLike = self.textFieldBillNumber.text;
//    self.param.userNameLike = self.textFieldStationUser.text;
    self.param.beginDate = self.textFieldDate.text;
    self.param.endDate = self.textFieldEndDate.text;;
}

#pragma mark - actions

/**
 重置
 */
- (IBAction)actionReset:(id)sender {
    self.param.billNumberLike = nil;
//    self.param.userNameLike = nil;
    self.param.endDate = nil;
    self.textFieldDate.text = nil;
//    self.textFieldStationUser.text = nil;
    self.textFieldBillNumber.text = nil;
}

/**
 提交
 */
- (IBAction)actionSubmit:(id)sender {
    [self configParam];
    [self hideFilterView];
    if (self.blockSubmit) {
        self.blockSubmit();
    }
}

- (void)hideFilterView {
    HIDE_KEYBOARD;
    self.isOpen = NO;
    self.constraintHeight.constant = 0;
    [UIView animateWithDuration:0.7
        delay:0
        usingSpringWithDamping:0.9
        initialSpringVelocity:1.0
        options:UIViewAnimationOptionCurveLinear
        animations:^{
            self.shadow.backgroundColor = [UIColor clearColor];
            [self.view layoutIfNeeded];
        }
        completion:^(BOOL finished) {
            [self.view removeFromSuperview];
        }];
}

- (void)showFilterView {
    self.isOpen = YES;
    self.constraintHeight.constant = 220;
    [UIView animateWithDuration:0.7
                          delay:0
         usingSpringWithDamping:0.9
          initialSpringVelocity:1.0
                        options:UIViewAnimationOptionCurveLinear
                     animations:^{
                         self.shadow.backgroundColor = [UIColor colorWithWhite:0.3 alpha:0.3];
                         [self.view layoutIfNeeded];
                     }
                     completion:nil];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little
preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
