//
//  DateTextField.h
//  RealEstateManagement
//
//  Created by Javen on 2016/11/8.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import <UIKit/UIKit.h>
/**
 *  日期文字的格式
 */
typedef NS_ENUM(NSInteger, DateTextFieldType) {
    /**
     *  年月
     */
    DateTextFieldYearMonth,
    /**
     *  年月日
     */
    DateTextFieldYearMonthDay,
    /**
     *  日期+时间
     */
    DateTextFieldTime,
};


/**
 时间范围

 - DateTextFieldRangeBefore: 现在之前
 - DateTextFieldRangeAfter: 现在之后
 */
typedef NS_ENUM(NSInteger, DateTextFieldRange) {
    DateTextFieldRangeUnLimited,
    DateTextFieldRangeBefore,
    DateTextFieldRangeAfter
};

@interface DateTextField : UITextField
@property (nonatomic, assign) DateTextFieldType type;
@property (nonatomic, assign) DateTextFieldRange rangeType;
@property (nonatomic, copy) void (^blockEndEdit)(void);
@property (strong, nonatomic) NSDate *maxDate;
@property (strong, nonatomic) NSDate *minDate;


/**
 datePicker的日期
 */
@property (strong, nonatomic) NSDate *date;

@end
