//
//  ZJBaseModel.m
//  RealEstateManagement
//
//  Created by Javen on 2017/2/9.
//  Copyright © 2017年 上海勾芒信息科技. All rights reserved.
//

#import "ZJBaseModel.h"

@implementation ZJBaseModel
/**
 字典转模型
 
 @param dic 字典
 @return 转换之后的模型类
 */
+ (instancetype)modelWithDic:(NSDictionary *)dic {
    id model = [[self alloc] initWithDictionary:dic error:nil];
    return model;
}

/**
 模型转模型
 
 @param model 要转换的模型类
 @return 转换之后的模型类
 */
- (instancetype)modelWithModel:(id)model {
    id destinationModel = [[self class] modelWithDic:[model toDictionary]];
    return destinationModel;
}

- (void)setZj_displayName:(NSString *)zj_displayName {
    _zj_displayName = zj_displayName;
}

- (NSString *)zj_displayName {
    return _zj_displayName;
}
@end
