//
//  CardViewController.m
//  Car
//
//  Created by Javen on 2016/12/28.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "CardViewController.h"
#import "HttpCilent.h"
#import "CardView.h"
#import "CardModel.h"
@interface CardViewController ()
@property (weak, nonatomic) IBOutlet UITextField *textFieldCardNumber;
@property (weak, nonatomic) IBOutlet CardView *cardView;
@property (weak, nonatomic) IBOutlet UIImageView *imgNoCardBg;
@property (weak, nonatomic) IBOutlet UILabel *labelFindCard;
@property (weak, nonatomic) IBOutlet UIButton *btnConfirm;
@property (strong, nonatomic) CardModel *card;

@end

@implementation CardViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self configUI];
    [self noCard];
    if (self.cardNumber) {
        self.textFieldCardNumber.text = self.cardNumber;
        [self httpCardWithNumber:self.cardNumber];
    }
}

- (void)noCard {
    self.cardView.hidden = YES;
    self.labelFindCard.hidden = YES;
    self.imgNoCardBg.hidden = NO;
    self.btnConfirm.hidden = YES;
}

- (void)findCard {
    self.cardView.hidden = NO;
    self.labelFindCard.hidden = NO;
    self.imgNoCardBg.hidden = YES;
    self.btnConfirm.hidden = NO;
}

- (void)configUIWithCard {
    [self findCard];
    self.cardView.model = self.card;
        self.btnConfirm.enabled = ![self.card.state isEqualToString:@"checked"];
}

- (void)configUI {
    self.title = @"核销订单";
    UIBarButtonItem *rightBtn =
        [[UIBarButtonItem alloc] initWithTitle:@"确认查询"
                                         style:UIBarButtonItemStyleDone
                                        target:self
                                        action:@selector(actionCard)];
    self.navigationItem.rightBarButtonItem = rightBtn;
}

- (void)httpCardWithNumber:(NSString *)number {
    NSString *url = kStrPrefix(number, kGetTicketUrl);
    [MBProgressHUD j_loading:@"查询中…"];
    WS(weakSelf);
    [kHttp GET:url
        parameters:nil
          complete:^(id _Nullable response, NSError *_Nullable error) {
              [MBProgressHUD j_hideLoadingView];
              if (kRsSuccess(response)) {
                  weakSelf.card = [[CardModel alloc] initWithDictionary:response[@"data"] error:nil];
                  [weakSelf configUIWithCard];
              } else {
                  kShowRsMsg(response);
              }
          }];
}

- (void)actionCard {
    HIDE_KEYBOARD;
    kCanNotBeNil(self.textFieldCardNumber.text, @"卡券号不能为空！");
    [self httpCardWithNumber:self.textFieldCardNumber.text];
}
/*
 扫描二维码
 */
- (IBAction)actionScan:(id)sender {
    [self.navigationController popViewControllerAnimated:YES];
}

/**
 确认销券
 */
- (IBAction)actionOffset:(id)sender {
    WS(weakSelf);
    [self alertTitle:@"确认销券？"
                 msg:nil
            okAction:^(UIAlertAction *_Nullable action) {
                [weakSelf httpCheckCard];
            }
        cancelAction:nil];
}

/**
 销券
 */
- (void)httpCheckCard {
    CheckProductOrderRequest *param = [CheckProductOrderRequest new];
    
    
      [MBProgressHUD j_loading];
      param.checkDate = [[NSDate date] httpParameterString];
      param.checkManId = kGlobal.loginResult.merchantUser.fid;
      param.checkManName = kGlobal.loginResult.merchantUser.realName;
      param.checkKey = self.card.checkKey;
      WS(weakSelf);
      [kHttp POST:kCheckTicketUrl parameters:[param toDictionary] complete:^(id  _Nullable response, NSError * _Nullable error) {
        [MBProgressHUD j_hideLoadingView];
        if (kRsSuccess(response)) {
          [MBProgressHUD j_textOnly:@"核销成功！"];
          weakSelf.card.state = @"checked";
          [weakSelf configUIWithCard];
        }else{
          kShowRsMsg(response);
        }
      }];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
@end
