//
//  UIView+Category.h
//  ALand
//
//  Created by Z on 16/3/22.
//  Copyright © 2016年 Z. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface UIView (Category)
/**
 *  根据nib名字获取view
 */
+ (id)viewWithNibName:(NSString *)viewName;
/**
 *  根据类名获取对应的xib
 *
 *  @return view
 */
+ (id)viewFromNib;
/**
 *  获取view的控制器
 *
 *  @return 控制器
 */
- (UIViewController *)viewController;
/**
 *  控制底部弹出动画
 *
 *  @param constraint 视图底部到父视图底部的距离约束
 *  @param toBottom   视图底部到父视图底部的距离
 */
- (void)constraint:(NSLayoutConstraint *)constraint toBottom:(NSInteger)toBottom;

/**
 *  圆角
 */
@property (nonatomic, assign) IBInspectable CGFloat cornerRadius;

@property (assign, nonatomic) CGFloat top;
@property (assign, nonatomic) CGFloat bottom;
@property (assign, nonatomic) CGFloat left;
@property (assign, nonatomic) CGFloat right;

@property (assign, nonatomic) CGPoint offset;
@property (assign, nonatomic) CGPoint position;

@property (assign, nonatomic) CGFloat x;
@property (assign, nonatomic) CGFloat y;
@property (assign, nonatomic) CGFloat w;
@property (assign, nonatomic) CGFloat h;

@property (assign, nonatomic) CGFloat width;
@property (assign, nonatomic) CGFloat height;
@property (assign, nonatomic) CGSize size;

@property (assign, nonatomic) CGFloat centerX;
@property (assign, nonatomic) CGFloat centerY;
@property (assign, nonatomic) CGPoint	origin;
@property (readonly, nonatomic) CGPoint	boundsCenter;

@end
