//
//  AccountRecordViewController.m
//  Car
//
//  Created by Javen on 2017/2/9.
//  Copyright © 2017年 上海勾芒信息科技. All rights reserved.
//

#import "AccountRecordViewController.h"
#import "AccountRecordTableViewCell.h"
@interface AccountRecordViewController ()
@property (strong, nonatomic) WithdrawQueryDefintion *param;
@end

@implementation AccountRecordViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"提现记录";
    [self httpRequest];
    // Do any additional setup after loading the view.
}

- (void)httpRequest {
    WS(weakSelf);
    [MBProgressHUD j_loading];

    [kHttp POST:kUserCashRecord parameters:[self.param toDictionary] complete:^(id  _Nullable response, NSError * _Nullable error) {
        [MBProgressHUD j_hideLoadingView];
        if (kRsSuccess(response)) {
            for (NSDictionary *dict in response[@"data"][@"records"]) {
                DrawCashBillEntity *model = [[DrawCashBillEntity alloc] initWithDictionary:dict error:nil];
                [weakSelf.arrData addObject:model];
            }
            
            [weakSelf listTableViewReloadData];
        }else{
            kFalseHttpTips;
        }
    }];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    AccountRecordTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"AccountRecordTableViewCell" forIndexPath:indexPath];
    DrawCashBillEntity *model = self.arrData[indexPath.row];
    [cell configCell:model];
    
    return cell;
}

- (void)listDidSelect:(id)model {
    
}

- (WithdrawQueryDefintion *)param {
    if (!_param) {
        _param = [[WithdrawQueryDefintion alloc] init];
        QueryOrder *order = [[QueryOrder alloc] init];
        order.field = @"createDate";
        order.direction = @"desc";
        _param.orders = (NSArray<QueryOrder> *)@[order];
        _param.userId = kUser.fid;
        _param.pageSize = self.pageSize;
    }
        _param.pageNumber = self.page;
    return _param;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
