//
//  BillListViewController.m
//  Car
//
//  Created by Javen on 2016/12/27.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "BillListViewController.h"
#import "HttpCilent.h"
#import "BillListTableViewCell.h"
#import "BillHeaderModel.h"
@interface BillListViewController ()
@property (nonatomic, strong) NSMutableDictionary *dicMonthData;
@property (nonatomic, strong) NSMutableArray *arrSortedData;
@property (nonatomic, strong) NSMutableArray *arrSortedMonths;
@end

@implementation BillListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
  self.title = @"工分账单";
  [self httpRequest];
  self.tableView.mj_header = nil;
  WS(weakSelf);
  self.tableView.mj_footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
    weakSelf.page++;
    [weakSelf httpRequest];
  }];
    // Do any additional setup after loading the view.
}

- (void)httpRequest {
  NSDictionary *myDictionary = @{@"userId" : kUser.fid,
                                 @"pageNumber" : @(self.page),
                                 @"pageSize" : @(self.pageSize)};
  [MBProgressHUD j_loading];
  WS(weakSelf);
  [kHttp POST:kAccountQueryUrl parameters:myDictionary complete:^(id  _Nullable response, NSError * _Nullable error) {
    [MBProgressHUD j_hideLoadingView];
    if (kRsSuccess(response)) {
      for (NSDictionary *dict in response[@"data"][@"records"]) {
        StationUserAcctHisEntity *model = [[StationUserAcctHisEntity alloc] initWithDictionary:dict error:nil];
        [weakSelf.dicMonthData setObject:model forKey:[model.createDate substringToIndex:7]];
        [weakSelf.arrData addObject:model];
      }
      
      [weakSelf configData];
      [weakSelf listTableViewReloadData];
      
    }else{
      kShowRsMsg(response);
      if (self.page > 0) {
        self.page--;
      }
    }
  }];
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
  return self.arrSortedMonths.count;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
  return [self.arrSortedData[section] count];
}
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section {
  return 30;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
  return 50;
}
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section {
  UITableViewCell *header = [tableView dequeueReusableCellWithIdentifier:@"headerCell"];
  BillHeaderModel *model = self.arrSortedMonths[section];
  UILabel *month = (UILabel *)[header viewWithTag:1111];
  month.text = model.date;
  UILabel *money = (UILabel *)[header viewWithTag:2222];
  money.text = model.total;
  return header.contentView;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
  BillListTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"BillListTableViewCell" forIndexPath:indexPath];
  [cell configWithArray:self.arrSortedData indexPath:indexPath];
  return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
  [super tableView:tableView didSelectRowAtIndexPath:indexPath];
  kDebugIndex(indexPath);
}

- (void)listDidSelect:(id)model {
  
}

- (void)configData {
  [self.arrSortedData removeAllObjects];
  [self.arrSortedMonths removeAllObjects];
  
  //先把整体倒序排序一遍
  NSArray *tempSortData = [self.arrData sortedArrayUsingComparator:^NSComparisonResult(id  _Nonnull obj1, id  _Nonnull obj2) {
    StationUserAcctHisEntity *a = (StationUserAcctHisEntity *)obj1;
    StationUserAcctHisEntity *b = (StationUserAcctHisEntity *)obj2;
    return [b.createDate compare:a.createDate];
  }];
  
  NSArray *months = self.dicMonthData.allKeys;
  NSArray *sortMonths = [months sortedArrayUsingComparator:^NSComparisonResult(id  _Nonnull obj1, id  _Nonnull obj2) {
    return [obj2 compare:obj1];
  }];
  
  NSInteger count = sortMonths.count;
  for (NSInteger  i = 0; i < count; i++) {
    NSDecimalNumber *monthTotal = [CalculateHelper decimalNumber:0];
    NSMutableArray *array = [NSMutableArray array];
    for (StationUserAcctHisEntity *model in tempSortData) {
      NSString *timeStr = [model.createDate substringToIndex:7];
      if ([timeStr isEqualToString:sortMonths[i]]) {
        CLog(@"%@", model.createDate);
        monthTotal = [CalculateHelper add:monthTotal num2:model.occur];
        [array addObject:model];
      }
    }
    BillHeaderModel *headerModel = [[BillHeaderModel alloc] init];
    headerModel.date = sortMonths[i];
    headerModel.total = [CalculateHelper moneyStringWithPrefix:monthTotal];
    [self.arrSortedMonths addObject:headerModel];
    [self.arrSortedData addObject:array];
  }
}

#pragma mark - lazy

- (NSMutableDictionary *)dicMonthData {
  if (!_dicMonthData) {
    _dicMonthData = [NSMutableDictionary dictionary];
  }
  return _dicMonthData;
}

- (NSMutableArray *)arrSortedData {
  if (!_arrSortedData) {
    _arrSortedData = [NSMutableArray array];
  }
  return _arrSortedData;
}

- (NSMutableArray *)arrSortedMonths {
  if (!_arrSortedMonths) {
    _arrSortedMonths = [NSMutableArray array];
  }
  return _arrSortedMonths;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
