//
//  CardView.m
//  Car
//
//  Created by Javen on 2016/12/28.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "CardView.h"
#import "CalculateHelper.h"
@implementation CardView

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/
- (void)setModel:(CardModel *)model {
  _model = model;
  self.labelTitle.text = model.name;
  self.labelPrice.text = [model.total stringValue];
  self.labelDuration.text = [NSString stringWithFormat:@"%@~%@",[model.startDate substringToIndex:11],[model.endDate substringToIndex:11]];
  self.labelCondition.text = model.remak;
  self.labelCardNumber.text = kStrPrefix(model.ticketNumber, @"券号：");
  if ([model.state isEqualToString:@"used"]) {
    [self used];
  }else{
    [self unUse];
  }
}
- (void)unUse {
  self.imgBg.image = [UIImage imageNamed:@"orange_card_bg"];
  self.imgState.hidden = YES;
}

- (void)used {
  self.imgBg.image = [UIImage imageNamed:@"gray_card_bg"];
  self.imgState.hidden = NO;
}

@end
