//
//  LoginViewController.m
//  Car
//
//  Created by Javen on 2016/12/23.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "LoginViewController.h"
#import "MainViewController.h"
#import "LeftTableViewController.h"
#import "WWSideslipViewController.h"
#import "HttpCilent.h"
#import "BMKLocationService.h"
@interface LoginViewController () <BMKLocationServiceDelegate> {
    BMKLocationService *_locService;
}
@property (weak, nonatomic) IBOutlet UITextField *textFieldUser;
@property (weak, nonatomic) IBOutlet UITextField *textFieldPsw;
@property (strong, nonatomic) NSString *latitute;
@property (strong, nonatomic) NSString *longtitude;
@property (weak, nonatomic) IBOutlet UIButton *btnLogin;

@end

@implementation LoginViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self configUI];
    //初始化BMKLocationService
    _locService = [[BMKLocationService alloc] init];
    _locService.delegate = self;
    //启动LocationService

    WS(weakSelf);
    [kHttp checkUpdateOnVC:self
          completeIsLatest:^{
              weakSelf.btnLogin.enabled = YES;
          }];
    // Do any additional setup after loading the view.
}

//实现相关delegate 处理位置信息更新
//处理方向变更信息
- (void)didUpdateUserHeading:(BMKUserLocation *)userLocation {
    NSLog(@"heading is %@", userLocation.heading);
}
//处理位置坐标更新
- (void)didUpdateBMKUserLocation:(BMKUserLocation *)userLocation {
    self.longtitude = [NSString stringWithFormat:@"%f", userLocation.location.coordinate.longitude];
    self.latitute = [NSString stringWithFormat:@"%f", userLocation.location.coordinate.latitude];
    [_locService stopUserLocationService];
    NSLog(@"didUpdateUserLocation lat %f,long %f", userLocation.location.coordinate.latitude, userLocation.location.coordinate.longitude);
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    self.longtitude = nil;
    self.latitute = nil;
    [_locService startUserLocationService];
    [self.navigationController setNavigationBarHidden:YES animated:YES];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self.navigationController setNavigationBarHidden:NO animated:YES];
}

- (void)configUI {
    self.textFieldUser.text = kGlobal.userName;
    self.textFieldPsw.text = kGlobal.userPsw;
}

#pragma mark - actions
- (IBAction)actionLogin:(id)sender {

    kCanNotBeNil(self.textFieldUser.text, @"工号不能为空！");
    kCanNotBeNil(self.textFieldPsw.text, @"密码不能为空！");

    NSDictionary *myDictionary = @{
        @"userName" : self.textFieldUser.text,
        @"password" : self.textFieldPsw.text
    };
    WS(weakSelf);
    [MBProgressHUD j_loading:@"登录中…"];
    [kHttp POST:kLoginUrl
        parameters:myDictionary
          complete:^(id _Nullable response, NSError *_Nullable error) {
              [MBProgressHUD j_hideLoadingView];
              if (kRsSuccess(response)) {
                  UINavigationController *mainNaVC =
                      [self storyboardType:STORYBOARD_TYPE_MAIN
                                identifier:@"MainNavigationController"];
                  LeftTableViewController *leftVC = [LeftTableViewController
                      viewControllerWithStoryBoardType:STORYBOARD_TYPE_MAIN];
                  WWSideslipViewController *sideVC = [[WWSideslipViewController alloc]
                        initWithLeftView:leftVC
                             andMainView:mainNaVC
                            andRightView:nil
                      andBackgroundImage:[UIImage imageNamed:@"side_bg"]];
                  kGlobal.loginResult =
                      [[LoginResult alloc] initWithDictionary:response[@"data"]
                                                        error:nil];
                  kGlobal.sideSlipVC = sideVC;
                  kGlobal.mainNaVC = mainNaVC;
                  kGlobal.userName = weakSelf.textFieldUser.text;
                  kGlobal.userPsw = weakSelf.textFieldPsw.text;
                  sideVC.modalTransitionStyle = UIModalTransitionStyleCrossDissolve;
                  [self presentViewController:sideVC animated:YES completion:nil];
              } else {
                  kShowRsMsg(response);
              }
          }];
}
- (IBAction)actionForgetPsw:(id)sender {
    [MBProgressHUD j_textOnly:@"请联系管理员"];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little
preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
