//
//  OrderListTableViewCell.m
//  Car
//
//  Created by Javen on 2016/12/26.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "OrderListTableViewCell.h"
#import "OrderListModel.h"


@interface OrderListTableViewCell ()
@property (strong, nonatomic) OrderListModel *model;
@end
@implementation OrderListTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    [self.btnIsChecked setBackgroundImage:[UIImage imageNamed:@"radious_select_gray"] forState:UIControlStateDisabled | UIControlStateSelected];
    // Initialization code
}

- (void)configCellArray:(NSMutableArray *)array indexPath:(NSIndexPath *)indexPath isShow:(BOOL)isShow isAll:(BOOL)isAll{
    OrderListModel *model = array[indexPath.row];
    self.model = model;
    self.labelTime.text = model.payTime;
    self.labelStation.text = [NSString stringWithFormat:@"%@ - %@", model.stationName, model.stationUserName];
    self.labelOil.text = [NSString stringWithFormat:@"%@ - %@", model.gasItemName, model.oilGunName];
    self.labelBillNumber.text = model.billNumber;
    self.labelPrice.text = [CalculateHelper getMoneyStringFrom:model.realPayTotal];
    
    self.btnIsChecked.selected = model.isSelected;
    
    if ([model.checkState isEqualToString:@"checked"]) {
        self.btnIsChecked.enabled = NO;
    } else {
        self.btnIsChecked.enabled = YES;
    }
    
    self.btnIsChecked.hidden = !isShow;
}
- (IBAction)actionCheck:(UIButton *)sender {
    sender.selected = !sender.isSelected;
    self.model.isSelected = sender.isSelected;
    [[NSNotificationCenter defaultCenter] postNotificationName:kNotiSelectBill object:self.model];
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
