//
//  LoginInfo.m
//  Car
//
//  Created by Javen on 2016/12/23.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "GlobalInstance.h"

@interface GlobalInstance ()
@property (nonatomic, strong) NSMutableArray *arr;

@end

@implementation GlobalInstance

static GlobalInstance *global = nil;

+ (instancetype)shareInstance {
  static dispatch_once_t onceToken;
  dispatch_once(&onceToken, ^{
    global = [[GlobalInstance alloc] init];
  });
  return global;
}


- (void)setIsNoFirst:(BOOL)isNoFirst {
  _isNoFirst = isNoFirst;
  [[NSUserDefaults standardUserDefaults] setBool:isNoFirst forKey:@"firstIn"];
  [[NSUserDefaults standardUserDefaults] synchronize];
}

- (BOOL)isNoFirst {
  if (!_isNoFirst) {
    _isNoFirst = [[NSUserDefaults standardUserDefaults] boolForKey:@"firstIn"];
  }
  return _isNoFirst;
}

#pragma mark - userName 和userPsw的set和get方法
- (void)setUserName:(NSString *)userName {
  _userName = userName;
  [[NSUserDefaults standardUserDefaults] setObject:userName forKey:@"name"];
  [[NSUserDefaults standardUserDefaults] synchronize];
}

- (void)setUserPsw:(NSString *)userPsw {
  _userPsw = userPsw;
  [[NSUserDefaults standardUserDefaults] setObject:userPsw forKey:@"psw"];
  [[NSUserDefaults standardUserDefaults] synchronize];
}

- (NSString *)userName {
  if (!_userName) {
    _userName = [[NSUserDefaults standardUserDefaults] objectForKey:@"name"];
  }
  return _userName;
}

- (NSString *)userPsw {
  if (!_userPsw) {
    _userPsw = [[NSUserDefaults standardUserDefaults] objectForKey:@"psw"];
  }
  return _userPsw;
}


@end
