
#import <Foundation/Foundation.h>
#import "JSONModel.h"


/**
 *  排序方向。
 *
 *  @author Debenson
 *  @since 0.0.1
 */
/**
 * 升序
 */
extern NSString * const QUERYORDERDIRECTION_ASC;
/**
 * 降序
 */
extern NSString * const QUERYORDERDIRECTION_DESC;




@class QueryResultPaging;
@class QueryOrder;
@class ExceptionCode;
@class RsResponse;
@class LoginResult;
@class ModifyPasswordRequest;
@class CheckOrderRequest;
@class ResetPasswordRequest;
@class CheckProductOrderRequest;
@class TradeStatisticsResult;
@class StationUserAcctEntity;
@class TOAppversionEntity;
@class DrawCashBillEntity;
@class MerchantProductEntity;
@class ProductEntity;
@class OilGunEntity;
@class StationGasItemEntity;
@class OtherTicketEntity;
@class IdEntity;
@class ProductOrderEntity;
@class OrderEntity;
@class StationUserAcctHisEntity;
@class CheckTicketRequest;
@class MerchantLoginResult;
@class LoginRequest;
@class RsQueryResult;
@class QueryDefinition;
@class ProductOrderQueryDefintion;
@class TSBaseUser;
@class TSDepart;
@class ProductOrderQueryResult;
@class TSUserOrg;
@class OrderQueryResult;
@class WithdrawQueryDefintion;
@class OrderQueryDefintion;
@class WithdrawQueryResult;
@class AccountHistoryQueryResult;
@class AccountHistoryQueryDefintion;
@class StationEntity;
@class TSUser;
@class MerchantEntity;
@class StationUserEntity;
@class MerchantUserEntity;

@protocol QueryResultPaging @end
@protocol QueryOrder @end
@protocol ExceptionCode @end
@protocol RsResponse @end
@protocol LoginResult @end
@protocol ModifyPasswordRequest @end
@protocol CheckOrderRequest @end
@protocol ResetPasswordRequest @end
@protocol CheckProductOrderRequest @end
@protocol TradeStatisticsResult @end
@protocol StationUserAcctEntity @end
@protocol TOAppversionEntity @end
@protocol DrawCashBillEntity @end
@protocol MerchantProductEntity @end
@protocol ProductEntity @end
@protocol OilGunEntity @end
@protocol StationGasItemEntity @end
@protocol OtherTicketEntity @end
@protocol IdEntity @end
@protocol ProductOrderEntity @end
@protocol OrderEntity @end
@protocol StationUserAcctHisEntity @end
@protocol CheckTicketRequest @end
@protocol MerchantLoginResult @end
@protocol LoginRequest @end
@protocol RsQueryResult @end
@protocol QueryDefinition @end
@protocol ProductOrderQueryDefintion @end
@protocol TSBaseUser @end
@protocol TSDepart @end
@protocol ProductOrderQueryResult @end
@protocol TSUserOrg @end
@protocol OrderQueryResult @end
@protocol WithdrawQueryDefintion @end
@protocol OrderQueryDefintion @end
@protocol WithdrawQueryResult @end
@protocol AccountHistoryQueryResult @end
@protocol AccountHistoryQueryDefintion @end
@protocol StationEntity @end
@protocol TSUser @end
@protocol MerchantEntity @end
@protocol StationUserEntity @end
@protocol MerchantUserEntity @end


/**
 *  分页数据。
 
 @author Debenson
 @since 0.0.1
 
 */
@interface QueryResultPaging : JSONModel
/**
 * 当前页数，起始于0
 *
 *
 */
@property (nonatomic, assign) NSInteger page;
/**
 * 每页记录数，传0表示查询所有记录
 *
 *
 */
@property (nonatomic, assign) NSInteger pageSize;
/**
 * 查询结果总页数
 *
 *
 */
@property (nonatomic, assign) NSInteger pageCount;
/**
 * 查询结果总记录数
 *
 *
 */
@property (nonatomic, assign) long long recordCount;
@end /* interface QueryResultPaging */



/**
 *  查询排序条件。
 
 @author Debenson
 @since 0.0.1
 
 */
@interface QueryOrder : JSONModel
/**
 * 字段名称
 *
 *
 */
@property (nonatomic, copy) NSString *field;
/**
 * 排序方向
 *
 * 取值: QUERYORDERDIRECTION_ASC, QUERYORDERDIRECTION_DESC,
 */
@property (nonatomic, copy) NSString *direction;
@end /* interface QueryOrder */



/**
 *  异常代码。
 
 @author Debenson
 @since 0.1
 
 */
@interface ExceptionCode : JSONModel
/**
 * 异常代码
 *
 *
 */
@property (nonatomic, assign) NSInteger code;
/**
 * 异常信息
 *
 *
 */
@property (nonatomic, copy) NSString *message;
@end /* interface ExceptionCode */



/**
 *  Restful Service response base
 
 @author Debenson
 @since 0.1
 
 */
@interface RsResponse : JSONModel
/**
 * 0:正常， 非0异常。
 *
 *
 */
@property (nonatomic, assign) long long code;
/**
 * 异常描述
 *
 *
 */
@property (nonatomic, copy) NSString *message;
/**
 * 返回数据
 *
 *
 */
@property (nonatomic, strong) NSObject *data;
@end /* interface RsResponse */



/**
 *  登录结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface LoginResult : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, strong) StationUserEntity *user;
/**
 * 由当前位置定位的加油站。 <br/>
 * 如果登录时没有传LoginRequest#getLongitude() 或
 * LoginRequest#getLatitude()或无法定位将返回null。
 *
 *
 */
@property (nonatomic, strong) StationEntity *station;
/**
 * 创建订单的url，APP可以拿此值生成二维码让用户扫描直接进入下单界面
 *
 *
 */
@property (nonatomic, copy) NSString *createOrderUrl;
@end /* interface LoginResult */



/**
 *  修改密码请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface ModifyPasswordRequest : JSONModel
/**
 * 加油员用户名。
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * 原密码。
 *
 *
 */
@property (nonatomic, copy) NSString *oldPassword;
/**
 * 新密码
 *
 *
 */
@property (nonatomic, copy) NSString *fnewPassword;
@end /* interface ModifyPasswordRequest */



/**
 *  加油员对账请求。
 
 @author liyang
 @since 0.1
 
 */
@interface CheckOrderRequest : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *userId;
/**
 * (no documentation provided)
 * @see NSString
 *
 */
@property (nonatomic, strong) NSArray<NSString *> *orderIds;
@end /* interface CheckOrderRequest */



/**
 *  重置密码请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface ResetPasswordRequest : JSONModel
/**
 * 加油员用户名。
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * 短信验证码，请先调用发送短信接口
 *
 *
 */
@property (nonatomic, copy) NSString *smsCode;
/**
 * 新密码
 *
 *
 */
@property (nonatomic, copy) NSString *fnewPassword;
@end /* interface ResetPasswordRequest */



/**
 *  核券请求
 
 @author liyang
 @since 0.1
 
 */
@interface CheckProductOrderRequest : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *checkManId;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *checkManName;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *checkDate;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *checkKey;
@end /* interface CheckProductOrderRequest */



/**
 *  交易信息汇总。
 
 @author liyang
 @since 0.1
 
 */
@interface TradeStatisticsResult : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, assign) long long orderCount;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) double totalAmount;
@end /* interface TradeStatisticsResult */



/**
 *  @Title: Entity
 @Description: 加油员账户
 @author onlineGenerator
 @date 2016-11-17 19:47:38
 @version V1.0
 
 
 */
@interface StationUserAcctEntity : JSONModel
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得加油员标识
 *
 *
 */
@property (nonatomic, copy) NSString *userId;
/**
 * 方法: 取得加油员名称
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * 方法: 取得余额
 *
 *
 */
@property (nonatomic, strong) NSNumber *balance;
/**
 * 方法: 取得日订单数量
 *
 *
 */
@property (nonatomic, assign) NSInteger dailyBillCount;
/**
 * 方法: 取得可提现余额
 *
 *
 */
@property (nonatomic, strong) NSNumber *drawBalance;
@end /* interface StationUserAcctEntity */



/**
 *  @Title: Entity
 @Description: app应用更新信息
 @author onlineGenerator
 @date 2016-08-31 09:51:09
 @version V1.0
 
 
 */
@interface TOAppversionEntity : JSONModel
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得版本号
 *
 *
 */
@property (nonatomic, copy) NSString *version;
/**
 * 方法: 取得新版本下载路径
 *
 *
 */
@property (nonatomic, copy) NSString *url;
/**
 * 方法: 取得是否强制更新
 *
 *
 */
@property (nonatomic, copy) NSString *forceupdate;
/**
 * 方法: 取得app类型
 *
 *
 */
@property (nonatomic, copy) NSString *apptype;
@end /* interface TOAppversionEntity */



/**
 *  @Title: Entity
 @Description: 提现申请单
 @author onlineGenerator
 @date 2017-01-22 09:48:08
 @version V1.0
 
 
 */
@interface DrawCashBillEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 申请人姓名
 *
 *
 */
@property (nonatomic, copy) NSString *applicantName;
/**
 * 申请人id
 *
 *
 */
@property (nonatomic, copy) NSString *applicantId;
/**
 * 提现工分数量
 *
 *
 */
@property (nonatomic, strong) NSNumber *workpoint;
/**
 * 提现金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *cash;
/**
 * 状态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 审批人姓名
 *
 *
 */
@property (nonatomic, copy) NSString *approverName;
/**
 * 审批人id
 *
 *
 */
@property (nonatomic, copy) NSString *approverId;
/**
 * 复核人姓名
 *
 *
 */
@property (nonatomic, copy) NSString *checkerName;
/**
 * 复核人id
 *
 *
 */
@property (nonatomic, copy) NSString *checkerId;
/**
 * 拒绝理由
 *
 *
 */
@property (nonatomic, copy) NSString *cause;
/**
 * 单号
 *
 *
 */
@property (nonatomic, copy) NSString *billNumber;
/**
 * 结束日期
 *
 *
 */
@property (nonatomic, copy) NSString *finishDate;
/**
 * 审批日期
 *
 *
 */
@property (nonatomic, copy) NSString *approveDate;
@end /* interface DrawCashBillEntity */



/**
 *
 @Title: Entity
 @Description: 商户商品
 @author onlineGenerator
 @date 2017-03-09 13:21:33
 @version V1.0
 
 
 */
@interface MerchantProductEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 商户id
 *
 *
 */
@property (nonatomic, copy) NSString *merchantId;
/**
 * 商户名称
 *
 *
 */
@property (nonatomic, copy) NSString *merchantName;
/**
 * 商户代码
 *
 *
 */
@property (nonatomic, copy) NSString *merchantCode;
/**
 * 商品名称
 *
 *
 */
@property (nonatomic, copy) NSString *productId;
/**
 * 商品代码
 *
 *
 */
@property (nonatomic, copy) NSString *productCode;
/**
 * 商品类型
 *
 *
 */
@property (nonatomic, copy) NSString *productType;
/**
 * 商品价格
 *
 *
 */
@property (nonatomic, copy) NSString *productPrice;
/**
 * 商品描述
 *
 *
 */
@property (nonatomic, copy) NSString *productDescription;
/**
 * 有效期始
 *
 *
 */
@property (nonatomic, copy) NSString *validatedStartDate;
/**
 * 有效期至
 *
 *
 */
@property (nonatomic, copy) NSString *validatedEndDate;
/**
 * 商品图片
 *
 *
 */
@property (nonatomic, copy) NSString *productImageUrl;
@end /* interface MerchantProductEntity */



/**
 *
 @Title: Entity
 @Description: 商品
 @author onlineGenerator
 @date 2017-03-09 13:24:43
 @version V1.0
 
 
 */
@interface ProductEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 代码
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 价格
 *
 *
 */
@property (nonatomic, strong) NSNumber *price;
/**
 * 描述
 *
 *
 */
@property (nonatomic, copy) NSString *fdescription;
/**
 * 有效期开始
 *
 *
 */
@property (nonatomic, copy) NSString *validatedStartDate;
/**
 * 有效期结束
 *
 *
 */
@property (nonatomic, copy) NSString *validatedEndDate;
/**
 * 商品类型
 *
 *
 */
@property (nonatomic, copy) NSString *type;
/**
 * 商品图片链接
 *
 *
 */
@property (nonatomic, copy) NSString *imageUrl;
@end /* interface ProductEntity */



/**
 *  @Title: Entity
 @Description: 油站油枪
 @author onlineGenerator
 @date 2016-11-17 20:47:02
 @version V1.0
 
 
 */
@interface OilGunEntity : JSONModel
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得编码
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得油品标识
 *
 *
 */
@property (nonatomic, copy) NSString *gasItemId;
/**
 * 方法: 取得油品编码
 *
 *
 */
@property (nonatomic, copy) NSString *gasItemCode;
/**
 * 方法: 取得油品名称
 *
 *
 */
@property (nonatomic, copy) NSString *gasItemName;
/**
 * 方法: 取得油站标识
 *
 *
 */
@property (nonatomic, copy) NSString *stationId;
@end /* interface OilGunEntity */



/**
 *  @Title: Entity
 @Description: 油站油品
 @author onlineGenerator
 @date 2016-11-17 20:47:02
 @version V1.0
 
 
 */
@interface StationGasItemEntity : JSONModel
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得油站标识
 *
 *
 */
@property (nonatomic, copy) NSString *stationId;
/**
 * 方法: 取得油品
 *
 *
 */
@property (nonatomic, copy) NSString *gasItemId;
/**
 * 方法: 取得油品编码
 *
 *
 */
@property (nonatomic, copy) NSString *gasItemCode;
/**
 * 方法: 取得油品名称
 *
 *
 */
@property (nonatomic, copy) NSString *gasItemName;
/**
 * 方法: 取得序号
 *
 *
 */
@property (nonatomic, assign) NSInteger num;
@end /* interface StationGasItemEntity */



/**
 *  @Title: Entity
 @Description: 非油券
 @author onlineGenerator
 @date 2016-11-30 13:28:57
 @version V1.0
 
 
 */
@interface OtherTicketEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 券号
 *
 *
 */
@property (nonatomic, copy) NSString *ticketNumber;
/**
 * 名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 类型
 *
 *
 */
@property (nonatomic, copy) NSString *type;
/**
 * 面额
 *
 *
 */
@property (nonatomic, strong) NSNumber *total;
/**
 * 实际抵扣金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *realPayTotal;
/**
 * 状态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 所属会员
 *
 *
 */
@property (nonatomic, copy) NSString *memberId;
/**
 * 所属会员名称
 *
 *
 */
@property (nonatomic, copy) NSString *memberName;
/**
 * 订单单号
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 * 有效期始
 *
 *
 */
@property (nonatomic, copy) NSString *startDate;
/**
 * 有效期止
 *
 *
 */
@property (nonatomic, copy) NSString *endDate;
/**
 * 使用说明
 *
 *
 */
@property (nonatomic, copy) NSString *remak;
/**
 * 发券时间
 *
 *
 */
@property (nonatomic, copy) NSString *distributeDate;
@end /* interface OtherTicketEntity */



/**
 * (no documentation provided)
 */
@interface IdEntity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
@end /* interface IdEntity */



/**
 *
 @Title: Entity
 @Description: 商品订单
 @author onlineGenerator
 @date 2017-03-13 13:54:24
 @version V1.0
 
 
 */
@interface ProductOrderEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 商品id
 *
 *
 */
@property (nonatomic, copy) NSString *productId;
/**
 * 商品名称
 *
 *
 */
@property (nonatomic, copy) NSString *productName;
/**
 * 商品代码
 *
 *
 */
@property (nonatomic, copy) NSString *productCode;
/**
 * 总金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *total;
/**
 * 实际支付金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *realPayTotal;
/**
 * 优惠金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *discountAmount;
/**
 * 支付时间
 *
 *
 */
@property (nonatomic, copy) NSString *payTime;
/**
 * 商户id
 *
 *
 */
@property (nonatomic, copy) NSString *merchantId;
/**
 * 商户名称
 *
 *
 */
@property (nonatomic, copy) NSString *merchantName;
/**
 * 商户代码
 *
 *
 */
@property (nonatomic, copy) NSString *merchantCode;
/**
 * 会员id
 *
 *
 */
@property (nonatomic, copy) NSString *mermberId;
/**
 * 会员名称
 *
 *
 */
@property (nonatomic, copy) NSString *memberName;
/**
 * 优惠券id
 *
 *
 */
@property (nonatomic, copy) NSString *couponId;
/**
 * 优惠券号
 *
 *
 */
@property (nonatomic, copy) NSString *couponNumber;
/**
 * 兑换码
 *
 *
 */
@property (nonatomic, copy) NSString *checkKey;
/**
 * 单号
 *
 *
 */
@property (nonatomic, copy) NSString *billNumber;
/**
 * 转态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 支付方式
 *
 *
 */
@property (nonatomic, copy) NSString *payMethod;
/**
 * 支付流水号
 *
 *
 */
@property (nonatomic, copy) NSString *payFlowNum;
/**
 * 支付失败原因
 *
 *
 */
@property (nonatomic, copy) NSString *payFailedMsg;
/**
 * 买家支付宝用户号
 *
 *
 */
@property (nonatomic, copy) NSString *alipayBuyerId;
/**
 * 买家支付宝账号
 *
 *
 */
@property (nonatomic, copy) NSString *alipaybuyerLogonId;
/**
 * 会员手机号
 *
 *
 */
@property (nonatomic, copy) NSString *memberMobilephone;
/**
 * 优惠券名称
 *
 *
 */
@property (nonatomic, copy) NSString *couponName;
/**
 * 商品图片
 *
 *
 */
@property (nonatomic, copy) NSString *productImageUrl;
@property (nonatomic, copy) NSString *validatedEndDate;
@property (nonatomic, copy) NSString *validatedStartDate;
@end /* interface ProductOrderEntity */



/**
 *  @Title: Entity
 @Description: 加油单
 @author onlineGenerator
 @date 2016-11-17 19:48:57
 @version V1.0
 
 
 */
@interface OrderEntity : JSONModel
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得单号
 *
 *
 */
@property (nonatomic, copy) NSString *billNumber;
/**
 * 方法: 取得油站标识
 *
 *
 */
@property (nonatomic, copy) NSString *stationId;
/**
 * 方法: 取得油站名称
 *
 *
 */
@property (nonatomic, copy) NSString *stationName;
/**
 * 方法: 取得加油员标识
 *
 *
 */
@property (nonatomic, copy) NSString *stationUserId;
/**
 * 方法: 取得加油员名称
 *
 *
 */
@property (nonatomic, copy) NSString *stationUserName;
/**
 * 方法: 取得加油员真实姓名
 *
 *
 */
@property (nonatomic, copy) NSString *stationUserRealName;
/**
 * 方法: 取得会员标识
 *
 *
 */
@property (nonatomic, copy) NSString *memberId;
/**
 * 方法: 取得会员名称
 *
 *
 */
@property (nonatomic, copy) NSString *memberName;
/**
 * 方法: 取得会员手机号
 *
 *
 */
@property (nonatomic, copy) NSString *memberMobilephone;
/**
 * 方法: 取得油枪标识
 *
 *
 */
@property (nonatomic, copy) NSString *oilGunId;
/**
 * 方法: 取得油枪名称
 *
 *
 */
@property (nonatomic, copy) NSString *oilGunName;
/**
 * 方法: 取得油品标识
 *
 *
 */
@property (nonatomic, copy) NSString *gasItemId;
/**
 * 方法: 取得油品名称
 *
 *
 */
@property (nonatomic, copy) NSString *gasItemName;
/**
 * 方法: 取得订单总金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *total;
/**
 * 方法: 取得实付金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *realPayTotal;
/**
 * 方法: 取得支付时间
 *
 *
 */
@property (nonatomic, copy) NSString *payTime;
/**
 * 方法: 取得支付方���
 *
 *
 */
@property (nonatomic, copy) NSString *payMethod;
/**
 * 方法: 取得销售提成
 *
 *
 */
@property (nonatomic, strong) NSNumber *deduct;
/**
 * 方法: 取得是否开票
 *
 *
 */
@property (nonatomic, copy) NSString *invoice;
/**
 * 方法: 取得小票打印次数
 *
 *
 */
@property (nonatomic, assign) NSInteger printed;
/**
 * 方法: 取得最后打印时间
 *
 *
 */
@property (nonatomic, copy) NSString *lstPrintedTime;
/**
 * 方法: 取得支付流水号
 *
 *
 */
@property (nonatomic, copy) NSString *payFlowNum;
/**
 * 方法: 取得订单状态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 方法: 取得备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *printId;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *vehicleNo;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *payFailedMsg;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *printState;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *invoiceId;
/**
 * 买家支付宝用户号
 *
 *
 */
@property (nonatomic, copy) NSString *alipayBuyerId;
/**
 * 买家支付宝账号
 *
 *
 */
@property (nonatomic, copy) NSString *alipaybuyerLogonId;
/**
 * 对账状态
 *
 *
 */
@property (nonatomic, copy) NSString *checkState;
@end /* interface OrderEntity */



/**
 *  @Title: Entity
 @Description: 加油员账户流水
 @author onlineGenerator
 @date 2016-11-17 19:48:43
 @version V1.0
 
 
 */
@interface StationUserAcctHisEntity : JSONModel
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得加油员标识
 *
 *
 */
@property (nonatomic, copy) NSString *userId;
/**
 * 方法: 取得变化前余额
 *
 *
 */
@property (nonatomic, strong) NSNumber *oldBalance;
/**
 * 方法: 取得发生额
 *
 *
 */
@property (nonatomic, strong) NSNumber *occur;
/**
 * 方法: 取得变化后余额
 *
 *
 */
@property (nonatomic, strong) NSNumber *fnewBalance;
/**
 * 方法: 取得业务单号
 *
 *
 */
@property (nonatomic, copy) NSString *billNumber;
/**
 * 方法: 取得业务动作
 *
 *
 */
@property (nonatomic, copy) NSString *action;
/**
 * 方法: 取得备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 方法: 取得加油员名称
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * 方法: 取得交易编号
 *
 *
 */
@property (nonatomic, assign) NSInteger tradeNo;
@end /* interface StationUserAcctHisEntity */



/**
 *  核券请求
 
 @author liyang
 @since 0.1
 
 */
@interface CheckTicketRequest : JSONModel
/**
 * 券号
 *
 *
 */
@property (nonatomic, copy) NSString *ticketNumber;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *checkManId;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *checkManName;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *checkDate;
@end /* interface CheckTicketRequest */



/**
 *  登录结果。
 
 @author liyang
 @since 0.1
 
 */
@interface MerchantLoginResult : JSONModel
/**
 * 获取商户
 *
 *
 */
@property (nonatomic, strong) MerchantEntity *merchant;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) MerchantUserEntity *merchantUser;
@end /* interface MerchantLoginResult */



/**
 *  加油员登录请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface LoginRequest : JSONModel
/**
 * 用户名，不可空
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * 密码，不可空
 *
 *
 */
@property (nonatomic, copy) NSString *password;
/**
 * 当前经度 ，可空
 *
 *
 */
@property (nonatomic, copy) NSString *longitude;
/**
 * 当前纬度 ，可空
 *
 *
 */
@property (nonatomic, copy) NSString *latitude;
@end /* interface LoginRequest */



/**
 *  查询结果。
 
 <br>
 查询结果基类， 具体结果集合由子类定义。
 
 @author Debenson
 @since 0.0.1
 
 */
@interface RsQueryResult : JSONModel
/**
 * 分页数据
 *
 *
 */
@property (nonatomic, strong) QueryResultPaging *paging;
/**
 * 当前页数
 *
 *
 */
@property (nonatomic, assign) NSInteger page;
/**
 * 每页记录数
 *
 *
 */
@property (nonatomic, assign) NSInteger pageSize;
/**
 * 总页数
 *
 *
 */
@property (nonatomic, assign) NSInteger pageCount;
/**
 * 总记录数
 *
 *
 */
@property (nonatomic, assign) long long recordCount;
@end /* interface RsQueryResult */



/**
 *  查询定义。
 
 <br>
 查询定义的基类，具体查询条件由子类实现。
 
 @author Debenson
 @since 0.1
 
 */
@interface QueryDefinition : JSONModel
/**
 * 排序条件
 * @see QueryOrder
 *
 */
@property (nonatomic, strong) NSArray<QueryOrder> *orders;
/**
 * 页数，表示查询第几页
 *
 *
 */
@property (nonatomic, assign) NSInteger pageNumber;
/**
 * 每页的记录数，传0表示查询所有数据不分页
 *
 *
 */
@property (nonatomic, assign) NSInteger pageSize;
@end /* interface QueryDefinition */



/**
 *  账户订单查询。
 
 @author liyang
 @since 0.1
 
 */
@interface ProductOrderQueryDefintion : QueryDefinition
/**
 * 加油员Id
 *
 *
 */
@property (nonatomic, copy) NSString *userId;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *billNumberLike;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *endDate;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *beginDate;
/**
 * 商户ID
 *
 *
 */
@property (nonatomic, copy) NSString *merchantId;
@end /* interface ProductOrderQueryDefintion */



/**
 *  系统用户父类表
 
 @author 张代浩
 
 */
@interface TSBaseUser : IdEntity
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *userType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *departid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSData *signature;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *browser;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *userKey;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) short status;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) short activitiSync;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *password;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *realName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *currentDepart;
/**
 * (no documentation provided)
 * @see TSUserOrg
 *
 */
@property (nonatomic, strong) NSArray<TSUserOrg> *userOrgList;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) short deleteFlag;
@end /* interface TSBaseUser */



/**
 *  部门机构表
 
 @author 张代浩
 
 */
@interface TSDepart : IdEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *TSPDepart;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *departname;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fdescription;
/**
 * (no documentation provided)
 * @see TSDepart
 *
 */
@property (nonatomic, strong) NSArray<TSDepart> *TSDeparts;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orgCode;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orgType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *mobile;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fax;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *address;
@end /* interface TSDepart */



/**
 *  订单查询结果。
 
 @author liyang
 @since 0.1
 
 */
@interface ProductOrderQueryResult : RsQueryResult
/**
 * 查询结果集合
 * @see ProductOrderEntity
 *
 */
@property (nonatomic, strong) NSArray<ProductOrderEntity> *records;
@end /* interface ProductOrderQueryResult */



/**
 *  用户-组织机构 实体
 <p/>
 <p>
 <b>User:</b> zhanggm
 <a href="mailto:guomingzhang2008@gmail.com">guomingzhang2008@gmail.com</a>
 </p>
 <p>
 <b>Date:</b> 2014-08-22 15:39
 </p>
 
 @author 张国明
 
 */
@interface TSUserOrg : IdEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSUser *tsUser;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *tsDepart;
@end /* interface TSUserOrg */



/**
 *  订单查询结果。
 
 @author liyang
 @since 0.1
 
 */
@interface OrderQueryResult : RsQueryResult
/**
 * 查询结果集合
 * @see OrderEntity
 *
 */
@property (nonatomic, strong) NSArray<OrderEntity> *records;
/**
 *
 *
 *
 */
@property (nonatomic, strong) TradeStatisticsResult *total;
@end /* interface OrderQueryResult */



/**
 *  账户流水查询。
 
 @author liyang
 @since 0.1
 
 */
@interface WithdrawQueryDefintion : QueryDefinition
/**
 * 加油员Id
 *
 *
 */
@property (nonatomic, copy) NSString *userId;
/**
 * 用户名称类似于
 *
 *
 */
@property (nonatomic, copy) NSString *userNameLike;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *billNumberLike;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *endDate;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *beginDate;
@end /* interface WithdrawQueryDefintion */



/**
 *  账户流水查询。
 
 @author liyang
 @since 0.1
 
 */
@interface OrderQueryDefintion : QueryDefinition
/**
 * 加油员Id
 *
 *
 */
@property (nonatomic, copy) NSString *userId;
/**
 * 用户名称类似于
 *
 *
 */
@property (nonatomic, copy) NSString *userNameLike;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *billNumberLike;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *endDate;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *beginDate;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *checkState;
@end /* interface OrderQueryDefintion */



/**
 *  订单查询结果。
 
 @author liyang
 @since 0.1
 
 */
@interface WithdrawQueryResult : RsQueryResult
/**
 * 查询结果集合
 * @see DrawCashBillEntity
 *
 */
@property (nonatomic, strong) NSArray<DrawCashBillEntity> *records;
@end /* interface WithdrawQueryResult */



/**
 *  订单查询结果。
 
 @author liyang
 @since 0.1
 
 */
@interface AccountHistoryQueryResult : RsQueryResult
/**
 * 查询结果集合
 * @see StationUserAcctHisEntity
 *
 */
@property (nonatomic, strong) NSArray<StationUserAcctHisEntity> *records;
@end /* interface AccountHistoryQueryResult */



/**
 *  账户流水查询。
 
 @author liyang
 @since 0.1
 
 */
@interface AccountHistoryQueryDefintion : QueryDefinition
/**
 * 加油员Id
 *
 *
 */
@property (nonatomic, copy) NSString *userId;
/**
 * 起始时间
 *
 *
 */
@property (nonatomic, copy) NSString *beginDate;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *endDate;
@end /* interface AccountHistoryQueryDefintion */



/**
 *  @Title: Entity
 @Description: 油站
 @author onlineGenerator
 @date 2016-11-17 20:47:03
 @version V1.0
 
 
 */
@interface StationEntity : TSDepart
/**
 * 方法: 取得创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得省市
 *
 *
 */
@property (nonatomic, copy) NSString *province;
/**
 * 方法: 取得市区
 *
 *
 */
@property (nonatomic, copy) NSString *city;
/**
 * 方法: 取得区县
 *
 *
 */
@property (nonatomic, copy) NSString *county;
/**
 * 方法: 取得品牌
 *
 *
 */
@property (nonatomic, copy) NSString *brand;
/**
 * 方法: 取得经度
 *
 *
 */
@property (nonatomic, copy) NSString *longitude;
/**
 * 方法: 取得纬度
 *
 *
 */
@property (nonatomic, copy) NSString *latitude;
/**
 * 方法: 取得是否合作油站
 *
 *
 */
@property (nonatomic, copy) NSString *partner;
/**
 * 方法: 取得服务
 *
 *
 */
@property (nonatomic, copy) NSString *services;
/**
 * 方法: 取得评分
 *
 *
 */
@property (nonatomic, copy) NSString *grade;
/**
 * 方法: 取得备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *printerMachineCode;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *printerKey;
@end /* interface StationEntity */



/**
 *  系统用户表
 
 @author 张代浩
 
 */
@interface TSUser : TSBaseUser
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *signatureFile;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *mobilePhone;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *officePhone;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *email;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
@end /* interface TSUser */



/**
 *
 @Title: Entity
 @Description: 商户
 @author onlineGenerator
 @date 2017-03-09 13:21:33
 @version V1.0
 
 
 */
@interface MerchantEntity : TSDepart
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 纬度
 *
 *
 */
@property (nonatomic, copy) NSString *latitude;
/**
 * 经度
 *
 *
 */
@property (nonatomic, copy) NSString *longtitude;
/**
 * 联系方式
 *
 *
 */
@property (nonatomic, copy) NSString *telephone;
/**
 * 附件id
 *
 *
 */
@property (nonatomic, copy) NSString *attachmentId;
/**
 * 邮箱
 *
 *
 */
@property (nonatomic, copy) NSString *email;
/**
 * 状态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
@end /* interface MerchantEntity */



/**
 *  @Title: Entity
 @Description: 油站员工
 @author onlineGenerator
 @date 2016-11-17 19:43:01
 @version V1.0
 
 
 */
@interface StationUserEntity : TSUser
/**
 * openId
 *
 *
 */
@property (nonatomic, copy) NSString *wxOpenId;
/**
 * 方法: 取得工号
 *
 *
 */
@property (nonatomic, copy) NSString *worknum;
@end /* interface StationUserEntity */



/**
 *  @Title: Entity
 @Description: 商户人员
 @author onlineGenerator
 @date 2017-03-21 09:34:27
 @version V1.0
 
 
 */
@interface MerchantUserEntity : TSUser
/**
 * 方法: 取得工号
 *
 *
 */
@property (nonatomic, copy) NSString *worknum;
@end /* interface MerchantUserEntity */


