//
//  UIViewController+Additions.m
//  RealEstateManagement
//
//  Created by Z on 16/7/23.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "UIViewController+Additions.h"

@interface UIViewController (Addtions)

@end

@implementation UIViewController (Additions)
- (id)storyboardType:(STORYBOARD_TYPE_)type identifier:(NSString *)identifier {
  UIStoryboard *storyboard;
  switch (type) {
  case STORYBOARD_TYPE_MAIN: {
    storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
    break;
  }
  }
  return [storyboard instantiateViewControllerWithIdentifier:identifier];

  //    id obj;
  //    NSString *message;
  //    if (obj == nil) {
  //        [MBProgressHUD j_error:message complete:nil];
  //        return;
  //    }
  //    if ([obj isKindOfClass:[NSString class]]) {
  //        NSString *string = (NSString *) obj;
  //        if ([string length] == 0) {
  //            [MBProgressHUD j_error:message complete:nil];
  //            return;
  //        }
  //    }
  //    if ([obj isKindOfClass:[NSArray class]]) {
  //        NSArray *array = (NSArray *) obj;
  //        if (array.count == 0) {
  //            [MBProgressHUD j_error:message complete:nil];
  //            return;
  //        }
  //    }
}

/**
 *  从不同storyBoard获取控制器（这里storyBoard的id必须和类名一致）
 *
 *  @param type storyBoard类型
 *
 *  @return 对应控制器
 */
+ (id __nonnull)viewControllerWithStoryBoardType:(STORYBOARD_TYPE_)type {
  NSString *identifier = NSStringFromClass(self);
  UIStoryboard *storyboard;
  switch (type) {
  case STORYBOARD_TYPE_MAIN: {
    storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
    break;
  }
  }
  return [storyboard instantiateViewControllerWithIdentifier:identifier];
}

- (void)alertTitle:(NSString *__nullable)title
               msg:(NSString *__nullable)msg
          okAction:
              (void (^__nullable)(UIAlertAction *__nullable action))okAction
      cancelAction:
          (void (^__nullable)(UIAlertAction *__nullable action))cancelAction {
  UIAlertController *alert =
      [UIAlertController alertControllerWithTitle:title
                                          message:msg
                                   preferredStyle:UIAlertControllerStyleAlert];
  UIAlertAction *ok = [UIAlertAction actionWithTitle:@"确定"
                                               style:UIAlertActionStyleDefault
                                             handler:okAction];
  [alert addAction:ok];
  UIAlertAction *cancel =
      [UIAlertAction actionWithTitle:@"取消"
                               style:UIAlertActionStyleCancel
                             handler:cancelAction];
  [alert addAction:cancel];
  if (self.navigationController) {
    [self.navigationController presentViewController:alert
                                            animated:YES
                                          completion:nil];
  } else {
    [self presentViewController:alert animated:YES completion:nil];
  }
}

- (void)hasPermission:(BOOL)permission
                  yes:(void (^)(void))yes
                   no:(void (^)(void))no {
  if (permission) {
    if (yes) {
      yes();
    }
  } else {
    if (no) {
      no();
    }
  }
}

- (BOOL)regIsValidDecimalInputtextField:(UITextField *)textField
                                  Range:(NSRange)range
                      replacementString:(NSString *)string {
  //获取改变之后的字符串
  NSMutableString *futureString =
      [NSMutableString stringWithString:textField.text];
  [futureString insertString:string atIndex:range.location];
  //金额输入
  NSString *reg =
      @"^-?$|^-0$|^\\d?$|^-?[1-9]\\d*$|^-?0\\.\\d*$|^-?[1-9]\\d*\\.\\d{0,2}$";
  NSPredicate *numberPre =
      [NSPredicate predicateWithFormat:@"SELF MATCHES %@", reg];
  return [numberPre evaluateWithObject:futureString];
}

@end
