//
//  LeftTableViewController.m
//  Car
//
//  Created by Javen on 2016/12/23.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "LeftTableViewController.h"
#import "HttpCilent.h"
#import "ModifyPswTableViewController.h"
#import "BillListViewController.h"
#import "ScanViewController.h"
#import <AudioToolbox/AudioToolbox.h>
@interface LeftTableViewController ()
@property (weak, nonatomic) IBOutlet UIImageView *imgUserIcon;
@property (weak, nonatomic) IBOutlet UILabel *labelName;
@property (weak, nonatomic) IBOutlet UILabel *labelScore;
@property (strong, nonatomic) StationUserAcctEntity *acct;

@end

@implementation LeftTableViewController

- (void)viewDidLoad {
    [super viewDidLoad];
  //设置文字和图标的颜色
  self.navigationController.navigationBar.tintColor = [UIColor whiteColor];
}

- (void)viewWillAppear:(BOOL)animated {
  [super viewWillAppear:animated];
  [self httpRequest];
}

- (void)httpRequest {
  NSDictionary *param = @{@"userId":kUser.fid};
  WS(weakSelf);
  [kHttp GET:kAccountGetUrl parameters:param complete:^(id  _Nullable response, NSError * _Nullable error) {
    if (kRsSuccess(response)) {
      weakSelf.acct = [[StationUserAcctEntity alloc] initWithDictionary:response[@"data"] error:nil];
      [weakSelf configUIWithAcct];
    }
  }];
}

- (void)configUIWithAcct {
  self.labelName.text = kUser.realName;
  self.labelScore.text = [CalculateHelper getMoneyStringFrom:self.acct.balance];
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
  [tableView deselectRowAtIndexPath:indexPath animated:YES];
  [kGlobal.sideSlipVC showMainView];
  
  if (indexPath.row == 0) {//工分账单
    BillListViewController *billVC = [BillListViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_MAIN];
    [kGlobal.mainNaVC pushViewController:billVC animated:YES];
  }else if (indexPath.row == 1) {//账户
    [MBProgressHUD j_textOnly:@"正在开发中~"];
  }else if (indexPath.row == 2) {//核销卡券
    [self scanCard];
    
  }else if (indexPath.row == 3){
    [self scanWatchCode];
  }else if (indexPath.row == 4) {//修改密码
    ModifyPswTableViewController *modifyVC = [ModifyPswTableViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_MAIN];
    [kGlobal.mainNaVC pushViewController:modifyVC animated:YES];
  }else if (indexPath.row == 5) {//退出登录
    
    [kGlobal.sideSlipVC dismissViewControllerAnimated:YES completion:nil];
  }
}

- (void)scanCard {
  //设置扫码区域参数
  LBXScanViewStyle *style = [[LBXScanViewStyle alloc]init];
  style.centerUpOffset = 44;
  style.photoframeAngleStyle = LBXScanViewPhotoframeAngleStyle_Inner;
  style.photoframeLineW = 2;
  style.photoframeAngleW = 18;
  style.photoframeAngleH = 18;
  style.isNeedShowRetangle = YES;
  
  style.anmiationStyle = LBXScanViewAnimationStyle_LineMove;
  
  style.colorAngle = [UIColor colorWithRed:0./255 green:200./255. blue:20./255. alpha:1.0];
  
  
  //qq里面的线条图片
  UIImage *imgLine = [UIImage imageNamed:@"CodeScan.bundle/qrcode_Scan_weixin_Line"];
  
  // imgLine = [self createImageWithColor:[UIColor colorWithRed:120/255. green:221/255. blue:71/255. alpha:1.0]];
  
  style.animationImage = imgLine;
  
  ScanViewController *vc = [ScanViewController new];
  vc.style = style;
  vc.type = scanTypeCard;
  [kGlobal.mainNaVC pushViewController:vc animated:YES];
}

- (void)scanWatchCode {
  //设置扫码区域参数
  LBXScanViewStyle *style = [[LBXScanViewStyle alloc]init];
  style.centerUpOffset = 44;
  style.photoframeAngleStyle = LBXScanViewPhotoframeAngleStyle_Inner;
  style.photoframeLineW = 2;
  style.photoframeAngleW = 18;
  style.photoframeAngleH = 18;
  style.isNeedShowRetangle = YES;
  
  style.anmiationStyle = LBXScanViewAnimationStyle_LineMove;
  
  style.colorAngle = [UIColor colorWithRed:0./255 green:200./255. blue:20./255. alpha:1.0];
  
  
  //qq里面的线条图片
  UIImage *imgLine = [UIImage imageNamed:@"CodeScan.bundle/qrcode_Scan_weixin_Line"];
  
  // imgLine = [self createImageWithColor:[UIColor colorWithRed:120/255. green:221/255. blue:71/255. alpha:1.0]];
  
  style.animationImage = imgLine;
  
  ScanViewController *vc = [ScanViewController new];
  vc.style = style;
  vc.type = scanTypeLogin;
  //vc.isOpenInterestRect = YES;
  [kGlobal.mainNaVC pushViewController:vc animated:YES];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:; forIndexPath:indexPath];
    
    // Configure the cell...
    
    return cell;
}
*/

/*
// Override to support conditional editing of the table view.
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the specified item to be editable.
    return YES;
}
*/

/*
// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        // Delete the row from the data source
        [tableView deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
    } else if (editingStyle == UITableViewCellEditingStyleInsert) {
        // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view
    }   
}
*/

/*
// Override to support rearranging the table view.
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath {
}
*/

/*
// Override to support conditional rearranging of the table view.
- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the item to be re-orderable.
    return YES;
}
*/

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
