//
//  OrderDetailViewController.m
//  Car
//
//  Created by Javen on 2016/12/27.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "OrderDetailViewController.h"
#import "HttpCilent.h"
@interface OrderDetailViewController ()
/** 单号 */
@property (weak, nonatomic) IBOutlet UILabel *labelBillNumber;
/** 状态 */
@property (weak, nonatomic) IBOutlet UILabel *labelState;
/** 油站 */
@property (weak, nonatomic) IBOutlet UILabel *labelStation;
/** 加油员 */
@property (weak, nonatomic) IBOutlet UILabel *labelStationUser;
/** 油枪 */
@property (weak, nonatomic) IBOutlet UILabel *labelGun;
/** 油品 */
@property (weak, nonatomic) IBOutlet UILabel *labelOil;
/** 顾客 */
@property (weak, nonatomic) IBOutlet UILabel *labelCustomer;
/** 支付方式 */
@property (weak, nonatomic) IBOutlet UILabel *labelPayment;
/** 支付时间 */
@property (weak, nonatomic) IBOutlet UILabel *labelPayTime;
/** 应付金额 */
@property (weak, nonatomic) IBOutlet UILabel *labelPrice;

/**
 抵用券金额
 */
@property (weak, nonatomic) IBOutlet UILabel *labelVoucher;
/** 实付金额 */
@property (weak, nonatomic) IBOutlet UILabel *labelRealPrice;
/** 工分 */
@property (weak, nonatomic) IBOutlet UILabel *labelDeduct;
/** 是否开票 */
@property (weak, nonatomic) IBOutlet UILabel *labelIsInvoice;
/** 是否打印 */
@property (weak, nonatomic) IBOutlet UILabel *labelIsPrint;
/** 最后一次打印时间 */
@property (weak, nonatomic) IBOutlet UILabel *labelLatestPrintTime;

@end

@implementation OrderDetailViewController

- (void)viewDidLoad {
  [super viewDidLoad];
  
  [self configUI];
    // Do any additional setup after loading the view.
}

- (void)configUI {
  self.title = @"加油单详情";
  UIBarButtonItem *rightBtn = [[UIBarButtonItem alloc] initWithTitle:@"重新打印" style:UIBarButtonItemStyleDone target:self action:@selector(actionRePrint)];
  self.navigationItem.rightBarButtonItem = rightBtn;
  
  self.labelBillNumber.text = kStrPrefix(self.model.billNumber, @"单号：");
  self.labelState.text = self.model.stateString;
  self.labelStation.text = self.model.stationName;
  self.labelStationUser.text = kStrPrefix(self.model.stationUserName, @"加油员：");
  self.labelGun.text = kStrPrefix(self.model.oilGunName, @"油枪：");
  self.labelOil.text = kStrPrefix(self.model.gasItemName, @"油品：");
  self.labelCustomer.text = kStrPrefix(self.model.memberName, @"顾客：");
  self.labelPayment.text = kStrPrefix(self.model.paymentString, @"支付方式：");
  self.labelPayTime.text = kStrPrefix(self.model.payTime, @"支付时间：");
  self.labelPrice.text = kStrPrefix([CalculateHelper getMoneyStringFrom:self.model.total], @"￥");
  //抵用券金额
  NSDecimalNumber *voucher = [CalculateHelper sub:self.model.total num2:self.model.realPayTotal];
  self.labelVoucher.text = kStrPrefix([CalculateHelper getMoneyStringFrom:voucher], @"￥");
  self.labelRealPrice.text = kStrPrefix([CalculateHelper getMoneyStringFrom:self.model.realPayTotal], @"￥");
  self.labelDeduct.text = [self.model.deduct stringValue];
  self.labelIsInvoice.text = kStrPrefix(self.model.invoiceString, @"是否开票：");
  self.labelIsPrint.text = kStrPrefix(self.model.printStateString, @"是否打印：");
  self.labelLatestPrintTime.text = kStrPrefix(self.model.lstPrintedTime, @"最后一次打印时间：");
}

#pragma mark - action

- (void)actionRePrint {
  UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"确认重新打印加油单吗？" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
  WS(weakSelf);
  UIAlertAction *actionYes = [UIAlertAction actionWithTitle:@"重新打印" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
    
    [weakSelf httpRePrint];
    
  }];
  [alert addAction:actionYes];
  
  UIAlertAction *actionNo = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
  [alert addAction:actionNo];
  
  [self.navigationController presentViewController:alert animated:YES completion:nil];
}

- (void)httpRePrint {
  NSDictionary *myDictionary = @{@"billId" : self.model.fid};
  [MBProgressHUD j_loading:@"打印中…"];
  [kHttp GET:kRePrintUrl parameters:myDictionary complete:^(id  _Nullable response, NSError * _Nullable error) {
    [MBProgressHUD j_hideLoadingView];
    if (kRsSuccess(response)) {
      [MBProgressHUD j_success:@"打印成功！" complete:nil];
    }else{
      kShowRsMsg(response);
    }
  }];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
