//
//  DateTextField.m
//  RealEstateManagement
//
//  Created by Javen on 2016/11/8.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "DateTextField.h"

@interface DateTextField () <UITextFieldDelegate>

@end

@implementation DateTextField
- (void)awakeFromNib
{
  [super awakeFromNib];
  UIDatePicker *datePicker = [[UIDatePicker alloc] initWithFrame:CGRectMake(0, 0, kWidth, 216)];
  self.inputView = datePicker;
  NSDate *date = [NSDate date];
  self.delegate = self;
  datePicker.date = date;
  datePicker.maximumDate = date;
  [datePicker addTarget:self action:@selector(actionPickerDidChanged:) forControlEvents:UIControlEventValueChanged];
}

- (void)setType:(DateTextFieldType)type {
    _type = type;
    UIDatePicker *datePicker = (UIDatePicker *)self.inputView;
    NSDate *date = datePicker.date;
    switch (self.type) {
        case DateTextFieldYearMonth: {
            self.text = [date yearMonthString];
            datePicker.datePickerMode = UIDatePickerModeDate;
            break;
        }
        case DateTextFieldYearMonthDay: {
            self.text = [date yearMonthDayString];
            datePicker.datePickerMode = UIDatePickerModeDate;
            break;
        }
        case DateTextFieldTime: {
            datePicker.datePickerMode = UIDatePickerModeTime;
            self.text = [date httpParameterString];
            break;
        }
    }
}

- (void)textFieldDidEndEditing:(UITextField *)textField
{
    UIDatePicker *datePicker = (UIDatePicker *)textField.inputView;
    NSDate *date = datePicker.date;
    switch (self.type) {
        case DateTextFieldYearMonth: {
            textField.text = [date yearMonthString];
            break;
        }
        case DateTextFieldYearMonthDay: {
            textField.text = [date yearMonthDayString];
            break;
        }
        case DateTextFieldTime: {
            textField.text = [date httpParameterString];
            break;
        }
    }
    if (self.blockEndEdit) {
        self.blockEndEdit();
    }
}

- (void)actionPickerDidChanged:(UIDatePicker *)datePicker
{
    NSDate *date = datePicker.date;
    switch (self.type) {
        case DateTextFieldYearMonth: {
            self.text = [date yearMonthString];
            break;
        }
        case DateTextFieldYearMonthDay: {
            self.text = [date yearMonthDayString];
            break;
        }
        case DateTextFieldTime: {
            self.text = [date httpParameterString];
            break;
        }
    }
}

- (BOOL)canPerformAction:(SEL)action withSender:(id)sender
{
    if (action == @selector(paste:))//禁止粘贴
        return NO;
    if (action == @selector(select:))// 禁止选择
        return NO;
    if (action == @selector(selectAll:))// 禁止全选
        return NO;
    return [super canPerformAction:action withSender:sender];
}
@end
