//
//  CardAmplificationViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/10/20.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CardAmplificationViewController.h"

@interface CardAmplificationViewController ()<MDScratchImageViewDelegate>

@end

@implementation CardAmplificationViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self addMaskView];
}

#pragma mark - 添加遮罩层
- (void)addMaskView
{
    self.maskView.delegate = self;
    [self.maskView setImage:TCImage(@"mask") radius:20];
}

#pragma mark - 去使用
- (IBAction)sureButtonClickAction:(UIButton *)sender {
    
    if (self.refreshJDCardList) {
        self.refreshJDCardList(self.cardModel.cardNumber);
    }
}

- (void)setCardModel:(TOJingdongEcardEntity *)cardModel
{
    _cardModel = cardModel;
    self.backgroundImageView.image = [BaseViewController getCorrespondingPictures:_cardModel.denomation];
    self.cardNumberLabel.text = [NSString stringWithFormat:@"卡号:   %@",_cardModel.cardNumber];
    self.cardPasswordLabel.text = [NSString stringWithFormat:@"密码:   %@",_cardModel.cardPassword];
    /// 判断状态
    BOOL isUsed = [_cardModel.state isEqualToString:LOOKED];
    BOOL isActived = [_cardModel.state isEqualToString:ACTIVED];
    BOOL isDispensed = [_cardModel.state isEqualToString:DISPENSED];
    if (isDispensed) {
        self.usedImageView.hidden = YES;
        self.maskView.hidden = NO;
        self.usedingButton.hidden = NO;
    }
    if (isActived) {
        self.usedImageView.hidden = YES;
        self.maskView.hidden = NO;
        self.usedingButton.hidden = NO;
    }
    if (isUsed) {
        self.maskView.hidden = YES;
        self.usedingButton.hidden = YES;
        self.usedImageView.hidden = NO;
    }
    NSString *totalString = [NSString stringWithFormat:@"%ld元",_cardModel.denomation];
    NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc]initWithString:totalString];
    [attributedString addAttribute:NSFontAttributeName value:[UIFont fontWithName:@"HelveticaNeue-Bold" size:50] range:NSMakeRange(0, totalString.length-1)];
    self.usedingButton.enabled = NO;
    self.amountLabel.attributedText = attributedString;
}

#pragma mark - <MDScratchImageViewDelegate>
- (void)mdScratchImageView:(MDScratchImageView *)scratchImageView didChangeMaskingProgress:(CGFloat)maskingProgress
{
    if (maskingProgress >= 0.8) {
        self.usedingButton.enabled = YES;
        self.maskView.hidden = YES;
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}





@end
