//
//  FullScreenViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/20.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "FullScreenViewController.h"
#import "FullScreenViewCell.h"
#import "ExperienceCentreViewController.h"

@interface FullScreenViewController ()


/**
 *  返回View
 */
@property (nonatomic,strong) UIView *backView;

/**
 *  返回按钮
 */
@property (nonatomic,strong) UIButton *backButton;

/**
 *  保存当前下标
 */
@property (nonatomic,assign) NSInteger currentIndex;

@end

@implementation FullScreenViewController

static NSString * const reuseIdentifier = @"Cell";



#pragma mark -初始化
- (instancetype)init
{
    // 创建一个流水布局
    UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc] init];
    // 设置cell的尺寸
    layout.itemSize = [UIScreen mainScreen].bounds.size;
    // 设置滚动的方向
    layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
    // 行间距
    layout.minimumLineSpacing = 0;
    // 设置cell之间的间距
    layout.minimumInteritemSpacing = 0;
    return [super initWithCollectionViewLayout:layout];
}



- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
    [self CreateBackView];
}


#pragma amrk 返回View
- (void)CreateBackView
{
    
    //产品列表调用
    if (self.isProductLibrary) {
        
        self.backButton = [UIButton buttonWithType:UIButtonTypeCustom];
        self.backButton.frame = CGRectMake(30, 10, 100, 64);
        [self.backButton setImage:TCImage(@"2-副本") forState:UIControlStateNormal];
        [self.backButton addTarget:self action:@selector(BackButtonClick) forControlEvents:UIControlEventTouchUpInside];
        [self.view addSubview:self.backButton];
        
    }else//场景列表调用
    {
        self.backView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 64)];
        self.backView.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.4];
        [self.view addSubview:self.backView];
        //返回按钮
        UIButton *backButton = [UIButton buttonWithType:UIButtonTypeCustom];
        backButton.frame = CGRectMake(30, 0, 100, 64);
        [backButton setImage:TCImage(@"quanping") forState:UIControlStateNormal];
        [backButton addTarget:self action:@selector(BackButtonClick) forControlEvents:UIControlEventTouchUpInside];
        [self.backView addSubview:backButton];
        
        //体验中心
        UIButton *tiYanCenterButton = [UIButton buttonWithType:UIButtonTypeCustom];
        tiYanCenterButton.frame = CGRectMake(ScreenWidth-150, 10, 100, 44);
        tiYanCenterButton.layer.masksToBounds = YES;
        tiYanCenterButton.layer.cornerRadius = kCornerRadius;
        tiYanCenterButton.layer.borderWidth = 1;
        tiYanCenterButton.layer.borderColor = [UIColor whiteColor].CGColor;
        [tiYanCenterButton setTitle:@"体验中心" forState:UIControlStateNormal];
        [tiYanCenterButton addTarget:self action:@selector(GotoTiYanCenterButtonClick) forControlEvents:UIControlEventTouchUpInside];
        [self.backView addSubview:tiYanCenterButton];
    }
    [self.collectionView setContentOffset:CGPointMake(ScreenWidth*self.currentindex, 0)];
}

#pragma mark -返回
- (void)BackButtonClick
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

#pragma mark -体验中心
- (void)GotoTiYanCenterButtonClick
{
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"StoryboardwithCYX" bundle:nil];
    ExperienceCentreViewController *ExperienceCenter = [storyboard instantiateViewControllerWithIdentifier:@"ExperienceCentre"];
    TOSceneEntity *sceneModel = [self.datasArray objectAtIndex_opple:self.currentIndex];
    SceneListModel *model = [[SceneListModel alloc]init];
    model.fid = sceneModel.fid;
    model.sceneCode = sceneModel.sceneCode;
    model.name = sceneModel.name;
    model.pricure = sceneModel.pricure;
    model.category = sceneModel.category;
    model.style = sceneModel.style;
    model.space = sceneModel.space;
    model.isSelectedSate = YES;
    [ExperienceCenter.sceneDatasArray addObject:model];
    ExperienceCenter.boolValue = YES;
    ExperienceCenter.modalPresentationStyle = UIModalPresentationOverFullScreen;
    UIPopoverPresentationController *popover = ExperienceCenter.popoverPresentationController;
    popover.sourceView = ExperienceCenter.view;
    [self presentViewController:ExperienceCenter animated:YES completion:nil];
}

#pragma mark -获取当前下标
- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView
{
    CGPoint offset = scrollView.contentOffset;
    int index = offset.x/self.view.frame.size.width;
    self.currentIndex = index;
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.collectionView.pagingEnabled = YES;
    self.collectionView.backgroundColor = [UIColor whiteColor];
    [self.collectionView registerClass:[FullScreenViewCell class] forCellWithReuseIdentifier:reuseIdentifier];
}


#pragma mark <UICollectionViewDataSource>

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.datasArray.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    
    FullScreenViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:reuseIdentifier forIndexPath:indexPath];
    cell.backgroundColor = kTCColor(251, 248, 241);
    if (self.isProductLibrary) {
        [cell.imageView sd_setImageWithURL:[NSURL URLWithString:[self.datasArray objectAtIndex_opple:indexPath.item]] placeholderImage:REPLACEIMAGE];
        return cell;
    }
    TOSceneEntity *model = [self.datasArray objectAtIndex_opple:indexPath.item];
    [cell.imageView sd_setImageWithURL:[NSURL URLWithString:model.pricure] placeholderImage:REPLACEIMAGE];
    return cell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    
    if (self.isProductLibrary) {
        if (self.backButton.frame.origin.y == 10) {
            
            [UIView animateWithDuration:0.3 animations:^{
                
                CGRect frame = self.backButton.frame;
                frame.origin.y = -64;
                self.backButton.frame = frame;
                
            }];
            
        }else if (self.backButton.frame.origin.y == -64)
        {
            [UIView animateWithDuration:0.3 animations:^{
                
                CGRect frame = self.backButton.frame;
                frame.origin.y = 10;
                self.backButton.frame = frame;
            }];
        }
    }else
        
    {
        if (self.backView.frame.origin.y == 0) {
            
            [UIView animateWithDuration:0.3 animations:^{
                
                CGRect frame = self.backView.frame;
                frame.origin.y = -64;
                self.backView.frame = frame;
                
            }];
        }else if (self.backView.frame.origin.y == -64)
        {
            [UIView animateWithDuration:0.3 animations:^{
                
                CGRect frame = self.backView.frame;
                frame.origin.y = 0;
                self.backView.frame = frame;
            }];
        }
    }
}


@end
