//
//  RebateSuccessTableViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/8/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "RebateSuccessTableViewController.h"
#import "PromptTableViewCell.h"
#import "PromptHeaderTableViewCell.h"

@interface RebateSuccessTableViewController ()

@end

@implementation RebateSuccessTableViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.tableView.tableFooterView = [UIView new];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.titleArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        PromptHeaderTableViewCell *headerView = [tableView dequeueReusableCellWithIdentifier:@"PromptHeaderTableViewCell" forIndexPath:indexPath];
        headerView.headerViewContentLabel.text = self.titleArray[indexPath.row];
        return headerView;
    }
    PromptTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"PromptTableViewCell" forIndexPath:indexPath];
    cell.contentLabel.text = self.titleArray[indexPath.row];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        return;
    }
    WS(weakSelf);
    [self dismissViewControllerAnimated:YES completion:^{
        if (weakSelf.ClickEvent) {
            weakSelf.ClickEvent([NSIndexPath indexPathForRow:indexPath.row-1 inSection:0]);
        }
    }];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        return 150;
    }
    return 68;
}



@end
