//
//  RebateViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/8/26.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "RebateViewController.h"
#import "PaymentsViewController.h"
#import "WithdrawalViewController.h"
#import "RebateDetailsViewController.h"
#import "WithdrawalTableViewController.h"
#import "CardViewController.h"
#import "CardDetailsViewController.h"
#import "LuckyDrawViewController.h"
#import "LuckyDrawDetailsViewController.h"

@interface RebateViewController ()

/**
 *  头像
 */
@property (weak, nonatomic) IBOutlet UIImageView *headerImageView;

/**
 *  账户金额
 */
@property (weak, nonatomic) IBOutlet UILabel *currentAmountLabel;

/**
 *  昨日收益
 */
@property (weak, nonatomic) IBOutlet UILabel *yesterdayAmountLabel;

/**
 *  历史收益
 */
@property (weak, nonatomic) IBOutlet UILabel *historyAmountLabel;

/**
 *  冻结金额
 */
@property (weak, nonatomic) IBOutlet UILabel *freezeAmountLabel;

/**
 *  提现
 */
@property (weak, nonatomic) IBOutlet UIButton *withdrawalButton;

/**
 *  收支明细，提现进度
 */
@property (weak, nonatomic) IBOutlet UIView *contentBackgroundView;

/**
 *  当前的控制器
 */
@property (nonatomic,strong) BaseViewController *currentVC;

/**
 *  指示条
 */
@property (weak, nonatomic) IBOutlet UIView *instructionsLinesView;

/**
 *  收支明细
 */
@property (weak, nonatomic) IBOutlet UIButton *paymentsButton;

/**
 * 提现进度
 */
@property (weak, nonatomic) IBOutlet UIButton *withdrawalProgressButton;

/**
 *  账户数据
 */
@property (nonatomic,strong) EarningsResponse *model;

/**
 *  我的卡劵包
 */
@property (weak, nonatomic) IBOutlet UIView *cardBackgroundView;

/**
 *  我的抽奖
 */
@property (weak, nonatomic) IBOutlet UIView *drawBackgroundView;

/**
 *  账户金额
 */
@property (weak, nonatomic) IBOutlet UIView *accountAmountView;



@end

@implementation RebateViewController

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    [[NSNotificationCenter defaultCenter] postNotificationName:PROMPTDRAWINFORMATION object:@(0)];
    [self getRebateDatasFromUser];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupChildViewController];
    [self uiConfigAction];
    [self addConstraint];
}

#pragma mark - UI
- (void)uiConfigAction
{
    [self setupInstructionsViewOrigin:self.paymentsButton];
    [self.headerImageView sd_setImageWithURL:[NSURL URLWithString:[Shoppersmanager manager].Shoppers.employee.picture] placeholderImage:ReplaceImage];
}

#pragma mark - 添加约束
- (void)addConstraint
{
    [self.cardBackgroundView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(23);
        make.top.equalTo(self.accountAmountView.mas_bottom).offset(13);
        make.size.mas_equalTo(CGSizeMake((ScreenWidth-23*2-20)/2, 200));
    }];
    
    [self.drawBackgroundView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.cardBackgroundView.mas_right).offset(20);
        make.top.equalTo(self.accountAmountView.mas_bottom).offset(13);
        make.size.mas_equalTo(CGSizeMake((ScreenWidth-23*2-20)/2, 200));
    }];
}

#pragma mark - 设置收支明细、提现进度、卡劵包
- (void)setupChildViewController
{
    PaymentsViewController *payments = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"PaymentsViewController"];
    [self addChildViewController:payments];
    
    WithdrawalViewController *withdrawal = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"WithdrawalViewController"];
    [self addChildViewController:withdrawal];
    payments.view.frame = CGRectMake(0, 40, self.contentBackgroundView.mj_w, self.contentBackgroundView.mj_h-40);
    withdrawal.view.frame = CGRectMake(0, 40, self.contentBackgroundView.mj_w, self.contentBackgroundView.mj_h-40);
    [self.contentBackgroundView addSubview:payments.view];
    self.currentVC = payments;
    
    /// 我的卡劵
    CardViewController *cardVc = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"CardViewController"];
    [self addChildViewController:cardVc];
    cardVc.view.frame = CGRectMake(10, 40, (self.cardBackgroundView.mj_w-20), self.cardBackgroundView.mj_h-50);
    [self.cardBackgroundView addSubview:cardVc.view];
    
    /// 我的抽奖
    LuckyDrawDetailsViewController *draw = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"LuckyDrawDetailsViewController"];
    [self addChildViewController:draw];
    draw.drawValue = 0;
    draw.view.frame = CGRectMake(10, 40, (self.drawBackgroundView.mj_w-20), self.drawBackgroundView.mj_h-50);
    [self.drawBackgroundView addSubview:draw.view];
}


#pragma mark - 切换收支明细、提现进度
- (void)switchPaymentsVCAndWithdrawalVC:(BaseViewController *)newViewController
{
    [self transitionFromViewController:self.currentVC toViewController:newViewController duration:0.5 options:UIViewAnimationOptionTransitionNone animations:nil completion:^(BOOL finished) {
        if (finished) {
            [self.contentBackgroundView addSubview:newViewController.view];
            self.currentVC = newViewController;
        }
    }];
}

#pragma mark - 切换ContentController
- (IBAction)paymentsButtonAndWithdrawalButtonClick:(UIButton *)sender {
    
    if ([sender isEqual:self.paymentsButton]) {
        sender.selected = YES;
        self.withdrawalButton.selected = NO;
    }else
    {
        sender.selected = YES;
        self.paymentsButton.selected = NO;
    }
    [self setupInstructionsViewOrigin:sender];
    [self switchPaymentsVCAndWithdrawalVC:self.childViewControllers[sender.tag-100]];
}

#pragma mark - 设置指示线的位置
- (void)setupInstructionsViewOrigin:(UIButton *)sender
{
    [UIView animateWithDuration:0.5 delay:0.1f usingSpringWithDamping:0.5f initialSpringVelocity:0.5f options:UIViewAnimationOptionCurveEaseInOut animations:^{
        self.instructionsLinesView.frame = CGRectMake(sender.mj_origin.x+(sender.mj_w-self.instructionsLinesView.mj_w)/2, self.instructionsLinesView.mj_origin.y, self.instructionsLinesView.mj_w, 2);
    } completion:nil];
}


#pragma mark - 查询返利信息
- (void)getRebateDatasFromUser
{
    WS(weakSelf);
    [self CreateMBProgressHUDLoding];
    NSString *URL = [NSString stringWithFormat:@"%@/%@",REBATE,[Shoppersmanager manager].Shoppers.employee.fid];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:SERVERREQUESTURL(URL) WithCallClass:weakSelf WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            weakSelf.model = [[EarningsResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
             weakSelf.currentAmountLabel.text = [NSString stringWithFormat:@"%.2f",[returnValue[@"data"][@"accountTotal"] floatValue]];
             weakSelf.yesterdayAmountLabel.text = [NSString stringWithFormat:@"%.2f",[returnValue[@"data"][@"yesterdayEarnings"] floatValue]];
             weakSelf.historyAmountLabel.text = [NSString stringWithFormat:@"%.2f",[returnValue[@"data"][@"historyEarning"] floatValue]];
            weakSelf.freezeAmountLabel.text = [NSString stringWithFormat:@"%.2f",[returnValue[@"data"][@"applytotal"] floatValue]];
        }else
        {
            [weakSelf SHOWPrompttext:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf SHOWPrompttext:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf SHOWPrompttext:error.localizedDescription];
    }];
}


#pragma mark - 提现
- (IBAction)withdrawalButtonClickAction:(UIButton *)sender {
    
    WS(weakSelf);
    RebateDetailsViewController *rebateDetails = [self.getStoryboardWithName instantiateViewControllerWithIdentifier:@"RebateDetailsViewController"];
    rebateDetails.rebateAmount = [self.model.accountTotal floatValue]-[self.model.applytotal floatValue];
    [rebateDetails setShowApplyDetails:^(TOApplyBillEntity *entity) {
        WithdrawalTableViewController *detailVC = [weakSelf.getStoryboardWithName instantiateViewControllerWithIdentifier:@"WithdrawalTableViewController"];
        detailVC.model = entity;
        [weakSelf.navigationController pushViewController:detailVC animated:YES];
    }];
    [self.navigationController pushViewController:rebateDetails animated:YES];
}

#pragma mark - 更多卡劵
- (IBAction)moreCardButtonClickAction:(UIButton *)sender {
    
    CardDetailsViewController *cardDetails = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"CardDetailsViewController"];
    [self.navigationController pushViewController:cardDetails animated:YES];
}

#pragma mark - 更多抽奖信息
- (IBAction)moreDrawButtonClickAction:(UIButton *)sender {
    
    LuckyDrawViewController *luckDrawDetails = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"LuckyDrawViewController"];
    [self.navigationController pushViewController:luckDrawDetails animated:YES];
}



@end
