//
//  CustomWKWebViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/17.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomWKWebViewController.h"
#import <WebKit/WebKit.h>
@interface CustomWKWebViewController ()<WKNavigationDelegate,WKScriptMessageHandler>

@property (nonatomic,strong) WKWebView *webView;
@property (nonatomic,strong) WKWebViewConfiguration *config;

@end

@implementation CustomWKWebViewController

#pragma mark - lazy
- (WKWebViewConfiguration *)config
{
    if (!_config) {
        _config = [[WKWebViewConfiguration alloc]init];
        // 设置偏好设置
        _config.preferences = [[WKPreferences alloc] init];
        // 默认为0
        _config.preferences.minimumFontSize = 10;
        // 默认认为YES
        _config.preferences.javaScriptEnabled = YES;
        // 在iOS上默认为NO，表示不能自动通过窗口打开
        _config.preferences.javaScriptCanOpenWindowsAutomatically = NO;
        // 通过JS与webview内容交互
        _config.userContentController = [[WKUserContentController alloc] init];
        [_config.userContentController addScriptMessageHandler:self name:@"AppModel"];
    }
    return _config;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
    [self addDismissButton];
}

#pragma mark -UI
- (void)uiConfigAction
{
    NSSet *websiteDataTypes = [NSSet setWithArray:@[WKWebsiteDataTypeDiskCache,WKWebsiteDataTypeMemoryCache,]];
    NSDate *dateFrom = [NSDate dateWithTimeIntervalSince1970:0];
    [[WKWebsiteDataStore defaultDataStore] removeDataOfTypes:websiteDataTypes modifiedSince:dateFrom completionHandler:^{
        NSLog(@"清除缓存成功");
    }];
    self.webView = [[WKWebView alloc] initWithFrame:self.view.bounds configuration:self.config];
    [self.view addSubview:self.webView];
    self.webView.navigationDelegate = self;
    [self.webView loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:self.pdfURLString]]];
}

#pragma mark - 添加删除按钮
- (void)addDismissButton
{
    UIButton *dismissButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.view addSubview:dismissButton];
    [dismissButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(40);
        make.top.mas_equalTo(40);
        make.size.mas_equalTo(CGSizeMake(50, 50));
    }];
    [dismissButton setBackgroundImage:TCImage(@"1") forState:UIControlStateNormal];
    [dismissButton addTarget:self action:@selector(dismissButtonClick) forControlEvents:UIControlEventTouchUpInside];
}

#pragma mark - WKScriptMessageHandler
- (void)userContentController:(WKUserContentController *)userContentController didReceiveScriptMessage:(WKScriptMessage *)message
{
    if ([message.name isEqualToString:@"AppModel"]) {
        // 打印所传过来的参数，只支持NSNumber, NSString, NSDate, NSArray,
        // NSDictionary, and NSNull类型
        if (self.luckyDrawFinishBlock) {
            self.luckyDrawFinishBlock(message.body);
        }
    }
}


#pragma mark -dismiss
- (void)dismissButtonClick
{
    WS(weakSelf);
    [self dismissViewControllerAnimated:YES completion:^{
        if (weakSelf.dismissLuckyDrawController) {
            weakSelf.dismissLuckyDrawController();
        }
    }];
}

- (void)webView:(WKWebView *)webView didStartProvisionalNavigation:(null_unspecified WKNavigation *)navigation
{
    [self CreateMBProgressHUDLoding];
}

- (void)webView:(WKWebView *)webView didFinishNavigation:(WKNavigation *)navigation
{
    [self RemoveMBProgressHUDLoding];
}


- (void)webView:(WKWebView *)webView didFailNavigation:(WKNavigation *)navigation withError:(NSError *)error
{
    [self ErrorMBProgressView:@"加载失败"];
    [self dismissViewControllerAnimated:YES completion:nil];
}




@end
