//
//  FollowHeartViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "FollowHeartViewController.h"
#import <QuartzCore/QuartzCore.h>


@interface FollowHeartViewController ()

@end

@implementation FollowHeartViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self configSubView];
    
}
-(void)configSubView
{
    self.productModelArray=[[NSMutableArray alloc]init];
    self.backGroundImageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"backView.png"]];
    self.backGroundImageView.frame=CGRectMake(0, 0, ScreenWidth, ScreenHeight);
    [self.view addSubview:self.backGroundImageView];
    self.leftSubView=[[LeftSubView alloc]initWithFrame:CGRectMake(0, 0, 200, ScreenHeight-150)];
    self.leftSubView.delegate=self;
    [self.view addSubview:self.leftSubView];
    self.rightSubView=[[RightSubView alloc]initWithFrame:CGRectMake(ScreenWidth-200, 0, 200, ScreenHeight-150)];
    self.rightSubView.delegate=self;
    [self.view addSubview:self.rightSubView];
    
    self.footSubView=[[FootSubView alloc]initWithFrame:CGRectMake(0, ScreenHeight-150, ScreenWidth, 150)];
    self.footSubView.delegate=self;
    [self.view addSubview:self.footSubView];
   
}

#pragma  subView  delegate
- (void)buttonClick:(NSInteger)btnTag withButton:(UIButton *)button
{
    switch (btnTag) {
        case 100:  //返回
        {
            [self dismissViewControllerAnimated:YES completion:nil];
        }
            break;
        case 101:  //购物车
        {
             [self addShoppingView];
        }
            break;
        case 102:  //分享
        {
            [self addShareView:button];
        }
            break;
        case 103:  //自定义场景
        {
            [self addCameraView:button];
        }
            break;
        case 104:  //全屏
        {

            [self setViewAnimations:button];
            
        }
            break;
        case 105: //帮助
        {
            [self addHelpView:button];
        }
            break;
        case 200: //场景
        {
            if (!self.footSubView.isSelected) {
                [self.footSubView.selectBtn setBackgroundImage:[UIImage imageNamed:@"场景1"] forState:UIControlStateNormal];
                self.footSubView.isSelected=YES;
            }
            [self addSceneLibraryView];
        }
            break;
        case 300: //产品
        {
            if (!self.rightSubView.isSelected) {
                [self.rightSubView.selectBtn setBackgroundImage:[UIImage imageNamed:@"产品1"] forState:UIControlStateNormal];
                self.rightSubView.isSelected=YES;
            }
            [self addProductLibraryView];
        }
            break;
            
        default:
            break;
    }

}
-(void)addShareView:(UIButton *)sender
{
    
    [self CreateMBProgressHUDLoding];
    //    先截屏 并保存图片
    [self savePhoto];
  

}
//添加自定义场景
-(void)addCameraView:(UIButton *)sender
{
    [self.leftSubView.camerBtn setBackgroundImage:[UIImage imageNamed:@"selectCamer"] forState:UIControlStateNormal];
    self.cameraView=[[CameraView alloc]init];
    self.cameraView.view.backgroundColor=[UIColor clearColor];
    self.cameraView.delegate=self;
    [self.view addSubview:self.cameraView.view];
}
//自定义场景附图回调
- (void)addCustomPictureImage:(UIImage *)image
{
    [self.footSubView addFootSubViewImage:image];
    self.backGroundImageView.image=image;
}
//添加场景图
- (void)resetSuperBackGroundImage:(UIImage*)image
{
    self.backGroundImageView.image=image;
}
//场景中添加产品图
- (void)resetSubProductImage:(UIImage*)image productModel:(TOGoodsEntity *)productModel
{
    ImageCropperView *cropper=[[ImageCropperView alloc]initWithFrame:CGRectMake(400, 200, 300, 225)];
    cropper.image = image;
    cropper.GoodsEntity=productModel;
    cropper.delegate=self;
    [self.view addSubview:cropper];
    [self.productModelArray  addObject:cropper.GoodsEntity];
}
//删除场景中产品回调
- (void)removeSelfObject:(ImageCropperView*)Cropper
{
    [self.productModelArray  removeObject:Cropper.GoodsEntity];
    [Cropper removeFromSuperview];
}
//场景库选图回调
- (void)addSeceneImage:(UIImage *)image
{
    [self.footSubView addFootSubViewImage:image];
}
//产品库选图回调
- (void)addProductImage:(UIImage *)image productModel:(TOGoodsEntity *)productModel
{
    [self.rightSubView addRightSubViewImage:image productModel:productModel];
}
////分享回调
//- (void)ShareProductImage:(UIImage *)image
//{

//}
//全屏
-(void)setViewAnimations:(UIButton *)sender
{
    self.zoomButton=self.leftSubView.fullViewBtn;
    self.zoomButton.hidden=YES;
    self.temporaryBtn=[UIButton buttonWithType:UIButtonTypeCustom];
    self.temporaryBtn.frame=sender.frame;
    [self.temporaryBtn setBackgroundImage:[UIImage imageNamed:@"xiaoping"] forState:UIControlStateNormal];
    [self.temporaryBtn addTarget:self action:@selector(resetViewDidSelected:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.temporaryBtn];

    [UIView beginAnimations:@"quanping" context:nil];
    [UIView setAnimationDelegate:self];
    [UIView setAnimationDuration:1.0f];
    self.leftSubView.frame=CGRectMake(-200, 0, 200, ScreenHeight-150);
    self.rightSubView.frame=CGRectMake(ScreenWidth, 0, 200, ScreenHeight-150);
    self.footSubView.frame=CGRectMake(0, ScreenHeight, ScreenWidth, 150);
    self.temporaryBtn.frame=CGRectMake(sender.frame.origin.x, 20, sender.frame.size.width, sender.frame.size.height);
    [UIView commitAnimations];
}
-(void)addHelpView:(UIButton *)btn
{
    [self.leftSubView.helpBtn setBackgroundImage:[UIImage imageNamed:@"selectHelp"] forState:UIControlStateNormal];
    self.helpView=[[HelpViewController alloc]init];
    self.helpView.view.backgroundColor=[UIColor clearColor];
    self.helpView.delegate=self;
    [self.view addSubview:self.helpView.view];
 
}
-(void)resetViewDidSelected:(UIButton *)sender
{
    [sender setBackgroundImage:[UIImage imageNamed:@"quanping"] forState:UIControlStateNormal];
    [UIView beginAnimations:@"xiaoping" context:nil];
    [UIView setAnimationDelegate:self];
    [UIView setAnimationDidStopSelector:@selector(animationFinish)];
    [UIView setAnimationDuration:1.0f];
    self.leftSubView.frame=CGRectMake(0, 0, 200, ScreenHeight-150);
    self.rightSubView.frame=CGRectMake(ScreenWidth-200, 0, 200, ScreenHeight-150);
    self.footSubView.frame=CGRectMake(0, ScreenHeight-150, ScreenWidth, 150);
    sender.frame=self.zoomButton.frame;
    [UIView commitAnimations];
  
}
-(void)animationFinish
{
     self.zoomButton.hidden=NO;
    [self.temporaryBtn removeFromSuperview];
}
//添加场景
-(void)addSceneLibraryView
{

    self.seceneLibraryView=[[SeceneLibraryView alloc]init];
    self.seceneLibraryView.view.backgroundColor=[UIColor clearColor];
    self.seceneLibraryView.delegate=self;
    [self.view addSubview:self.seceneLibraryView.view];
}
//添加产品
-(void)addProductLibraryView
{
    self.productLibraryView=[[ProductLibraryView alloc]init];
    self.productLibraryView.view.backgroundColor=[UIColor clearColor];
    self.productLibraryView.delegate=self;
    [self.view addSubview:self.productLibraryView.view];
}
//添加购物车
-(void)addShoppingView
{
    [self.leftSubView.shoppingBtn setBackgroundImage:[UIImage imageNamed:@"selectshoping"] forState:UIControlStateNormal];
    self.shoppingView=[[ShoppingView alloc]init];
    self.shoppingView.view.backgroundColor=[UIColor clearColor];
    for (TOGoodsEntity *GoodsEntity in self.productModelArray) {
        [ self.shoppingView.productModelArray addObject:GoodsEntity];
    }
//    self.shoppingView.productModelArray=self.productModelArray;
    self.shoppingView.delegate=self;
    [self.view addSubview:self.shoppingView.view];
    
}
// 保存图片到相册功能，ALAssetsLibraryiOS9.0 以后用photoliabary 替代，

-(void)savePhoto

{
    [self setViewAnimations:self.leftSubView.fullViewBtn];
    
    UIImage * image = [self captureImageFromView:self.view];
    [self saveImageToPhotos:image];

}
- (void)saveImageToPhotos:(UIImage*)savedImage

{
    UIImageWriteToSavedPhotosAlbum(savedImage, self, @selector(image:didFinishSavingWithError:contextInfo:), NULL);
    
}
// 指定回调方法

- (void)image: (UIImage *) image didFinishSavingWithError: (NSError *) error contextInfo: (void *) contextInfo

{
    NSString *msg = nil ;
    
    if(error != NULL){
        [self RemoveMBProgressHUDLoding];
        msg = @"保存图片失败" ;
        
    }else{
        [self RemoveMBProgressHUDLoding];
        msg = @"保存图片成功" ;
//        保存成功后添加到footview
        [self addSeceneImage:image];
        //再加载分享视图
        [self.leftSubView.shareBtn setBackgroundImage:[UIImage imageNamed:@"selectShare"] forState:UIControlStateNormal];
        ShareViewController *shareVC = [[ShareViewController alloc]init];
        shareVC.delegate = self;
        shareVC.preferredContentSize = CGSizeMake(280, 130);
        shareVC.modalPresentationStyle = UIModalPresentationPopover;
        shareVC.shareImage=image;
        NSString *str=@"";
        if (self.productModelArray.count>0) {
            for (int i=0; i<self.productModelArray.count; i++) {
                TOGoodsEntity *GoodsEntity=[self.productModelArray objectAtIndex:i];
                if ([str isEqualToString:@""]) {
                    str=[NSString stringWithFormat:@"%@",GoodsEntity.fid];
                }else
                {
                   str=[NSString stringWithFormat:@"%@,%@",str,GoodsEntity.fid];
                }
            }
        }
        shareVC.goodsIDs=str;
        UIPopoverPresentationController *pop = shareVC.popoverPresentationController;
        //    箭头方向
        pop.permittedArrowDirections = UIPopoverArrowDirectionLeft;
        pop.sourceView = shareVC.view;
        pop.sourceRect = CGRectMake(self.leftSubView.shareBtn.mj_x, self.leftSubView.shareBtn.mj_y-30, self.leftSubView.shareBtn.mj_w, self.leftSubView.shareBtn.mj_h);
        [self presentViewController:shareVC animated:YES completion:nil];
            }
    
    
}
//截图功能

-(UIImage *)captureImageFromView:(UIView *)view

{
    
    CGRect screenRect = [view bounds];
    
    UIGraphicsBeginImageContext(screenRect.size);
    
    CGContextRef ctx = UIGraphicsGetCurrentContext();
    
    [view.layer renderInContext:ctx];
    
    UIImage * image = UIGraphicsGetImageFromCurrentImageContext();
    
    UIGraphicsEndImageContext();
    
    return image;
    
}
//重置场景图标
- (void)restSeceneBtnImage
{
    if (self.footSubView.isSelected) {
        [self.footSubView.selectBtn setBackgroundImage:[UIImage imageNamed:@"场景2"] forState:UIControlStateNormal];
        self.footSubView.isSelected=NO;
    }
     [self.seceneLibraryView.view removeFromSuperview];
}
//重置产品图标
- (void)restProductBtnImage
{
   
    if (self.rightSubView.isSelected) {
        [self.rightSubView.selectBtn setBackgroundImage:[UIImage imageNamed:@"产品2"] forState:UIControlStateNormal];
        self.rightSubView.isSelected=NO;
    }
    [self.productLibraryView.view removeFromSuperview];
}
//购物
- (void)restShoppingBtnImage
{
    [self.leftSubView.shoppingBtn setBackgroundImage:[UIImage imageNamed:@"gouwuche"] forState:UIControlStateNormal];
}
//重置相机图片
- (void)restCamerBtnImage
{
    [self.leftSubView.camerBtn setBackgroundImage:[UIImage imageNamed:@"customchangjing"] forState:UIControlStateNormal];
}
//重置帮助图片
- (void)restHelpBtnImage
{
     [self.leftSubView.helpBtn setBackgroundImage:[UIImage imageNamed:@"bangzhu"] forState:UIControlStateNormal];
}


#pragma mark ---SharePicturedelegate
#pragma mark -上传图片进度
- (void)UploadImageProgress:(double)progress
{
    dispatch_async(dispatch_get_main_queue(), ^{
        
        [self ShowProgressView:progress];
    });
}

#pragma mark -上传图片完成
- (void)UploadImageSuccess
{
    dispatch_async(dispatch_get_main_queue(), ^{
        
      self.TCHud.labelText = @"上传完成";
      [self RemoveMBProgressHUDLoding];
        
    });
}

#pragma mark -上传图片失败
- (void)UploadImageFailue
{
    dispatch_async(dispatch_get_main_queue(), ^{
        
        self.TCHud.labelText = @"上传失败";
        [self RemoveMBProgressHUDLoding];
    });
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}











/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
