//
//  SeceneLibraryView.m
//  Lighting
//
//  Created by mac on 16/5/11.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "SeceneLibraryView.h"
@interface SeceneLibraryView ()

@end

@implementation SeceneLibraryView
/**
 *  上传模型
 */
- (SceneCondition *)conditionModel
{
    if (!_conditionModel) {
        
        _conditionModel = [[SceneCondition alloc]init];
    }
    return _conditionModel;
}

- (void)viewDidLoad {
    
     [self  initdata];
     [self  initView ];
     [self  uiConfigAction];
     [self  getdatasAction];
    
}
-(void)initdata
{
    self.arrayData=[[NSMutableArray alloc]init];
    self.indexPage = 0;
    self.isSelectBtnType=@"space";
  
}
-(void)uiConfigAction
{
    //下拉刷新
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        //默认数据
        self.indexPage = 1;
        DataPage *page = [[DataPage alloc]init];
        page.page = self.indexPage;
        page.rows = KROWS;
        self.conditionModel.page = page;
        
        [self.collectionView.mj_footer resetNoMoreData];
        [self getSceneLibrarydatas:self.conditionModel isRemove:YES];
    }];
    
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    self.collectionView.mj_header = headerRefresh;
    [self.collectionView.mj_header beginRefreshing];
    //上拉加载
    self.collectionView.mj_footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        
        if (self.indexPage ++ > self.totalPages) {
            [self.collectionView.mj_footer endRefreshingWithNoMoreData];
        }else
        {
            //默认数据
            DataPage *Newpage = [[DataPage alloc]init];
            Newpage.page = self.indexPage ++;
            Newpage.rows = KROWS;
            self.conditionModel.page = Newpage;
            [self getSceneLibrarydatas:self.conditionModel isRemove:NO];
        }
    }];

    
    
   }
#pragma mark -获取场景筛选数据
- (void)getdatasAction
{
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/scene/getSceneFilter"] WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        [self RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            self.filter = [[SceneFilter alloc]initWithDictionary:returnValue[@"data"] error:nil];
            self.arrayData=[NSMutableArray arrayWithArray:self.filter.space];
            [self.seceneTableView reloadData];
        }
        else
            {
            [self ErrorMBProgressView:returnValue[@"message"]];
            }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
    } WithFailureBlock:^(id error) {
        [self RemoveMBProgressHUDLoding];
    }];
}
//
//
#pragma mark -获取场景列表数据
- (void)getSceneLibrarydatas:(SceneCondition *)condition isRemove:(BOOL)remove
{
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/scene/query"] WithRequestType:0 WithParameter:condition WithReturnValueBlock:^(id returnValue) {
        
          [self endRefreshingForTableView:self.collectionView];
        [self RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
//            if (remove) {
//                [self.responseArray removeAllObjects];
//            }
            self.response = [[SceneResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            NSArray* array=[[NSArray alloc]init];
            array=self.response.list;
            [ self.collectionView reloadData];
        }
        else
            {
            [self ErrorMBProgressView:returnValue[@"message"]];
            }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
    } WithFailureBlock:^(id error) {
        
        [self RemoveMBProgressHUDLoding];
          [self endRefreshingForTableView:self.collectionView];
    }];
}

-(void)initView
{

    //    空间
    self.kongJianBtn=[UIButton buttonWithType:UIButtonTypeCustom];
    self.kongJianBtn.frame=CGRectMake(ScreenWidth-250, 52, 100, 46) ;
    self.kongJianBtn.backgroundColor=[UIColor whiteColor];
    [self.kongJianBtn setTitle:@"空间   " forState:UIControlStateNormal];
    [self.kongJianBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    self.kongJianBtn.contentEdgeInsets = UIEdgeInsetsMake(0, 55, 0, 0);
    self.kongJianBtn.backgroundColor=RGB(79, 153, 217, 1);
    [self.kongJianBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [self.kongJianBtn addTarget:self action:@selector(selectedType:) forControlEvents:UIControlEventTouchUpInside];
    self.kongJianBtn.tag=101;
    self.kongJianBtn.layer.masksToBounds = YES;
    self.kongJianBtn.layer.cornerRadius = 20;
    [self.view addSubview:self.kongJianBtn];
    //    风格
    self.fengGeBtn=[UIButton buttonWithType:UIButtonTypeCustom];
    self.fengGeBtn.frame=CGRectMake(ScreenWidth-250, 102, 100, 46) ;
    self.fengGeBtn.backgroundColor=[UIColor whiteColor];
    [self.fengGeBtn setTitle:@"风格  " forState:UIControlStateNormal];
    [self.fengGeBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    
    self.fengGeBtn.contentEdgeInsets = UIEdgeInsetsMake(0, 55, 0, 0);
    self.fengGeBtn.backgroundColor=RGB(225, 225, 225, 1);
    [self.fengGeBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [self.fengGeBtn addTarget:self action:@selector(selectedType:) forControlEvents:UIControlEventTouchUpInside];
    self.fengGeBtn.tag=102;
    self.fengGeBtn.layer.masksToBounds = YES;
    self.fengGeBtn.layer.cornerRadius = 15;
    [self.view addSubview:self.fengGeBtn];
    
    self.subView=[[UIView alloc]initWithFrame:CGRectMake(100, 50, ScreenWidth-300, ScreenHeight-200)];
    self.subView.backgroundColor=[UIColor whiteColor];
    [self.view  addSubview:self.subView];
    
    
    //点击手势
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(DismissScreenView:)];
    tap.delegate = self;
    tap.cancelsTouchesInView = NO;
    [[UIApplication sharedApplication].keyWindow addGestureRecognizer:tap];
    [self initSubViews];
   
}
-(void)initSubViews
{
    self.headerView=[[UIView alloc]initWithFrame:CGRectMake(0, 0, self.subView.frame.size.width-100, 50)];
    self.headerView.backgroundColor=RGB(225, 225, 225, 1);
    [self.subView addSubview:self.headerView];
    UIButton *btn=[UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame=CGRectMake(10, 10, 30, 30);
    [btn setBackgroundImage:[UIImage imageNamed:@"Folder"] forState:UIControlStateNormal];
    [self.headerView addSubview:btn];
    UILabel *lable=[[UILabel alloc]initWithFrame:CGRectMake(45, 10, 100, 30)];
    lable.text=@"选择场景";
    [self.headerView addSubview:lable];
    self.seceneTableView=[[UITableView alloc]initWithFrame:CGRectMake( self.headerView.frame.size.width, 0, 100, self.subView.frame.size.height)];
    self.seceneTableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    self.seceneTableView.delegate=self;
    self.seceneTableView.dataSource=self;
    [self.subView addSubview:self.seceneTableView];
    //确定是水平滚动，还是垂直滚动
    UICollectionViewFlowLayout *flowLayout=[[UICollectionViewFlowLayout alloc] init];
    [flowLayout setScrollDirection:UICollectionViewScrollDirectionVertical];
    
    self.collectionView=[[UICollectionView alloc] initWithFrame:CGRectMake( 0, 50, self.headerView.frame.size.width, self.subView.frame.size.height-50) collectionViewLayout:flowLayout];
    self.collectionView.dataSource=self;
    self.collectionView.delegate=self;
    [self.collectionView setBackgroundColor:[UIColor clearColor]];
    
    //注册Cell，必须要有
    [self.collectionView registerClass:[SeceneCollectionPictureCell class] forCellWithReuseIdentifier:@"UICollectionViewCell"];
    
    [self.subView addSubview:self.collectionView];

}
-(void)selectedType:(UIButton *)sender
{
    if ([sender.titleLabel.text isEqualToString:self.fengGeBtn.titleLabel.text ]) {
        self.fengGeBtn.backgroundColor=RGB(79, 153, 217, 1);
        [self.fengGeBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        self.kongJianBtn.backgroundColor=RGB(225, 225, 225, 1);
        [self.kongJianBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    }else
    {
        self.fengGeBtn.backgroundColor=RGB(225, 225, 225, 1);
        [self.fengGeBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        self.kongJianBtn.backgroundColor=RGB(79, 153, 217, 1);
        [self.kongJianBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    }
    switch (sender.tag) {
        case 101:
//            空间
            self.arrayData=[NSMutableArray arrayWithArray:self.filter.space];
            self.isSelectBtnType=@"space";
            break;
        case 102:
//            风格
             self.arrayData=[NSMutableArray arrayWithArray:self.filter.styles];
            self.isSelectBtnType=@"style";

            break;
        case 103:
//            类型
             self.arrayData=self.array3;
            break;
        default:
            break;
    }
    [self.seceneTableView reloadData];
}
#pragma mark -- UICollectionViewDataSource
//定义展示的UICollectionViewCell的个数
-(NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{

   return self.response.list.count;
    
}

//每个UICollectionView展示的内容
-(UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString * CellIdentifier = @"UICollectionViewCell";
    SeceneCollectionPictureCell * cell = (SeceneCollectionPictureCell*)[collectionView dequeueReusableCellWithReuseIdentifier:CellIdentifier forIndexPath:indexPath];
    cell.model = [self.response.list objectAtIndex_opple:indexPath.item];
   
    return cell;
}
#pragma mark --UICollectionViewDelegateFlowLayout
//定义每个Item 的大小
- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath
{
    return CGSizeMake(190, 130);
}

//定义每个UICollectionView 的边距
-(UIEdgeInsets)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout insetForSectionAtIndex:(NSInteger)section
{
    return UIEdgeInsetsMake(10, 10, 0, 20);
}
//定义每个UICollectionView 的纵向间距
-(CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout minimumInteritemSpacingForSectionAtIndex:(NSInteger)section{
    return 2;
}

#pragma mark --UICollectionViewDelegate

//UICollectionView被选中时调用的方法
-(void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    SeceneCollectionPictureCell * cell = (SeceneCollectionPictureCell *)[collectionView cellForItemAtIndexPath:indexPath];
    if ([self.delegate respondsToSelector:@selector(addSeceneImage:)]) {
        
        [self.delegate addSeceneImage:cell.imageView.image];
    }
}

//返回这个UICollectionView是否可以被选择
-(BOOL)collectionView:(UICollectionView *)collectionView shouldSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    return YES;
    
}
#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
          return self.arrayData.count;
     
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
        return 50;
    
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
           static NSString *cellID = @"ChooseTansferCell";
        SecenTableViewCell *cell = (SecenTableViewCell*)[tableView dequeueReusableCellWithIdentifier:cellID];
        if (cell == nil) {
            cell = [[SecenTableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
//                    cell.selectionStyle = UITableViewCellSelectionStyleNone;
        }
    if ([[[self.arrayData objectAtIndex_opple:indexPath.row] typename] isEqualToString:self.isSelectCell]) {
        cell.contentView.backgroundColor=RGB(221, 221, 221, 1);
        cell.textLabel.textColor=RGB(79, 153, 217, 1) ;
    }else
    {
        cell.contentView.backgroundColor=[UIColor whiteColor];
        cell.textLabel.textColor=[UIColor blackColor];
    }
        cell.textLabel.text=[[self.arrayData objectAtIndex_opple:indexPath.row] typename];
        
        return cell;
    
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if ([self.isSelectBtnType isEqualToString:@"style"]) {
        self.conditionModel.spaceEquals=nil;
         self.conditionModel.styleEquals=[[self.arrayData objectAtIndex_opple:indexPath.row] typecode];
    }else
    {
        self.conditionModel.styleEquals=nil;
         self.conditionModel.spaceEquals=[[self.arrayData objectAtIndex_opple:indexPath.row] typecode];
    }
    self.isSelectCell=[[self.arrayData objectAtIndex_opple:indexPath.row] typename];
    [self.seceneTableView reloadData];
    [self.collectionView.mj_header beginRefreshing];
}



-(void)DismissScreenView:(UITapGestureRecognizer*)sender{
    CGPoint point = [sender locationInView:self.view];
    if (point.x<100 || point.x >ScreenWidth-150||point.y<50||point.y>ScreenHeight-150) {
        
        if (self) {
            if ([self.delegate respondsToSelector:@selector(restSeceneBtnImage)]) {
                [self.delegate restSeceneBtnImage];
            }

            [self.view removeFromSuperview];
        }
    }
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
