//
//  SceneViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/6/1.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "SceneViewController.h"
#import "ScreeningTableViewCell.h"
#import "ScreeningCollectionViewCell.h"


@interface SceneViewController ()<UITableViewDelegate,UITableViewDataSource,UIGestureRecognizerDelegate,UICollectionViewDelegate,UICollectionViewDataSource>

@end

@implementation SceneViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    
    [self UiConfigAction];
    [self ReturnDismiss];
}

#pragma mark -UI
- (void)UiConfigAction
{
    self.styleButton.layer.masksToBounds = YES;
    self.styleButton.layer.cornerRadius = kSelectedCornerRadius;
    self.typeButton.layer.masksToBounds = YES;
    self.typeButton.layer.cornerRadius = kSelectedCornerRadius;
    self.spaceButton.layer.masksToBounds = YES;
    self.spaceButton.layer.cornerRadius = kSelectedCornerRadius;
    self.materialButton.layer.masksToBounds = YES;
    self.materialButton.layer.cornerRadius = kSelectedCornerRadius;
    self.priceButton.layer.masksToBounds = YES;
    self.priceButton.layer.cornerRadius = kSelectedCornerRadius;
    
    //筛选Tableview
    self.screeningTableView.delegate = self;
    self.screeningTableView.dataSource = self;
    [self.screeningTableView registerClass:[ScreeningTableViewCell class] forCellReuseIdentifier:@"ScreeningCellNew"];
    
    //数据列表UICollectionView
    self.collectionViewLayout.itemSize = CGSizeMake((self.sceneOrProductClollectionView.mj_w-40)/3, (self.sceneOrProductClollectionView.mj_w-40)/4);
    self.collectionViewLayout.minimumLineSpacing = 10;
    self.collectionViewLayout.minimumInteritemSpacing = 10;
    self.collectionViewLayout.sectionInset = UIEdgeInsetsMake(10, 10, 10, 10);
    self.sceneOrProductClollectionView.dataSource = self;
    self.sceneOrProductClollectionView.delegate = self;
}


#pragma mark - UITableViewDataSource代理
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 3;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    ScreeningTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"ScreeningCellNew" forIndexPath:indexPath];
    cell.screeningLabe.text = @"主卧室";
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 55;
}


#pragma mark -UICollectionViewDataSource代理
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return 10;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    ScreeningCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"ScreeningCollectioncell" forIndexPath:indexPath];
    cell.layer.shadowColor = [UIColor blackColor].CGColor;
    cell.layer.shadowRadius = 4;
    cell.layer.shadowOpacity = 0.7;
    cell.contentView.layer.shadowOffset = CGSizeMake(0, 0);
    cell.layer.masksToBounds = NO;
    return cell;
    
}






















#pragma mark -筛选条件
- (IBAction)ScreeningConditionsSelectedButtonClick:(UIButton *)sender {
    
    switch (sender.tag) {
        case 100://风格
        {
            
        }
            break;
        case 101://类型
        {
            
        }
            break;
        case 102://空间
        {
            
        }
            break;
        case 103://材质
        {
            
        }
            break;
        case 104://价格
        {
            
        }
            break;
            
        default:
            break;
    }
    
    
    
}


































#pragma mark -UIGestureRecognizerDelegate代理
- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldReceiveTouch:(UITouch *)touch
{
    //取消子视图的的时间穿透，否则子视图的点击无效，会被传递到父视图响应
    if (CGRectContainsPoint(self.clickEventView.frame, [touch locationInView:self.view.window])) {
        
        return NO;
    }
    return YES;
}


#pragma mark -返回手势
- (void)ReturnDismiss
{
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(ReturnButtonClickAction)];
    tap.delegate = self;
    [self.view addGestureRecognizer:tap];
}

#pragma mark -销毁
- (void)ReturnButtonClickAction
{
    [self dismissViewControllerAnimated:YES completion:nil];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
