//
//  RightViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "RightViewController.h"

@interface RightViewController ()<UITableViewDataSource,UITableViewDelegate>

@property (nonatomic,strong) UITableView *rightTableview;
@property (nonatomic,strong) NSArray *dataArray;

@end

@implementation RightViewController

/**
 *  初始化数据源
 *
 *  @return NSArray
 */
- (NSArray *)dataArray
{
    if (_dataArray == nil) {
        
        _dataArray = [NSArray arrayWithObjects:@"随心配",@"场景库",@"产品库",@"体验中心",@"客户管理",@"关于", nil];
    }
    return _dataArray;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self uiConfigAction];
}

#pragma mark -布局
- (void)uiConfigAction
{
    self.rightTableview = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, RightWidth, ScreenHeight) style:UITableViewStylePlain];
    self.rightTableview.delegate = self;
    self.rightTableview.dataSource = self;
    [self.view addSubview:self.rightTableview];
    self.rightTableview.tableFooterView = [UIView new];
    [self.rightTableview registerClass:[UITableViewCell class] forCellReuseIdentifier:@"rightcell"];
    [self createHeaderview];
}

#pragma mark -头部视图
- (void)createHeaderview
{
    UIView *headerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, RightWidth, 200)];
    UIImageView *imageView = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, 80, 80)];
    imageView.center = CGPointMake(RightWidth/2, 100);
    imageView.image = TCImage(@"weibo");
    [headerView addSubview:imageView];
    self.rightTableview.tableHeaderView = headerView;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"rightcell" forIndexPath:indexPath];
    cell.textLabel.text = [self.dataArray objectAtIndex_opple:indexPath.row];
    
    return  cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.dataArray.count;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.row) {
        case 0:  //随心配
            
            break;
        case 1:  //场景库
            
            break;

        case 2:  //产品库
            
            break;
        case 3: //体验中心
            
            break;
        case 4: //客户管理
            
            break;

        case 5://关于
            
            break;

            
        default:
            break;
    }
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
