//
//  NetworkRequestClassManager.h
//  Lighting
//
//  Created by 曹云霄 on 16/4/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>


//定义返回数据的block类型
typedef void (^ReturnValueBlock) (id returnValue);
typedef void (^ErrorCodeBlock) (id errorCodeValue);
typedef void (^FailureBlock)();


//定义请求类型
typedef enum {
    
    NetworkRequestWithPOST = 0, //POST
    NetworkRequestWithGET       //GET
    
}NetworkRequestType;


@interface NetworkRequestClassManager : NSObject

/**
 *  网络请求单例
 *
 *  @return NetworkRequestClassManager
 */
+ (NetworkRequestClassManager *)Manager;


/**
 *  网络请求
 *
 *  @param requestURLString     网址
 *  @param requestType          请求类型
 *  @param parameter            参数
 *  @param sueecssBlock         成功回调
 *  @param errorCodeBlock       错误编码回调
 *  @param failureBlock         失败回调
 */
- (void)NetworkRequestWithURL:(NSString *) requestURLString
                  WithRequestType:(NetworkRequestType) requestType
                    WithParameter:(NSDictionary *) parameter
             WithReturnValueBlock:(ReturnValueBlock) successBlock
              WithErrorCodeBlock:(ErrorCodeBlock) errorCodeBlock
                 WithFailureBlock:(FailureBlock) failureBlock;


















@end
