//
//  ClientdetailsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/3.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ClientdetailsViewController.h"
#import "ClientDetailsTableViewCell.h"
#import "OrderTableViewCell.h"
#import "OrderdetailsViewController.h"
#import "ShopcarModel.h"


@interface ClientdetailsViewController ()<UITableViewDelegate,UITableViewDataSource>

/**
 *  客户详情
 */
@property (weak, nonatomic) IBOutlet UITableView *ClientdetailsTableview;

/**
 *  购物车数据源
 */
@property (nonatomic,strong) NSMutableArray *shopResponseArray;

/**
 *  订单记录数据
 */
@property (nonatomic,strong) NSMutableArray *orderRecordArray;



@end

@implementation ClientdetailsViewController


/**
 *  购物袋数据源
 */
- (NSMutableArray *)shopResponseArray
{
    if (_shopResponseArray == nil) {
        
        _shopResponseArray = [NSMutableArray array];
    }
    return _shopResponseArray;
}


/**
 *  订单记录数据源
 */
- (NSMutableArray *)orderRecordArray
{
    if (_orderRecordArray == nil) {
        
        _orderRecordArray = [NSMutableArray array];
    }
    return _orderRecordArray;
}



- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self uiConfigAction];
}


#pragma mark -UI
- (void)uiConfigAction
{
    
    self.ClientdetailsTableview.delegate = self;
    self.ClientdetailsTableview.dataSource = self;
    
    //圆角
    self.shoppingAndRecordBackview.layer.masksToBounds = YES;
    self.shoppingAndRecordBackview.layer.cornerRadius = kCornerRadius;
    self.shoppingBagButton.layer.masksToBounds = YES;
    self.shoppingBagButton.layer.cornerRadius = kCornerRadius;
    self.orderRecordButton.layer.masksToBounds = YES;
    self.orderRecordButton.layer.cornerRadius = kCornerRadius;
    self.setupButton.layer.masksToBounds = YES;
    self.setupButton.layer.cornerRadius = kCornerRadius;
    
    //默认选中购物袋
    self.shoppingBagButton.selected = YES;
    self.shoppingBagButton.backgroundColor = [UIColor whiteColor];
    
    //赋值
    [self.customerHeader sd_setImageWithURL:[NSURL URLWithString:self.model.picture] placeholderImage:ReplaceImage];
    self.customerName.text = self.model.name;
    self.customerPhoneNumber.text = self.model.mobile;
    self.companyName.text = self.model.name;
    self.customerLocation.text = self.model.address;
}



- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.shoppingBagButton.selected) {
        
        ClientDetailsTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"ClientDetails" forIndexPath:indexPath];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.model = [self.orderRecordArray objectAtIndex_opple:indexPath.row];
        return cell;
        
    }else if (self.orderRecordButton.selected)
    {
        OrderTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"ordercell" forIndexPath:indexPath];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return  cell;
    }
    return  nil;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (self.shoppingBagButton.selected) {
        
        return self.shopResponseArray.count;
    }
    if (self.orderRecordButton.selected) {
        
        return self.orderRecordArray.count;
    }
    return 0;
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.shoppingBagButton.selected) {
        
        return 100;
    }
    else if (self.orderRecordButton.selected)
    {
        return 200;
    }
    return 0;
}



- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"StoryboardwithCYX" bundle:nil];
    OrderdetailsViewController *orderdetails = [storyboard instantiateViewControllerWithIdentifier:@"orderdetails"];
    [self.navigationController pushViewController:orderdetails animated:YES];
}



#pragma mark -获取购物车商品
- (void)getShoppingCardata
{
    
    ShopCartFilter *shopcarNumber = [[ShopCartFilter alloc]init];
    shopcarNumber.consumerId = [Customermanager manager].customerID;
    DataPage *Newpage = [[DataPage alloc]init];
    Newpage.page = 0;
    shopcarNumber.dp = Newpage;
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/shopcart/query"] WithRequestType:0 WithParameter:shopcarNumber WithReturnValueBlock:^(id returnValue) {
        
        [self RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            ShopCartResponse *shopcar = [[ShopCartResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            //自定义属性
            for (TOShopcartEntity *objc in shopcar.shopcart) {
                
                ShopcarModel *model = [[ShopcarModel alloc]init];
                model.goods = objc.goods;
                model.fid = objc.fid;
                model.createName = objc.createName;
                model.createBy = objc.createBy;
                model.createDate = objc.createDate;
                model.updateName = objc.updateName;
                model.updateBy = objc.updateBy;
                model.updateDate = objc.updateDate;
                model.goodsId = objc.goodsId;
                model.goodsNum = objc.goodsNum;
                model.consumerId = objc.consumerId;
                
                [self.shopResponseArray addObject:model];
            }
            
            [self.ClientdetailsTableview reloadData];
            
        }else
        {
            [self ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
    } WithFailureBlock:^(id error) {
        
        [self RemoveMBProgressHUDLoding];
    }];
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


#pragma mark -设为当前的客户
- (IBAction)SetupcurrentUserButtonClick:(UIButton *)sender {
    
    
}


#pragma mark -购物袋
- (IBAction)ShoppingbagButtonClick:(UIButton *)sender {
    
    
    sender.backgroundColor = [UIColor whiteColor];
    sender.selected = YES;
    self.orderRecordButton.selected = NO;
    self.orderRecordButton.backgroundColor = kMainBlueColor;
    
    [self.ClientdetailsTableview reloadData];
}

#pragma mark -订单记录
- (IBAction)OrderrecordButtonClick:(UIButton *)sender {
    
    
    sender.backgroundColor = [UIColor whiteColor];
    sender.selected = YES;
    self.shoppingBagButton.selected = NO;
    self.shoppingBagButton.backgroundColor = kMainBlueColor;
    [self.ClientdetailsTableview reloadData];
    
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
