//
//  ProductLibraryView.m
//  Lighting
//
//  Created by mac on 16/5/11.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ProductLibraryView.h"

@implementation ProductLibraryView
- (void)viewDidLoad {
    [self initdata];
    [self initSubView];

}

//- (instancetype)initWithFrame:(CGRect)frame
//{
//    if (self = [super initWithFrame:frame]) {
//        [self initdata];
//        [self initSubView];
//    }
//    return self;
//}
-(void)initdata
{
    self.arrayData=[[NSMutableArray alloc]init];
    self.nameData=[[NSMutableArray alloc]initWithObjects:@"风格",@"类型",@"空间",@"材质",@"价格", @"",@"高级",nil];
    self.array1=[[NSMutableArray alloc]initWithObjects:@"吊灯",@"壁灯",@"台灯",@"落地灯",@"吸顶灯", @"镜前灯",@"烛台灯",@"过厅灯",@"过道灯",@"商业照明",@"家具饰品",@"其他",nil];
    self.array2=[[NSMutableArray alloc]initWithObjects:@"水晶系列",@"金属系列",@"商照电工",@"陶瓷",@"木艺", @"其它",nil];
    self.array3=[[NSMutableArray alloc]initWithObjects:@"田园",@"宫廷",@"乡村",@"日式风格",@"欧式风格", @"混搭风格",@"现代简约",nil];
    self.arrayData=self.array3;
}

-(void)initSubView
{
    for (int i=0; i<self.nameData.count; i++) {
        if (i !=5) {
            UIButton *btn=[UIButton buttonWithType:UIButtonTypeCustom];
            btn.frame=CGRectMake(ScreenWidth-190, 52+i*50, 50, 46) ;
            btn.backgroundColor=[UIColor whiteColor];
            [btn setTitle:[self.nameData objectAtIndex:i] forState:UIControlStateNormal];
            [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
//            btn.contentEdgeInsets = UIEdgeInsetsMake(0, 60, 0, 0);
            [btn addTarget:self action:@selector(selectedType:) forControlEvents:UIControlEventTouchUpInside];
            btn.tag=100 +i;
            btn.layer.masksToBounds = YES;
            btn.layer.cornerRadius = 23;
            [self.view addSubview:btn];
        }
       
    }
    self.subView=[[UIView alloc]initWithFrame:CGRectMake(100, 50, ScreenWidth-300, ScreenHeight-200)];
    self.subView.backgroundColor=[UIColor whiteColor];
    [self.view  addSubview:self.subView];

    //点击手势
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(DismissScreenView:)];
    tap.delegate = self;
    tap.cancelsTouchesInView = NO;
    [[UIApplication sharedApplication].keyWindow addGestureRecognizer:tap];
    [self initSubViews];
}


-(void)initSubViews
{
    self.headerView=[[UIView alloc]initWithFrame:CGRectMake(0, 0, self.subView.frame.size.width-100, 50)];
    self.headerView.backgroundColor=[UIColor grayColor];
    [self.subView addSubview:self.headerView];
    UIButton *btn=[UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame=CGRectMake(10, 10, 30, 30);
    [btn setBackgroundImage:[UIImage imageNamed:@"changjingtubiao"] forState:UIControlStateNormal];
    [self.headerView addSubview:btn];
    UILabel *lable=[[UILabel alloc]initWithFrame:CGRectMake(45, 10, 100, 30)];
    lable.text=@"选择产品";
    [self.headerView addSubview:lable];
    self.seceneTableView=[[UITableView alloc]initWithFrame:CGRectMake( self.headerView.frame.size.width, 0, 100, self.subView.frame.size.height)];
    self.seceneTableView.delegate=self;
    self.seceneTableView.dataSource=self;
    [self.subView addSubview:self.seceneTableView];
    
 
    //确定是水平滚动，还是垂直滚动
    UICollectionViewFlowLayout *flowLayout=[[UICollectionViewFlowLayout alloc] init];
    [flowLayout setScrollDirection:UICollectionViewScrollDirectionVertical];
    
    self.collectionView=[[UICollectionView alloc] initWithFrame:CGRectMake( 0, 50, self.headerView.frame.size.width, self.subView.frame.size.height-50) collectionViewLayout:flowLayout];
    self.collectionView.dataSource=self;
    self.collectionView.delegate=self;
    [self.collectionView setBackgroundColor:[UIColor clearColor]];
    
    //注册Cell，必须要有
    [self.collectionView registerClass:[ProductCollectionPictureCell class] forCellWithReuseIdentifier:@"UICollectionViewCell"];
    
    [self.subView addSubview:self.collectionView];
}
-(void)selectedType:(UIButton *)sender
{

            switch (sender.tag) {
                case 100:
                    //            风格
                    self.arrayData=self.array3;
                    break;
                case 101:
                    //            类型
                    self.arrayData=self.array2;
                    break;
                case 102:
                    //            空间
                    self.arrayData=self.array1;
                    break;
                case 103:
                    //            材质
                    self.arrayData=self.array3;
                    break;
                case 104:
                    //            价格
                    self.arrayData=self.array3;
                    break;
                case 106:
                    //            高级
                    self.arrayData=self.array3;
                    break;
                default:
                    break;
            }
    [self.seceneTableView reloadData];
}
#pragma mark -- UICollectionViewDataSource
//定义展示的Section的个数
-(NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView
{
    return 10;
}
//定义展示的UICollectionViewCell的个数
-(NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return 3;
}

//每个UICollectionView展示的内容
-(UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString * CellIdentifier = @"UICollectionViewCell";
    ProductCollectionPictureCell * cell = (ProductCollectionPictureCell*)[collectionView dequeueReusableCellWithReuseIdentifier:CellIdentifier forIndexPath:indexPath];
    
    
    return cell;
}
#pragma mark --UICollectionViewDelegateFlowLayout
//定义每个Item 的大小
- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath
{
    return CGSizeMake(190, 130);
}

//定义每个UICollectionView 的边距
-(UIEdgeInsets)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout insetForSectionAtIndex:(NSInteger)section
{
    return UIEdgeInsetsMake(10, 10, 0, 20);
}
//定义每个UICollectionView 的纵向间距
-(CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout minimumInteritemSpacingForSectionAtIndex:(NSInteger)section{
    return 2;
}

#pragma mark --UICollectionViewDelegate

//UICollectionView被选中时调用的方法
-(void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    ProductCollectionPictureCell * cell = (ProductCollectionPictureCell *)[collectionView cellForItemAtIndexPath:indexPath];
    if ([self.delegate respondsToSelector:@selector(addProductImage:)]) {
        
        [self.delegate addProductImage:cell.productImageView.image];
    }

}

//返回这个UICollectionView是否可以被选择
-(BOOL)collectionView:(UICollectionView *)collectionView shouldSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    return YES;
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{    if ([tableView isEqual:self.seceneTableView])
{
    return self.arrayData.count;
}else
{
    return 5;
}
    
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if ([tableView isEqual:self.seceneTableView])
    {
        return 50;
    }else
    {
        return 150;
    }
    
    
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
           static NSString *cellID = @"ChooseTansferCell";
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
        if (cell == nil) {
            cell = [[UITableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
         
        }
        
        cell.textLabel.text=[self.arrayData objectAtIndex:indexPath.row];
//        05产品库-详情_03
        return cell;
        
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    
}

-(void)DismissScreenView:(UITapGestureRecognizer*)sender{
    CGPoint point = [sender locationInView:self.view];
    if (point.x<100 || point.x >ScreenWidth-100||point.y<50||point.y>ScreenHeight-150) {
        
        if (self) {
            [self.view removeFromSuperview];
        }
    }
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
