//
//  ModifyShippingAddressView.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/5.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ModifyShippingAddressView.h"

@implementation ModifyShippingAddressView

{
    NSMutableArray *provinces;         //城市大数组
    NSArray *cities;                   //城市小数组
    NSString *provincesString;         //省份
    NSString *cityString;              //城市
    NSString *cityIDstring;            //城市ID
    NSString *_cityCode;               //城市编码
}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

- (void)awakeFromNib
{
    [self uiConfigAction];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.cityPickerView.delegate = self;
    self.cityPickerView.dataSource = self;
    NSString *path = [[NSBundle mainBundle] pathForResource:@"city" ofType:@"json"];
    NSString *string = [NSString stringWithContentsOfFile:path encoding:NSUTF8StringEncoding error:nil];
    NSData *data = [string dataUsingEncoding:NSUTF8StringEncoding];
    provinces = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers error:nil];
    cities  = [[provinces objectAtIndex:0] objectForKey:@"list"];
}



#pragma mark -城市选择器代理方法
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView
{
    return 2;
}

- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)componen
{
    switch (componen) {
        case 0:
        {
            return [provinces count];
        }
            break;
        case 1:
        {
            return [cities count];
        }
            break;
            
        default:
            break;
    }
    return 0;
}


- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component
{
    switch (component)
    {
        case 0:
            return [[provinces objectAtIndex:row] objectForKey:@"name"];
            break;
        case 1:
            return [[cities objectAtIndex:row] objectForKey:@"name"];
            break;
        default:
            return nil;
            break;
    }
}


- (void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component
{
    switch (component)
    {
        case 0:
            cities  = [[provinces objectAtIndex:row] objectForKey:@"list"];
            [self.cityPickerView selectRow:0 inComponent:1 animated:NO];
            [self.cityPickerView reloadComponent:1];
            provincesString = [[provinces objectAtIndex:row] objectForKey:@"name"];
            cityString = [[cities objectAtIndex:0] objectForKey:@"name"];
            _cityCode = [[cities objectAtIndex:0] objectForKey:@"code"];//城市编码
            
            break;
        case 1:
            
            cityString = [[cities objectAtIndex:row] objectForKey:@"name"];
            cityIDstring = [[cities objectAtIndex:row] objectForKey:@"code"];
            _cityCode = [NSString stringWithFormat:@"%@",[[cities objectAtIndex:row] objectForKey:@"code"]];//城市编码
            
            break;
            
        default:
            break;
    }
    
    if ([self.delegate respondsToSelector:@selector(citySelected:)]) {
        [self.delegate citySelected:cityString];
    }
    
}


- (UIView *)pickerView:(UIPickerView *)pickerView viewForRow:(NSInteger)row forComponent:(NSInteger)component reusingView:(UIView *)view{
    UILabel* pickerLabel = (UILabel*)view;
    if (!pickerLabel){
        pickerLabel = [[UILabel alloc] init];
        pickerLabel.adjustsFontSizeToFitWidth = YES;
        pickerLabel.textColor = kMainBlueColor;
        pickerLabel.textAlignment = NSTextAlignmentCenter;
        [pickerLabel setBackgroundColor:[UIColor clearColor]];
        [pickerLabel setFont:[UIFont boldSystemFontOfSize:15]];
    }
    // Fill the label text here
    pickerLabel.text=[self pickerView:pickerView titleForRow:row forComponent:component];
    return pickerLabel;
}



@end
