//
//  ShoppingViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ShoppingViewController.h"
#import "ShoppingTableViewCell.h"
#import "AppDelegate.h"
#import "GenerateOrdersViewController.h"
#import "ShopcarModel.h"

@interface ShoppingViewController ()<UITableViewDelegate,UITableViewDataSource>


@property (weak, nonatomic) IBOutlet UITableView *shoppingTableview;




/**
 *  购物车数据源
 */
@property (nonatomic,strong) NSMutableArray *shopResponseArray;
@end

@implementation ShoppingViewController


/**
 *  数据源
 */
- (NSMutableArray *)shopResponseArray
{
    if (_shopResponseArray == nil) {
        
        _shopResponseArray = [NSMutableArray array];
    }
    return _shopResponseArray;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self uiConfigAction];
    [self getShoppingCardata];
}


- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    // 禁用 iOS7 返回手势
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = NO;
    }
}

- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    
    [self.shopResponseArray removeAllObjects];
    [self getShoppingCardata];
    // 开启
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = YES;
    }
}


#pragma mark - UI
- (void)uiConfigAction
{
    self.view.backgroundColor = kTCColor(238, 238, 238);
    self.shoppingTableview.dataSource = self;
    self.shoppingTableview.delegate = self;
    self.shoppingTableview.backgroundColor = [UIColor clearColor];
    self.shoppingTableview.tableFooterView = [UIView new];
}

#pragma mark -获取购物车商品
- (void)getShoppingCardata
{
    //判断是否需要请求数据-通过当前客户ID
    if (![Shoppersmanager manager].currentCustomer) {
        
        return;
    }
    ShopCartFilter *shopcarNumber = [[ShopCartFilter alloc]init];
    shopcarNumber.consumerId = [Customermanager manager].customerID;
    DataPage *Newpage = [[DataPage alloc]init];
    Newpage.page = 0;
    shopcarNumber.dp = Newpage;
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/shopcart/query"] WithRequestType:0 WithParameter:shopcarNumber WithReturnValueBlock:^(id returnValue) {
        
        [self RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            ShopCartResponse *shopcar = [[ShopCartResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            //自定义属性
            for (TOShopcartEntity *objc in shopcar.shopcart) {
                
                ShopcarModel *model = [[ShopcarModel alloc]init];
                model.goods = objc.goods;
                model.fid = objc.fid;
                model.createName = objc.createName;
                model.createBy = objc.createBy;
                model.createDate = objc.createDate;
                model.updateName = objc.updateName;
                model.updateBy = objc.updateBy;
                model.updateDate = objc.updateDate;
                model.goodsId = objc.goodsId;
                model.goodsNum = objc.goodsNum;
                model.consumerId = objc.consumerId;
                [self.shopResponseArray addObject:model];
            }
            [self.shoppingTableview reloadData];
        }else
        {
            [self ErrorMBProgressView:returnValue[@"message"]];
        }
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
    } WithFailureBlock:^(id error) {
        
        [self RemoveMBProgressHUDLoding];
    }];
}



- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    ShoppingTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"Shopping" forIndexPath:indexPath];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.model = [self.shopResponseArray objectAtIndex_opple:indexPath.row];
    cell.cellindex = indexPath.row;
    //cell选中回调
    [cell setReturnCellblock:^(NSInteger index) {
        
        [self setSelectedButton:index];
    }];
    return  cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.shopResponseArray.count;
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 80;
}


- (void)tableView:(UITableView *)tableView didDeselectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [self.shoppingTableview deselectRowAtIndexPath:indexPath animated:YES];
}


#pragma mark -选中商品回调
- (void)setSelectedButton:(NSInteger)index;
{
    ShopcarModel *model = [self.shopResponseArray objectAtIndex_opple:index];
    model.isSelected = !model.isSelected;
    
    NSInteger goodsNumber = 0;
    for (ShopcarModel *model in self.shopResponseArray) {
        if (model.isSelected) {
            goodsNumber ++;
        }
    }
    [self.settlementButton setTitle:[NSString stringWithFormat:@"去结算(%ld)",goodsNumber] forState:UIControlStateNormal];
}


#pragma mark -结算
- (IBAction)settlementButtonClick:(UIButton *)sender {
    
    NSMutableArray *array = [NSMutableArray array];
    for (ShopcarModel *model in self.shopResponseArray) {
        if (model.isSelected) {
            [array addObject:model];
        }
    }
    if (array.count == 0) {
        
        [self ErrorMBProgressView:@"没有选中任何商品"];
        return;
    }
    //占位
    ShopcarModel *ZhanweiModel = [[ShopcarModel alloc]init];
    [array addObject:ZhanweiModel];
    GenerateOrdersViewController *generateOrder = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"generateorders"];
    generateOrder.settlementGoodsdatas = array;
    [self.navigationController pushViewController:generateOrder animated:YES];
}

#pragma mark -全选
- (IBAction)allSelectedButtonClick:(UIButton *)sender {
    
    
    sender.selected = !sender.selected;
    if (sender.selected) {
        
        //全部选中
        for (ShoppingTableViewCell *cell in self.shoppingTableview.visibleCells) {
            
            cell.selectedButton.selected = YES;
        }
        for (ShopcarModel *model in self.shopResponseArray) {
            
            model.isSelected = YES;
        }
    }else
    {
        //取消全部选中
        for (ShoppingTableViewCell *cell in self.shoppingTableview.visibleCells) {
            
            cell.selectedButton.selected = NO;
        }
        for (ShopcarModel *model in self.shopResponseArray) {
            
            model.isSelected = NO;
        }
    }
}


#pragma mark -删除选中商品
- (IBAction)delecteSelectedGoods:(UIButton *)sender {

    
    [self CreateMBProgressHUDLoding];
    DeleteCartRequest *delecteGoods = [[DeleteCartRequest alloc]init];
    //code数组
    NSMutableArray *codeArr = [NSMutableArray array];
    //需要删除的cell数组indexpath
    NSMutableArray *delecteArray = [NSMutableArray array];
    //模型数组
    NSMutableArray *delectemodel = [NSMutableArray array];
    for (int i=0; i<self.shopResponseArray.count; i++) {
        
        ShopcarModel *model = [self.shopResponseArray objectAtIndex_opple:i];
        if (model.isSelected) {
            
            [codeArr addObject:model.fid];
            [delectemodel addObject:model];
            NSIndexPath *indexpath = [NSIndexPath indexPathForRow:i inSection:0];
            [delecteArray addObject:indexpath];
        }
    }
    //没有选中任何商品
    if (codeArr.count == 0) {
        [self RemoveMBProgressHUDLoding];
        return;
    }
    delecteGoods.cartIds = codeArr;
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/shopcart/delete"] WithRequestType:0 WithParameter:delecteGoods WithReturnValueBlock:^(id returnValue) {
        
        [self RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            //删除商品
            for (ShopcarModel *model in delectemodel) {
                [self.shopResponseArray removeObject:model];
            }
            [self.shoppingTableview deleteRowsAtIndexPaths:delecteArray withRowAnimation:UITableViewRowAnimationLeft];
            [self SuccessMBProgressView:@"删除成功"];
            
        }else
        {
            [self ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
        
    } WithFailureBlock:^(id error) {
        
        [self RemoveMBProgressHUDLoding];
        
    }];
    
    
}





- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
