//
//  BaseViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "BaseViewController.h"

@interface BaseViewController ()<UIPrintInteractionControllerDelegate>

@property (nonatomic,strong) MBProgressHUD*TCHud;
@property (nonatomic,strong) UIWebView *webView;

@end

@implementation BaseViewController


/**
 *  创建MBProgressHUD对象
 *
 *  @return MBProgressHUD
 */
- (MBProgressHUD *)TCHud
{
    if (_TCHud == nil) {
        
        _TCHud = [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    }
    return _TCHud;
}


- (UIWebView *)webView
{
    if (_webView == nil) {
        
        _webView = [[UIWebView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, ScreenHeight)];
    }
    return _webView;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.automaticallyAdjustsScrollViewInsets = NO;
    self.view.backgroundColor = [UIColor whiteColor];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark -渐隐提示框回调
- (void)SHOWPrompttext:(NSString *)Text ComcpleteBlock:(void(^)())completed
{
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:self.view.window animated:YES];
    hud.labelText = Text;
    hud.animationType = MBProgressHUDAnimationZoom;
    hud.mode = MBProgressHUDModeText;
    hud.removeFromSuperViewOnHide = YES;
    [hud hide:YES afterDelay:2.0f];
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(2 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        if (completed) {
            completed();
        }
    });
}

#pragma mark -显示MBProgressHUD等待视图
- (void)CreateMBProgressHUDLoding
{
    self.TCHud.animationType = MBProgressHUDAnimationZoom;
    self.TCHud.mode = MBProgressHUDModeIndeterminate;
    self.TCHud.color = [UIColor clearColor];
    self.TCHud.activityIndicatorColor = kMainBlueColor;
    self.TCHud.removeFromSuperViewOnHide = YES;
}

#pragma mark -移除MBProgressHUD等待视图
- (void)RemoveMBProgressHUDLoding;
{
    [self.TCHud hide:YES afterDelay:1];
    self.TCHud = nil;
}


#pragma mark -显示成功的提示框
- (void)SuccessMBProgressView:(NSString *)successString
{
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:self.view.window animated:YES];
    // Set the custom view mode to show any view.
    hud.mode = MBProgressHUDModeCustomView;
    // Set an image view with a checkmark.
    UIImage *image = [[UIImage imageNamed:@"Checkmark"] imageWithRenderingMode:UIImageRenderingModeAlwaysTemplate];
    hud.customView = [[UIImageView alloc] initWithImage:image];
    // Looks a bit nicer if we make it square.
    hud.square = YES;
    // Optional label text.
    hud.activityIndicatorColor = kMainBlueColor;
    hud.labelFont = [UIFont systemFontOfSize:12];
    hud.labelText = successString;
    [hud hide:YES afterDelay:1];
}

#pragma mark -显示错误的提示框
- (void)ErrorMBProgressView:(NSString *)errorString
{
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:self.view.window animated:YES];
    // Set the custom view mode to show any view.
    hud.mode = MBProgressHUDModeCustomView;
    // Set an image view with a checkmark.
    UIImage *image = [[UIImage imageNamed:@"Error"] imageWithRenderingMode:UIImageRenderingModeAlwaysTemplate];
    hud.customView = [[UIImageView alloc] initWithImage:image];
    // Looks a bit nicer if we make it square.
    hud.square = YES;
    // Optional label text.
    hud.activityIndicatorColor = kMainBlueColor;
    hud.labelFont = [UIFont systemFontOfSize:12];
    hud.labelText = errorString;
    [hud hide:YES afterDelay:1];
}



#pragma mark -渐隐提示框
- (void)SHOWPrompttext:(NSString *)Text
{
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    hud.labelText = Text;
    hud.margin = 10.f;
    hud.animationType = MBProgressHUDAnimationZoom;
    hud.mode = MBProgressHUDModeText;
    hud.removeFromSuperViewOnHide = YES;
    [hud hide:YES afterDelay:1.0f];
    
}


#pragma mark -结束MJRfresh刷新
- (void)endRefreshingForTableView:(UIScrollView *)TableView
{
    if (TableView.mj_header.isRefreshing) {
        
        [TableView.mj_header endRefreshing];
    }
    else if (TableView.mj_footer.isRefreshing)
    {
        [TableView.mj_footer endRefreshing];
    }
}

#pragma mark -获得我的storyboard对象
- (UIStoryboard *)getStoryboardWithName
{
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"StoryboardwithCYX" bundle:nil];
    return storyboard;
}

#pragma mark 调用airPrint无线打印机
- (void)callAirprintWithdata:(NSString *)PDFpath SuccessBlock:(void(^)())success ErrorBlock:(void(^)())failed
{
    
    NSData *mypdfdata = [NSData dataWithContentsOfFile:PDFpath];
    UIPrintInteractionController *pic = [UIPrintInteractionController sharedPrintController];
    if  (pic && [UIPrintInteractionController canPrintData: mypdfdata] ) {
        pic.delegate = self;
        UIPrintInfo *printInfo = [UIPrintInfo printInfo];
        printInfo.outputType = UIPrintInfoOutputGeneral;
        printInfo.jobName = @"订单明细";
        printInfo.duplex = UIPrintInfoDuplexLongEdge;
        pic.printInfo = printInfo;
        pic.showsPageRange = YES;
        pic.printingItem = mypdfdata;
        
        void (^completionHandler)(UIPrintInteractionController *, BOOL, NSError *) = ^(UIPrintInteractionController *pic, BOOL completed, NSError *error) {
            if (completed)
            {
                // 执行成功后的处理
                success();
            }
            else if (!completed && error)
            {
                // 执行失败后的处理
                failed();
            }
        };
        
        if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad) {
            
            [pic presentAnimated:YES completionHandler:completionHandler];
        }
    }
}





#pragma mark 调用airPrint无线打印机
- (void)callAirprintWithURL:(NSURL *)datasurl SuccessBlock:(void (^)())success ErrorBlock:(void (^)())failed
{
//    NSData *mypdfdata = [NSData dataWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"The Swift Programming Language 中文版 - v1.2" ofType:@"pdf"]];
    
    UIPrintInteractionController *pic = [UIPrintInteractionController sharedPrintController];

        pic.delegate = self;
        [self.webView loadRequest:[NSURLRequest requestWithURL:datasurl]];//网页
        pic.printFormatter = [self.webView viewPrintFormatter];//布局打印视图绘制的内容。
        
        UIPrintInfo *printInfo = [UIPrintInfo printInfo];
        printInfo.outputType = UIPrintInfoOutputGeneral;
        printInfo.jobName = @"订单明细";
        printInfo.duplex = UIPrintInfoDuplexShortEdge;
        pic.printInfo = printInfo;
        pic.showsPageRange = YES;
    
    void (^completionHandler)(UIPrintInteractionController *, BOOL, NSError *) = ^(UIPrintInteractionController *pic, BOOL completed, NSError *error) {
        if (completed)
        {
            // 执行成功后的处理
            success();
        }
        else if (!completed && error)
        {
            // 执行失败后的处理
            failed();
        }
    };

    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad) {
        
        [pic presentAnimated:YES completionHandler:completionHandler];
    }
}


















@end
