//
//  CardBeenUseViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/10/19.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CardBeenUseViewController.h"
#import "CardCollectionViewCell.h"
#import "CardOrderInformationReusableView.h"
#import "CardAmplificationViewController.h"

@interface CardBeenUseViewController ()<UICollectionViewDataSource,UICollectionViewDelegate,DZNEmptyDataSetSource,DZNEmptyDataSetDelegate>


@property (nonatomic,strong) RsJingDongECardRequest *requestModel;

/**
 *  数据源
 */
@property (nonatomic,strong) NSMutableArray *datasArray;

/**
 *  总页数
 */
@property (nonatomic,assign) NSInteger totalPage;
@end

@implementation CardBeenUseViewController

#pragma mark - lazy
- (RsJingDongECardRequest *)requestModel
{
    if (!_requestModel) {
        _requestModel = [[RsJingDongECardRequest alloc]init];
        DataPage *page = [[DataPage alloc]init];
        page.page = 0;
        page.rows = 10;
        page.order = @"desc";
        _requestModel.guideIdEquals = [Shoppersmanager manager].Shoppers.employee.fid;
        _requestModel.stateEquals = @"actived";
        _requestModel.page = page;
    }
    return _requestModel;
}

- (NSMutableArray *)datasArray
{
    if (!_datasArray) {
        _datasArray = [NSMutableArray array];
    }
    return _datasArray;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupCollectionView];
    [self setupRefreshAction];
}

#pragma mark - 设置刷新
- (void)setupRefreshAction
{
    WS(weakSelf);
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        weakSelf.requestModel.page.page = 0;
        [weakSelf.beenUseCardCollectionView.mj_footer resetNoMoreData];
        [weakSelf getCardDatasAction:YES];
    }];
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    self.beenUseCardCollectionView.mj_header = headerRefresh;
    [self.beenUseCardCollectionView.mj_header beginRefreshing];
    
    MJRefreshAutoNormalFooter *footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        if (++ weakSelf.requestModel.page.page >= weakSelf.totalPage) {
            [weakSelf.beenUseCardCollectionView.mj_footer endRefreshingWithNoMoreData];
        }else
        {
            [weakSelf getCardDatasAction:NO];
        }
    }];
    footer.automaticallyHidden = YES;
    self.beenUseCardCollectionView.mj_footer = footer;
}

#pragma mark - 获取未使用卡劵
- (void)getCardDatasAction:(BOOL)isRemove
{
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(CARDINFORMATION) WithRequestType:Zero WithParameter:self.requestModel WithReturnValueBlock:^(id returnValue) {
        
        weakSelf.beenUseCardCollectionView.emptyDataSetSource = self;
        weakSelf.beenUseCardCollectionView.emptyDataSetDelegate = self;
        [weakSelf endRefreshingForTableView:weakSelf.beenUseCardCollectionView];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            [weakSelf.datasArray removeAllObjects];
            RsJingDongECardResponse *cardInformation = [[RsJingDongECardResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            weakSelf.totalPage = cardInformation.totalpages;
            [weakSelf.datasArray addObjectsFromArray:cardInformation.list];
            [weakSelf.beenUseCardCollectionView reloadData];
        }else{
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}

#pragma mark - UICollectionView
- (void)setupCollectionView
{
    self.beenUseLayout.itemSize = CGSizeMake((ScreenWidth-48-20*4)/3, 200);
    self.beenUseLayout.sectionInset = UIEdgeInsetsMake(20, 20, 20, 20);
    self.beenUseLayout.minimumLineSpacing = 20;
    self.beenUseLayout.minimumInteritemSpacing = 20;
    [self.beenUseCardCollectionView registerNib:[UINib nibWithNibName:@"CardOrderInformationReusableView" bundle:nil] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"CardOrderInformationReusableView"];
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    CardCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"CardCollectionViewCell" forIndexPath:indexPath];
    
    return cell;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    GroupByOrderNumber *model = self.datasArray[section];
    return model.ecards.count;
}

- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath
{
    if (kind == UICollectionElementKindSectionHeader) {
        CardOrderInformationReusableView *headerView = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"CardOrderInformationReusableView" forIndexPath:indexPath];
        headerView.model = self.datasArray[indexPath.section];
        headerView.uploadReceiptsButton.hidden = true;
        return headerView;
    }
    return nil;
}

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout referenceSizeForHeaderInSection:(NSInteger)section
{
    return CGSizeMake(0, 65);
}

- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView
{
    return self.datasArray.count;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    CardAmplificationViewController *settlement = [[CardAmplificationViewController alloc]init];
    settlement.preferredContentSize = CGSizeMake(500, 370);
    settlement.modalPresentationStyle = UIModalPresentationFormSheet;
    UIPopoverPresentationController *pop = settlement.popoverPresentationController;
    pop.sourceView = settlement.view;
    [self presentViewController:settlement animated:YES completion:nil];
}

#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return kNoDataImage;
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    return [[NSAttributedString alloc]initWithString:@"暂无数据" attributes:nil];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}



@end
