//
//  CardDetailsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/10/19.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CardDetailsViewController.h"
#import "CardDontUseViewController.h"
#import "CardBeenUseViewController.h"

@interface CardDetailsViewController ()

/**
 *  当前的控制器
 */
@property (nonatomic,strong) UIViewController *currentVC;

@end

@implementation CardDetailsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self addChildViewController];
}

#pragma mark - 添加卡劵详情vc
- (void)addChildViewController
{
    CardDontUseViewController *dontUseVc = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"CardDontUseViewController"];
    [self addChildViewController:dontUseVc];

    CardBeenUseViewController *beenUseVc = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"CardBeenUseViewController"];
    [self addChildViewController:beenUseVc];
    dontUseVc.view.frame = CGRectMake(0, 0, self.cardBackgroundView.mj_w, self.cardBackgroundView.mj_h);
    beenUseVc.view.frame = CGRectMake(0, 0, self.cardBackgroundView.mj_w, self.cardBackgroundView.mj_h);
    [self.cardBackgroundView addSubview:dontUseVc.view];
    self.currentVC = dontUseVc;
}


#pragma mark - 切换已使用卡劵、未使用卡劵
- (void)switchPaymentsVCAndWithdrawalVC:(UIViewController *)newViewController
{
    [self transitionFromViewController:self.currentVC toViewController:newViewController duration:0.5 options:UIViewAnimationOptionTransitionNone animations:nil completion:^(BOOL finished) {
        if (finished) {
            [self.cardBackgroundView addSubview:newViewController.view];
            self.currentVC = newViewController;
        }
    }];
}

#pragma mark - 切换ContentController
- (IBAction)paymentsButtonAndWithdrawalButtonClick:(UIButton *)sender {
    
    if ([sender isEqual:self.dontUseButton]) {
        sender.selected = YES;
        self.beenUseButton.selected = NO;
    }else
    {
        sender.selected = YES;
        self.dontUseButton.selected = NO;
    }
    [self setupInstructionsViewOrigin:sender];
    [self switchPaymentsVCAndWithdrawalVC:self.childViewControllers[sender.tag-100]];
}

#pragma mark - 设置指示线的位置
- (void)setupInstructionsViewOrigin:(UIButton *)sender
{
    [UIView animateWithDuration:0.5 delay:0.1f usingSpringWithDamping:0.5f initialSpringVelocity:0.5f options:UIViewAnimationOptionCurveEaseInOut animations:^{
        self.instructionsLineView.frame = CGRectMake(sender.mj_origin.x+(sender.mj_w-self.instructionsLineView.mj_w)/2, self.instructionsLineView.mj_origin.y, self.instructionsLineView.mj_w, 2);
    } completion:nil];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}


@end
