//
//  CardDontUseViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/10/19.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CardDontUseViewController.h"
#import "CardCollectionViewCell.h"
#import "CardOrderInformationReusableView.h"
#import "DeviceDirectionManager.h"
#import "CardAmplificationViewController.h"

@interface CardDontUseViewController ()<UICollectionViewDataSource,UICollectionViewDelegate,UploadReceiptsDelegate,UINavigationControllerDelegate,UIImagePickerControllerDelegate,DZNEmptyDataSetSource,DZNEmptyDataSetDelegate>


@property (nonatomic,strong) RsJingDongECardRequest *requestModel;

/**
 *  数据源
 */
@property (nonatomic,strong) NSMutableArray *datasArray;

/**
 *  总页数
 */
@property (nonatomic,assign) NSInteger totalPage;

/**
 *  记录上传小票时的订单号
 */
@property (nonatomic,copy) NSString *orderNumber;

@end

@implementation CardDontUseViewController

#pragma mark - lazy
- (RsJingDongECardRequest *)requestModel
{
    if (!_requestModel) {
        _requestModel = [[RsJingDongECardRequest alloc]init];
        DataPage *page = [[DataPage alloc]init];
        page.page = 0;
        page.rows = 10;
        page.order = @"desc";
        _requestModel.guideIdEquals = [Shoppersmanager manager].Shoppers.employee.fid;
        _requestModel.stateEquals = @"dispensed";
        _requestModel.page = page;
    }
    return _requestModel;
}

- (NSMutableArray *)datasArray
{
    if (!_datasArray) {
        _datasArray = [NSMutableArray array];
    }
    return _datasArray;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupCollectionView];
    [self setupRefreshAction];
}

#pragma mark - UICollectionView
- (void)setupCollectionView
{
    self.dontUseFlowLayout.itemSize = CGSizeMake((ScreenWidth-48-20*4)/3, 200);
    self.dontUseFlowLayout.sectionInset = UIEdgeInsetsMake(20, 20, 20, 20);
    self.dontUseFlowLayout.minimumLineSpacing = 20;
    self.dontUseFlowLayout.minimumInteritemSpacing = 20;
    [self.dontUseCardCollectionView registerNib:[UINib nibWithNibName:@"CardOrderInformationReusableView" bundle:nil] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"CardOrderInformationReusableView"];
}

#pragma mark - 设置刷新
- (void)setupRefreshAction
{
    WS(weakSelf);
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        weakSelf.requestModel.page.page = 0;
        [weakSelf.dontUseCardCollectionView.mj_footer resetNoMoreData];
        [weakSelf getCardDatasAction:YES];
    }];
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    self.dontUseCardCollectionView.mj_header = headerRefresh;
    [self.dontUseCardCollectionView.mj_header beginRefreshing];
    
    MJRefreshAutoNormalFooter *footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        if (++ weakSelf.requestModel.page.page >= weakSelf.totalPage) {
            [weakSelf.dontUseCardCollectionView.mj_footer endRefreshingWithNoMoreData];
        }else
        {
            [weakSelf getCardDatasAction:NO];
        }
    }];
    footer.automaticallyHidden = YES;
    self.dontUseCardCollectionView.mj_footer = footer;
}

#pragma mark - 获取未使用卡劵
- (void)getCardDatasAction:(BOOL)isRemove
{
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(CARDINFORMATION) WithRequestType:Zero WithParameter:self.requestModel WithReturnValueBlock:^(id returnValue) {
        
        weakSelf.dontUseCardCollectionView.emptyDataSetSource = self;
        weakSelf.dontUseCardCollectionView.emptyDataSetDelegate = self;
        [weakSelf endRefreshingForTableView:weakSelf.dontUseCardCollectionView];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            [weakSelf.datasArray removeAllObjects];
            RsJingDongECardResponse *cardInformation = [[RsJingDongECardResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            weakSelf.totalPage = cardInformation.totalpages;
            [weakSelf.datasArray addObjectsFromArray:cardInformation.list];
            [weakSelf.dontUseCardCollectionView reloadData];
        }else{
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    CardCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"CardCollectionViewCell" forIndexPath:indexPath];
    
    return cell;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    GroupByOrderNumber *model = self.datasArray[section];
    return model.ecards.count;
}

- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath
{
    if (kind == UICollectionElementKindSectionHeader) {
        CardOrderInformationReusableView *headerView = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"CardOrderInformationReusableView" forIndexPath:indexPath];
        headerView.delegate = self;
        headerView.model = self.datasArray[indexPath.section];
        return headerView;
    }
    return nil;
}

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout referenceSizeForHeaderInSection:(NSInteger)section
{
    return CGSizeMake(0, 65);
}

- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView
{
    return self.datasArray.count;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    CardAmplificationViewController *settlement = [[CardAmplificationViewController alloc]init];
    settlement.preferredContentSize = CGSizeMake(500, 370);
    settlement.modalPresentationStyle = UIModalPresentationFormSheet;
    UIPopoverPresentationController *pop = settlement.popoverPresentationController;
    pop.sourceView = settlement.view;
    [self presentViewController:settlement animated:YES completion:nil];
}


#pragma mark - <UploadReceiptsDelegate>
- (void)startUploadReceipts:(NSInteger)sectionIndex
{
    self.orderNumber = [self.datasArray[sectionIndex] orderNumber];
    UIAlertController *alertView = [UIAlertController alertControllerWithTitle:nil message:nil preferredStyle:UIAlertControllerStyleAlert];
    UIImagePickerController *PcCamera = [[UIImagePickerController alloc]init];
    PcCamera.delegate = self;
    [DeviceDirectionManager instance].isHorizontal=YES;
    [alertView addAction:[UIAlertAction actionWithTitle:@"拍照" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        //拍照
        if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]) {
            [PcCamera setSourceType:UIImagePickerControllerSourceTypeCamera];
            PcCamera.allowsEditing = YES;
            [self presentViewController:PcCamera animated:YES completion:nil];
        }
        else
        {
            [DeviceDirectionManager instance].isHorizontal=NO;
            [self ErrorMBProgressView:@"相机无法使用"];
        }
    }]];
    [alertView addAction:[UIAlertAction actionWithTitle:@"从相册选择" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        //从相册中选择
        if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypePhotoLibrary]) {
            [PcCamera setSourceType:UIImagePickerControllerSourceTypePhotoLibrary];
            PcCamera.allowsEditing = YES;
            [self presentViewController:PcCamera animated:YES completion:nil];
        }
        else
        {
            [DeviceDirectionManager instance].isHorizontal=NO;
            [self ErrorMBProgressView:@"相册无法打开"];
        }
    }]];
    [alertView addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        [DeviceDirectionManager instance].isHorizontal=NO;
        [alertView dismissViewControllerAnimated:YES completion:nil];
    }]];
    [self presentViewController:alertView animated:YES completion:nil];
}

#pragma mark -拍照、从相册选择
#pragma -mark -UIImagePickerControllerDelegate
- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary<NSString *,id> *)info
{
    [DeviceDirectionManager instance].isHorizontal=NO;
    [self dismissViewControllerAnimated:YES completion:nil];
    UIImage *Headimage = [info objectForKey:UIImagePickerControllerOriginalImage];
    [self uploadReceipts:Headimage];
}

#pragma mark -上传小票
- (void)uploadReceipts:(UIImage *)image
{
    WS(weakSelf);
    NSData *data = UIImageJPEGRepresentation(image, 0.5);
    [[NetworkRequestClassManager Manager] UploadImageWithURL:SERVERREQUESTURL(UPLOADHEADER) WithRequestType:1 WithImageDatas:data WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            [weakSelf activationJDECard:returnValue[@"data"]];
        }else
        {
            [self ErrorMBProgressView:returnValue[@"message"]];
        }
    } WithprogressBlock:^(double progress) {
        [weakSelf ShowProgressView:progress];
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}

#pragma mark - 激活京东E卡
- (void)activationJDECard:(NSString *)imagePath
{
    WS(weakSelf);
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:SERVERREQUESTURL(ACTIVIATIONJDECARD),self.orderNumber,imagePath] WithRequestType:Zero WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            [weakSelf SuccessMBProgressView:@"激活成功"];
            [[NSNotificationCenter defaultCenter] postNotificationName:UPLOAD_COMPLETE object:nil];
        }else{
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}

#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return kNoDataImage;
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    return [[NSAttributedString alloc]initWithString:@"暂无数据" attributes:nil];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}



@end
