//
//  CardViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/10/20.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CardViewController.h"
#import "CardCollectionViewCell.h"

@interface CardViewController ()<UICollectionViewDelegate,UICollectionViewDataSource>

//** 查询最近10张卡劵 */
@property (nonatomic,strong) RsJingDongECardRequest *requestModel;

//** 数据源 */
@property (nonatomic,strong) NSMutableArray *datasArray;

@end

@implementation CardViewController

#pragma mark - lazy
- (RsJingDongECardRequest *)requestModel
{
    if (!_requestModel) {
        _requestModel = [[RsJingDongECardRequest alloc]init];
        DataPage *page = [[DataPage alloc]init];
        page.page = 0;
        page.rows = 10;
        page.order = @"desc";
        _requestModel.guideIdEquals = [Shoppersmanager manager].Shoppers.employee.fid;
        _requestModel.stateEquals = @"dispensed";
        _requestModel.page = page;
    }
    return _requestModel;
}

- (NSMutableArray *)datasArray
{
    if (!_datasArray) {
        _datasArray = [NSMutableArray array];
    }
    return _datasArray;
}

- (void)viewDidAppear:(BOOL)animated
{
    [self getCardDatasAction];
}

- (void)viewDidLoad {
    [super viewDidLoad];
}

#pragma mark - 查询卡劵
- (void)getCardDatasAction
{
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(CARDINFORMATION) WithRequestType:Zero WithParameter:self.requestModel WithReturnValueBlock:^(id returnValue) {
        
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            [weakSelf.datasArray removeAllObjects];
            for (NSDictionary *dict in returnValue[@"data"][@"list"]) {
                RsJingDongECardResponse *cardInformation = [[RsJingDongECardResponse alloc]initWithDictionary:dict error:nil];
                [weakSelf.datasArray addObject:cardInformation];
            }
            [weakSelf.cardCollectionView reloadData];
        }else{
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}

#pragma mark <UICollectionViewDataSource>
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.datasArray.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    
    CardCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"CardCollectionViewCell" forIndexPath:indexPath];
    return cell;
}


@end
