//
//  OrderdetailsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "OrderdetailsViewController.h"
#import "OrderInformationTableViewCell.h"
#import "PersonInformationTableViewCell.h"
#import "GoodsInformationTableViewCell.h"
#import "CommodityListTableViewCell.h"
#import "AllpriceTableViewCell.h"
#import "SettlementViewController.h"
#import "AdditionalTableViewCell.h"
#import <QuickLook/QuickLook.h>
#import "PDFViewController.h"
#import "ShareGoodsViewController.h"
#import "OrderDetailsSectionHeaderView.h"
#import "PromotionalDeductionModel.h"
#import "PromotionalGoodsModel.h"
#import "PromotionalTableViewCell.h"



NSString *const PROMOTIONALSTRING = @"促销信息";

//** 微信卡劵 */
NSString *const WXCardAction = @"WXCardAction";

//** 京东E卡 */
NSString *const JDECardAction = @"JDECardAction";

//** 折扣金额 */
NSString *const deductionAction = @"deductionAction";

//** 赠送金额 */
NSString *const goodsAction = @"goodsAction";

@interface OrderdetailsViewController ()<UITableViewDelegate,UITableViewDataSource,QLPreviewControllerDataSource>


/**
 *  订单详情数据
 */
@property (nonatomic,strong) OrderBill *orderDetails;

/**
 *  本地存储地址
 */
@property (nonatomic,copy) NSString *PDFpath;

/**
 *  促销信息
 */
@property (nonatomic,strong) NSMutableArray *promotionalArray;



@end

@implementation OrderdetailsViewController

#pragma mark - lazy
- (NSMutableArray *)promotionalArray
{
    if (!_promotionalArray) {
        _promotionalArray = [NSMutableArray array];
    }
    return _promotionalArray;
}

- (NSMutableArray *)sectionTitle
{
    if (!_sectionTitle) {
        _sectionTitle = [NSMutableArray arrayWithObjects:@"订单信息",@"客户信息",@"收货信息",@"商品信息",@"附件信息", nil];
    }
    return _sectionTitle;
}

#pragma mark -渲染完成
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    if (self.isSliding) {
        self.navigationController.fd_fullscreenPopGestureRecognizer.enabled = NO;
        if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
            self.navigationController.interactivePopGestureRecognizer.enabled = NO;
        }
    }
}

#pragma mark -视图即将消失
- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    // 开启
    self.navigationController.fd_fullscreenPopGestureRecognizer.enabled = YES;
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = YES;
    }
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
    [self getOrderDetailsData];
}

#pragma mark - UI
- (void)uiConfigAction
{
    self.orderDetailsTableview.dataSource = self;
    self.orderDetailsTableview.delegate = self;
    if (self.isShowPrintButton) {
       [self CreateTableviewHeaderView];
    }
    //附加信息cell
    [self.orderDetailsTableview registerNib:[UINib nibWithNibName:@"AdditionalTableViewCell" bundle:nil] forCellReuseIdentifier:@"fifthcell"];
    if (self.isShowPayButton) {
       [self CreateTableviewFooterView];
    }
}

#pragma mark -获取订单详情、查询促销信息
- (void)getOrderDetailsData
{
    dispatch_group_t group = dispatch_group_create();
    dispatch_group_enter(group);
    [self CreateMBProgressHUDLoding];
    WS(weakSelf);
    //** 订单详情 */
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:@"%@%@",SERVERREQUESTURL(ORDERDETAILS),self.orderCode] WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
         dispatch_group_leave(group);
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            weakSelf.orderDetails = [[OrderBill alloc]initWithDictionary:returnValue[@"data"] error:nil];
        }else{
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
    } WithErrorCodeBlock:^(id errorCodeValue) {
        dispatch_group_leave(group);
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        dispatch_group_leave(group);
        [weakSelf RemoveMBProgressHUDLoding];
    }];
    //** 查询促销信息 */
    dispatch_group_enter(group);
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:SERVERREQUESTURL(PROMOTIONAL),self.orderCode]  WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        dispatch_group_leave(group);
        [weakSelf RemoveMBProgressHUDLoding];
        NSArray *promotionalArray = returnValue[@"data"];
        if (promotionalArray.count && ![weakSelf.sectionTitle containsObject:PROMOTIONALSTRING]) {
            [weakSelf.sectionTitle addObject:PROMOTIONALSTRING];
        }
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            [weakSelf.promotionalArray removeAllObjects];
            for (NSDictionary *dict in promotionalArray) {
                //** 抵扣金额、京东E卡、微信卡劵 */
                if ([dict[@"type"] isEqualToString:deductionAction] || [dict[@"type"] isEqualToString:JDECardAction] || [dict[@"type"] isEqualToString:WXCardAction]) {
                    PromotionalDeductionModel *deductionModel = [[PromotionalDeductionModel alloc]initWithDictionary:dict error:nil];
                    deductionModel.isSelected = YES;
                    [weakSelf.promotionalArray addObject:deductionModel];
                }else if ([dict[@"type"] isEqualToString:goodsAction]){
                    PromotionalGoodsModel *goodsModel = [[PromotionalGoodsModel alloc]initWithDictionary:dict error:nil];
                    goodsModel.isSelected = YES;
                    [weakSelf.promotionalArray addObject:goodsModel];
                }
            }
        }else{
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        dispatch_group_leave(group);
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        dispatch_group_leave(group);
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
    //** 完成后回调 */
    dispatch_group_notify(group, dispatch_get_main_queue(), ^{
       
        [weakSelf.orderDetailsTableview reloadData];
        //默认弹出支付框
        if (weakSelf.isShowPayButton && [weakSelf.orderDetails.order.orderState isEqualToString:@"001"]) {
            [weakSelf PayButtonClick];
        }
    });
}

#pragma mark - 发放京东E卡
- (void)issueJDECard:(NSInteger)denomation andGuideId:(NSString *)guideId andOrderNumber:(NSString *)orderNumber
{
    WS(weakSelf);
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:SERVERREQUESTURL(JDECARD),denomation,guideId,orderNumber] WithRequestType:0 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            NSLog(@"领取成功");
        }else{
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}

#pragma mark -TableviewHeader------根据不同的订单状态判断是否显示
- (void)CreateTableviewHeaderView
{
    UIView *headerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 60)];
    //预览
    UIButton *previewButton = [UIButton buttonWithType:UIButtonTypeSystem];
    previewButton.frame = CGRectMake(50, 15, 150, 30);
    [previewButton setTitle:self.isDelectedButton?@"撤销订单":@"预览" forState:UIControlStateNormal];
    previewButton.titleLabel.font = [UIFont systemFontOfSize:12];
    [previewButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [previewButton addTarget:self action:@selector(PreviewButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    previewButton.backgroundColor = kMainBlueColor;
    previewButton.layer.masksToBounds = YES;
    previewButton.layer.cornerRadius = kCornerRadius;
    [headerView addSubview:previewButton];
    
    //显示撤销按钮的情况下，不显示打印按钮
    if (!self.isDelectedButton) {
     
        //打印
        UIButton *printButton = [UIButton buttonWithType:UIButtonTypeSystem];
        printButton.frame = CGRectMake(ScreenWidth-50-150, 15, 150, 30);
        [printButton setTitle:@"打印" forState:UIControlStateNormal];
        [printButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        printButton.titleLabel.font = [UIFont systemFontOfSize:12];
        [printButton addTarget:self action:@selector(AirprintButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        printButton.layer.masksToBounds = YES;
        printButton.layer.cornerRadius = kCornerRadius;
        printButton.backgroundColor = kMainBlueColor;
        [headerView addSubview:printButton];
        
        //分享
        UIButton *shareButton = [UIButton buttonWithType:UIButtonTypeSystem];
        shareButton.frame = CGRectMake(ScreenWidth-50-350, 15, 150, 30);
        [shareButton setTitle:@"分享" forState:UIControlStateNormal];
        [shareButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        shareButton.titleLabel.font = [UIFont systemFontOfSize:12];
        [shareButton addTarget:self action:@selector(ShareButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        shareButton.layer.masksToBounds = YES;
        shareButton.layer.cornerRadius = kCornerRadius;
        shareButton.backgroundColor = kMainBlueColor;
        [headerView addSubview:shareButton];
    }
    //横线
    UIView *lineView = [[UIView alloc]initWithFrame:CGRectMake(0, 59, ScreenWidth, 1)];
    lineView.backgroundColor = kTCColor(193, 193, 193);
    [headerView addSubview:lineView];
    self.orderDetailsTableview.tableHeaderView = headerView;
}

#pragma mark -TableviewFooterView------根据不同的订单状态判断支付按钮是否显示
- (void)CreateTableviewFooterView
{
    UIView *footerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 100)];
    
    //支付
    UIButton *payButton = [UIButton buttonWithType:UIButtonTypeSystem];
    payButton.frame = CGRectMake((ScreenWidth-150)/2, 30, 150, 40);
    [payButton setTitle:@"支付" forState:UIControlStateNormal];
    payButton.titleLabel.font = [UIFont systemFontOfSize:12];
    [payButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [payButton addTarget:self action:@selector(PayButtonClick) forControlEvents:UIControlEventTouchUpInside];
    payButton.backgroundColor = kMainBlueColor;
    payButton.layer.masksToBounds = YES;
    payButton.layer.cornerRadius = kCornerRadius;
    [footerView addSubview:payButton];
    self.orderDetailsTableview.tableFooterView = footerView;
}


#pragma mark -调出支付框
- (void)PayButtonClick
{
    SettlementViewController *settlement = [[SettlementViewController alloc]init];
    //支付成功
    WS(weakSelf);
    [settlement setPaySuccessReturnBlock:^{
        
        weakSelf.isDelectedButton = NO;
        weakSelf.isShowattachment = YES;
        weakSelf.isUserInteractionEnabled = NO;
        [weakSelf CreateTableviewHeaderView];
        [weakSelf getOrderDetailsData];
        weakSelf.orderDetailsTableview.tableFooterView = nil;
        if (weakSelf.DelecteAndPayButtonBlock) {
            weakSelf.DelecteAndPayButtonBlock(_cellindex,@"002");
        }
        //** 京东E卡 */
        for (id object in self.promotionalArray) {
            if ([object isKindOfClass:[PromotionalDeductionModel class]]) {
                PromotionalDeductionModel *model = (PromotionalDeductionModel *)object;
                if ([model.type isEqualToString:JDECardAction]) {
                    [self issueJDECard:model.total andGuideId:[Shoppersmanager manager].Shoppers.employee.fid andOrderNumber:self.orderCode];break;
                }
            }
        }
    }];
    settlement.preferredContentSize = CGSizeMake(380, 500);
    settlement.goodsArray = self.orderDetails.orderdetailList;
    settlement.promotionalArray = self.promotionalArray;
    settlement.orderCode = _orderCode;
    settlement.modalPresentationStyle = UIModalPresentationFormSheet;
    UIPopoverPresentationController *pop = settlement.popoverPresentationController;
    pop.sourceView = settlement.view;
    [self presentViewController:settlement animated:YES completion:nil];
}


#pragma mark - Table view data source
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    
    switch (section) {
        case 0:
        case 1:
        case 2:
        case 4:
            return 1;
            break;
        case 3:
        {
            return self.orderDetails.orderdetailList.count+1;
        }
            break;
        case 5:
        {
            return self.promotionalArray.count;
        }
            break;
        default:
            break;
    }
    return 0;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    switch (indexPath.section) {
        case 0://订单信息
        {
            OrderInformationTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"firstcell" forIndexPath:indexPath];
            cell.model = self.orderDetails;
            return cell;
        }
            break;
        case 1://客户信息
        {
            PersonInformationTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"secondcell" forIndexPath:indexPath];
            cell.model = self.orderDetails.consumer;
            return cell;
        }
            break;
        case 2://收货信息
        {
            GoodsInformationTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"thirdcell" forIndexPath:indexPath];
            cell.model = self.orderDetails.order;
            return cell;
        }
            break;
        case 3://商品清单
        {
            if (indexPath.row == self.orderDetails.orderdetailList.count) {
                
                //商品总计
                AllpriceTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"sixthcell" forIndexPath:indexPath];
                cell.goodsArray = self.orderDetails.orderdetailList;
                cell.selectionStyle = UITableViewCellSelectionStyleNone;
                return cell;
                
            }else
            {
                //单个商品
                CommodityListTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"fourthcell" forIndexPath:indexPath];
                cell.orderDetailslist = [self.orderDetails.orderdetailList objectAtIndex_opple:indexPath.row];
                return cell;
            }
        }
            break;
        case 4://附件信息
        {
            //是否显示
            if (_isShowattachment) {
             
                AdditionalTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"fifthcell" forIndexPath:indexPath];
                cell.model = self.orderDetails.order;
                return cell;
            }
        }
            break;
        case 5://促销信息
        {
            PromotionalTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"PromotionalTableViewCell" forIndexPath:indexPath];
            NSString *describe = nil;
            id object = self.promotionalArray[indexPath.row];
            if ([object isKindOfClass:[PromotionalGoodsModel class]]) {
                PromotionalGoodsModel *goodsModel = object;
                cell.accessoryType = goodsModel.isSelected?UITableViewCellAccessoryCheckmark:UITableViewCellAccessoryNone;
                describe = [NSString stringWithFormat:@"赠送商品:%@%ld",goodsModel.goods.name,goodsModel.count];
            }else if ([object isKindOfClass:[PromotionalDeductionModel class]]){
                PromotionalDeductionModel *deductionModel = self.promotionalArray[indexPath.row];
                cell.accessoryType = deductionModel.isSelected?UITableViewCellAccessoryCheckmark:UITableViewCellAccessoryNone;
                describe = [NSString stringWithFormat:@"折扣金额:%ld",deductionModel.total];
            }
            cell.promotionalTitleLabel.text = describe;
            cell.userInteractionEnabled = self.isUserInteractionEnabled;
            return cell;
        }
            break;
            
        default:
            break;
    }
    return [UITableViewCell new];
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section) {
        case 0:
        {
            return 84;
        }
            break;
        case 1:
        {
            return 110;
        }
            break;
        case 2:
        {
            return 90;
        }
            break;
        case 3:
        {
            //商品总计
            if (indexPath.row == self.orderDetails.orderdetailList.count) {
                
                return 50;
            }
            else
            {
            //单个商品
               return 80;
            }
        }
            break;
        case 4:
        {
            //是否显示附件信息
            if (!_isShowattachment) {
                
                return 0;
            }
            return 75;
        }
            break;
        case 5:
        {
            return 44;
        }
            break;
            
        default:
            break;
    }
    return 100;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    OrderDetailsSectionHeaderView *headerView = [tableView dequeueReusableCellWithIdentifier:@"OrderDetailsSectionHeaderView"];
    headerView.sectionHeaderTitleLabel.text = [self.sectionTitle objectAtIndex_opple:section];
    return headerView;
}


- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 60;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 5) {
        PromotionalTableViewCell *promotionalCell = [tableView cellForRowAtIndexPath:indexPath];
        id object = self.promotionalArray[indexPath.row];
        if ([object isKindOfClass:[PromotionalGoodsModel class]]) {
            PromotionalGoodsModel *goodsModel = object;
            goodsModel.isSelected = !goodsModel.isSelected;
            promotionalCell.accessoryType = goodsModel.isSelected?UITableViewCellAccessoryCheckmark:UITableViewCellAccessoryNone;
        }else if ([object isKindOfClass:[PromotionalDeductionModel class]]){
            PromotionalDeductionModel *deductionModel = object;
            deductionModel.isSelected = !deductionModel.isSelected;
            promotionalCell.accessoryType = deductionModel.isSelected?UITableViewCellAccessoryCheckmark:UITableViewCellAccessoryNone;
        }
    }
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return self.sectionTitle.count;
}


#pragma mark -打印订单
- (void)AirprintButtonClick:(UIButton *)button
{
    WS(weakSelf);
    [self DownloadPDF:^(id Value) {
        [weakSelf CreateMBProgressHUDLoding];
        [[NetworkRequestClassManager Manager] DownloadPDFdatasWithURL:Value WithReturnValueBlock:^(id returnValue) {
            
            [weakSelf RemoveMBProgressHUDLoding];
            [weakSelf callAirprintWithdata:returnValue SuccessBlock:^{
                [weakSelf SuccessMBProgressView:@"打印完成"];
            } ErrorBlock:^{
                [weakSelf ErrorMBProgressView:@"打印失败"];
            }];
            
        } WithErrorCodeBlock:^(id errorCodeValue) {
            
        } WithFailureBlock:^(id error) {
            [weakSelf RemoveMBProgressHUDLoding];
        }];
    }];
}


#pragma mark -下载PDF
- (void)DownloadPDF:(void(^)(id returnValue))success
{
    WS(weakSelf);
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:@"%@%@",SERVERREQUESTURL(DOWNLOADPDF),_orderCode] WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [weakSelf RemoveMBProgressHUDLoding];
        NSString *url = [NSString stringWithFormat:@"%@",returnValue[@"data"]];
        success(url);

    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf ErrorMBProgressView:@"网络中断"];
    } WithFailureBlock:^(id error) {
        [weakSelf RemoveMBProgressHUDLoding];
    }];
}


#pragma mark -预览订单、撤销订单
- (void)PreviewButtonClick:(UIButton *)button
{
    WS(weakSelf);
    if ([button.currentTitle isEqualToString:@"预览"]) {
        [self DownloadPDF:^(id returnValue) {
            
//            self.PDFpath = returnValue;
//            QLPreviewController *previewController = [[QLPreviewController alloc] init];
//            previewController.dataSource = weakSelf;
//            previewController.navigationController.navigationBarHidden = YES;
//            [weakSelf presentViewController:previewController animated:YES completion:nil];
            
            PDFViewController *pdfvc = [[PDFViewController alloc]init];
            pdfvc.pdfURLString = returnValue;
            [weakSelf presentViewController:pdfvc animated:YES completion:nil];
        }];
        
    }else if ([button.currentTitle isEqualToString:@"撤销订单"])
    {
        UIAlertController *alertVC = [UIAlertController alertControllerWithTitle:@"提示" message:@"请确认是否撤销订单" preferredStyle:UIAlertControllerStyleAlert];
        [alertVC addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        }]];
        [alertVC addAction:[UIAlertAction actionWithTitle:@"确认" style:UIAlertActionStyleDestructive handler:^(UIAlertAction * _Nonnull action)
        {
            [weakSelf CreateMBProgressHUDLoding];
            [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:@"%@%@/%@/%@",SERVERREQUESTURL(RESETORDER),_orderCode,@"001",@"005"] WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
                [weakSelf RemoveMBProgressHUDLoding];
                if ([returnValue[@"code"] isEqualToNumber:@0]) {
                    [weakSelf SuccessMBProgressView:@"撤销成功"];
                    UIView *view = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 0.01)];
                    [weakSelf.orderDetailsTableview beginUpdates];
                    weakSelf.orderDetailsTableview.tableHeaderView = view;
                    weakSelf.orderDetailsTableview.tableFooterView = nil;
                    [weakSelf.orderDetailsTableview endUpdates];
                    weakSelf.orderDetails.order.orderState = @"005";
                    weakSelf.isUserInteractionEnabled = NO;
                    [weakSelf.orderDetailsTableview reloadData];
                    if (weakSelf.DelecteAndPayButtonBlock) {
                        weakSelf.DelecteAndPayButtonBlock(_cellindex,@"005");
                    }
                }
                else
                {
                    [weakSelf ErrorMBProgressView:returnValue[@"message"]];
                }
                
            } WithErrorCodeBlock:^(id errorCodeValue) {
                
            } WithFailureBlock:^(id error) {
                
                [weakSelf RemoveMBProgressHUDLoding];
            }];
        }]];
        [self presentViewController:alertVC animated:YES completion:nil];
    }
}

- (NSInteger)numberOfPreviewItemsInPreviewController:(QLPreviewController *)controller
{
    return 1;
}

- (id)previewController:(QLPreviewController *)controller previewItemAtIndex:(NSInteger)index
{
    return self.PDFpath;
}

- (BOOL)prefersStatusBarHidden
{
    return YES;
}

#pragma mark - 分享订单
- (void)ShareButtonClick:(UIButton *)sender
{
    ShareGoodsViewController *shareController = [[ShareGoodsViewController alloc]init];
    shareController.isShareOrderbill = YES;
    shareController.orderBillNumber = self.orderCode;
    shareController.shareImage = [UIImage imageNamed:@"Icon-83.5"];
    shareController.preferredContentSize = CGSizeMake(290, 120);
    shareController.modalPresentationStyle = UIModalPresentationPopover;
    UIPopoverPresentationController *popover = shareController.popoverPresentationController;
    popover.permittedArrowDirections = UIPopoverArrowDirectionUp;
    popover.barButtonItem = [[UIBarButtonItem alloc]initWithCustomView:sender];
    [self presentViewController:shareController animated:YES completion:nil];
}



@end
