//
//  Toolview.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "Toolview.h"
#import "CustomButton.h"
#import "UserViewController.h"

#define ButtonWIDTH 80 //按钮宽度
#define Buttoninterval 20//按钮间隔
#define ButtonRIGHT 54//按钮高度


@implementation Toolview


- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
      
        self.backgroundColor = kTCColor(255, 255, 255);
        [self uiConfigAction];
    }
    return self;
}



#pragma mark -布局
- (void)uiConfigAction
{
    //阴影
    self.layer.shadowColor = [UIColor blackColor].CGColor;
    self.layer.shadowRadius = 10;
    self.layer.shadowOpacity = 0.5;

    //图标
    UIImageView *iconImage = [[UIImageView alloc]initWithFrame:CGRectMake(50, 13, 115, 35)];
    iconImage.image = TCImage(@"欧");
    [self addSubview:iconImage];
    
    //输入框背景
    UIView *backView = [[UIView alloc]initWithFrame:CGRectMake(200, (NavigationHeight-35)/2, 220, 35)];
    backView.backgroundColor = kTCColor(242, 242, 242);
    backView.layer.masksToBounds = YES;;
    backView.layer.cornerRadius = kCornerRadius;
    backView.layer.borderWidth = 1;
    backView.layer.borderColor = kTCColor(209, 209, 209).CGColor;
    [self addSubview:backView];

    //搜索图标
    UIImageView *imageview = [[UIImageView alloc]initWithFrame:CGRectMake(10, 7.5, 20, 20)];
    imageview.image = TCImage(@"search");
    [backView addSubview:imageview];
    
    
    //输入框
    self.inputField = [[UITextField alloc]initWithFrame:CGRectMake(45, 0, 170, 35)];
    self.inputField.borderStyle = UITextBorderStyleNone;
    self.inputField.placeholder = @"请输入关键字";
    self.inputField.font = [UIFont systemFontOfSize:12];
    self.inputField.returnKeyType = UIReturnKeySearch;
    [backView addSubview:self.inputField];
    
    //扫描二维码
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.frame = CGRectMake(backView.frame.size.width+backView.frame.origin.x+15, (NavigationHeight-20)/2, 25, 20);
    [button setBackgroundImage:TCImage(@"圆角矩形-3") forState:UIControlStateNormal];
    [button addTarget:self action:@selector(QrCodeButtonClickAction) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:button];
    
    //按钮
    NSString *realName = [[Shoppersmanager manager].Shoppers.employee.realName length]?[Shoppersmanager manager].Shoppers.employee.realName:@"服务导购";
    NSArray *titleArray = [NSArray arrayWithObjects:@"功能菜单",realName,@"我的客户",@"购物袋", nil];
    //图片
    NSArray *imageArray = [NSArray arrayWithObjects:@"dial",@"矢量智能对象-1",@"data",@"ablum", nil];
    for (int i=1; i<5; i++) {
        
        CustomButton *button = [CustomButton buttonWithType:UIButtonTypeCustom];
        button.frame = CGRectMake(ScreenWidth-(i*ButtonWIDTH + Buttoninterval*(i-1)), 10, ButtonWIDTH, ButtonRIGHT);
        [button setTitleColor:kMainBlueColor forState:UIControlStateNormal];
        [button setTitle:[titleArray objectAtIndex_opple:i-1] forState:UIControlStateNormal];
        button.tag = 100+i-1;
        [button addTarget:self action:@selector(ButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        [button setImage:TCImage([imageArray objectAtIndex_opple:i-1]) forState:UIControlStateNormal];
        [self addSubview:button];
        if (i == 4) {
            
            SHARED_APPDELEGATE.shoppingCarPoint = [self convertPoint:CGPointMake(button.center.x, button.center.y) toView:self.window];
        }
    }
    //创建下划线
    CustomButton *Newbutton = (CustomButton *)[self viewWithTag:102];
    self.underlineView = [[UIView alloc]initWithFrame:CGRectMake(Newbutton.frame.origin.x+(ButtonWIDTH-50)/2, ButtonRIGHT+8, 50, 2)];
    SHARED_APPDELEGATE.lineView = self.underlineView;
    _underlineView.backgroundColor = kMainBlueColor;
    [self addSubview:self.underlineView];
    //刷新购物车数量 、直接赋值
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(refreshGoodsNumber:) name:REFRESHSHOPPINGCAR object:nil];
    
    //刷新购物车数量
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(AddGoodsNumber:) name:@"ADDGOODSNUMBER" object:nil];
    
    //更改用户名
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(ChangeCustomerName:) name:@"CHANGECUSTOMERNAME" object:nil];
    
    //更改导购名
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(ChangeShoppersName:) name:@"CHANGESHOPPERSNAME" object:nil];
}


#pragma mark -刷新购物车显示数量
- (void)refreshGoodsNumber:(NSNotification *)objc
{
    CustomButton *button = (CustomButton *)[self viewWithTag:103];
    button.instructionsNumber = [objc.object integerValue];
}
#pragma mark -增加购物车数量
- (void)AddGoodsNumber:(NSNotification *)objc
{
    CustomButton *button = (CustomButton *)[self viewWithTag:103];
    button.instructionsNumber += [objc.object integerValue];
}

#pragma mark -更改当前用户名
- (void)ChangeCustomerName:(NSNotification *)Not
{
    UIButton *button = [self viewWithTag:102];
    NSString *userName = Not.object;
    if (userName.length == 0 || !userName) {
        userName = @"我的客户";
    }
    [button setTitle:userName forState:UIControlStateNormal];
}

#pragma mark -更改导购名字
- (void)ChangeShoppersName:(NSNotification *)not
{
    UIButton *button = [self viewWithTag:101];
    NSString *userName = not.object;
    if (userName.length == 0 || !userName) {
        userName = @"导购";
    }
    [button setTitle:userName forState:UIControlStateNormal];
}


#pragma mark -二维码扫描码
- (void)QrCodeButtonClickAction
{
    if ([self.delegate respondsToSelector:@selector(QrcodeButtonClick)]) {
        
        [self.delegate QrcodeButtonClick];
    }
}

#pragma mark -按钮事件响应
- (void)ButtonClick:(UIButton *)button
{
    if (button.tag == 102 || button.tag == 103) {
       
        if (!(button.tag == 103 && ![Shoppersmanager manager].currentCustomer)) {
          
            self.underlineView.hidden = NO;
            //下划线动画
            [UIView animateWithDuration:0.2 delay:0 options:UIViewAnimationOptionCurveEaseOut animations:^{
                
                CGRect frame = self.underlineView.frame;
                frame.origin.x = button.frame.origin.x+(ButtonWIDTH-50)/2;
                self.underlineView.frame = frame;
            } completion:nil];
            
        }
    }
    //点击代理
    if ([self.delegate respondsToSelector:@selector(ButtonClickAction:withButton:)]) {
        
        [self.delegate ButtonClickAction:button.tag withButton:button];
    }
}










@end
