//
//  OrderTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "OrderTableViewCell.h"

@implementation OrderTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}


#pragma mark -UI
- (void)setModel:(OrderBill *)model
{
    _model = model;
    self.orderTime.text = _model.order.orderTime;
    self.orderState.text = _model.order.orderState;
    self.customerName.text = _model.consumer.name;
   //总数量
    NSInteger Number = 0;
    for (TOOrderdetailEntity *objc in _model.orderdetailList) {
        
        Number += [objc.goodsNum integerValue];
    }
    self.goodsNumber.text = [NSString stringWithFormat:@"%ld",Number];
    self.consigneeName.text = _model.order.receiverName;
    self.consigneePhoneNumber.text = _model.order.receiverMobile;
    self.orderSerialNumber.text =  _model.order.orderNumber;
    self.shopperName.text = _model.employee.realName;
    self.phoneNumber.text = _model.consumer.mobile;
    //总价格
    CGFloat allprice = 0;
    for (TOOrderdetailEntity *objc in _model.orderdetailList) {
        
        allprice += [objc.goodsPrice floatValue]*[objc.goodsNum integerValue];
    }
    self.orderAllprice.text = [NSString stringWithFormat:@"￥%.2f",allprice];
    self.customerAddress.text = _model.order.receiverAddress;
    
    //订单状态图片
    self.orderStateShowImageView.image = [BaseViewController ReturnOrderStateImageWithStateCode:[_model.order.orderState integerValue]];
    
    //订单状态文本
    self.orderState.text = [BaseViewController ReturnOrderStateTitleWithStateCode:[_model.order.orderState integerValue] withPoint:CGPointMake(self.orderState.frame.origin.x, self.orderState.frame.origin.y) WithCode:0];
      self.orderState.textColor = [BaseViewController ReturnOrderStateTitleWithStateCode:[_model.order.orderState integerValue] withPoint:CGPointMake(self.orderState.frame.origin.x, self.orderState.frame.origin.y) WithCode:1];
    
}





#pragma mark -时间转换NSDate转NSString
- (NSString*)dateAsString:(NSDate*)date {
    
    NSDateFormatter *formatter=[[NSDateFormatter alloc] init];
    [formatter setDateFormat:@"yyyy-MM-dd"];
    NSString * timeString = [formatter stringFromDate:date];
    return timeString;
    
}





- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
