
#import <Foundation/Foundation.h>
#import "JSONModel.h"


/**
 *  @Description: TODO(排序定义)
 *  asc 升序
 *  @author  张代浩
 *  desc 降序
 */
/**
 *
 */
extern NSString * const SORTDIRECTION_ASC;
/**
 *
 */
extern NSString * const SORTDIRECTION_DESC;




@class RsApplyBillRequest;
@class RsCommissionRequest;
@class DataPage;
@class PageRows;
@class RsResponse;
@class LoginInfo;
@class ModifyPasswordRequest;
@class RsEmployeeRequest;
@class GoodsCategory;
@class GoodsFilter;
@class HotFilter;
@class OrderFilter;
@class OrderPayRequest;
@class SceneFilter;
@class RsShippingAddrEntity;
@class SaveShoppingCartRequest;
@class ShopCartFilter;
@class TOApplyBillEntity;
@class TOConsumerEntity;
@class TOGoodsForResellerEntity;
@class TOGoodsBrandEntity;
@class TOGoodsLabelEntity;
@class TOOrderEntity;
@class TOPositionEntity;
@class TOShippingAddrEntity;
@class TOShopcartEntity;
@class IdEntity;
@class TOSceneEntity;
@class TOOrderdetailEntity;
@class TOGoodsLabelCategoryEntity;
@class TOGoodsCategoryEntity;
@class VOResellerGoodsEntity;
@class TOGoodsEntity;
@class TOCommissionHistEntity;
@class RsShareResponse;
@class DeleteCartRequest;
@class SceneCondition;
@class OrderBill;
@class GoodsCondition;
@class DataDict;
@class ResetPasswordRequest;
@class LoginResult;
@class ConsumerQueryCondition;
@class ExceptionCode;
@class EarningsResponse;
@class ApplyRequest;
@class OrderResponse;
@class TSDepart;
@class TSBaseUser;
@class TSUserOrg;
@class ShopCartResponse;
@class SceneResponse;
@class GoodsResponse;
@class ConsumerPageResult;
@class RsCommissionResponse;
@class RsApplyBillResponse;
@class TSUser;
@class TOEmployee;

@protocol RsApplyBillRequest @end
@protocol RsCommissionRequest @end
@protocol DataPage @end
@protocol PageRows @end
@protocol RsResponse @end
@protocol LoginInfo @end
@protocol ModifyPasswordRequest @end
@protocol RsEmployeeRequest @end
@protocol GoodsCategory @end
@protocol GoodsFilter @end
@protocol HotFilter @end
@protocol OrderFilter @end
@protocol OrderPayRequest @end
@protocol SceneFilter @end
@protocol RsShippingAddrEntity @end
@protocol SaveShoppingCartRequest @end
@protocol ShopCartFilter @end
@protocol TOApplyBillEntity @end
@protocol TOConsumerEntity @end
@protocol TOGoodsForResellerEntity @end
@protocol TOGoodsBrandEntity @end
@protocol TOGoodsLabelEntity @end
@protocol TOOrderEntity @end
@protocol TOPositionEntity @end
@protocol TOShippingAddrEntity @end
@protocol TOShopcartEntity @end
@protocol IdEntity @end
@protocol TOSceneEntity @end
@protocol TOOrderdetailEntity @end
@protocol TOGoodsLabelCategoryEntity @end
@protocol TOGoodsCategoryEntity @end
@protocol VOResellerGoodsEntity @end
@protocol TOGoodsEntity @end
@protocol TOCommissionHistEntity @end
@protocol RsShareResponse @end
@protocol DeleteCartRequest @end
@protocol SceneCondition @end
@protocol OrderBill @end
@protocol GoodsCondition @end
@protocol DataDict @end
@protocol ResetPasswordRequest @end
@protocol LoginResult @end
@protocol ConsumerQueryCondition @end
@protocol ExceptionCode @end
@protocol EarningsResponse @end
@protocol ApplyRequest @end
@protocol OrderResponse @end
@protocol TSDepart @end
@protocol TSBaseUser @end
@protocol TSUserOrg @end
@protocol ShopCartResponse @end
@protocol SceneResponse @end
@protocol GoodsResponse @end
@protocol ConsumerPageResult @end
@protocol RsCommissionResponse @end
@protocol RsApplyBillResponse @end
@protocol TSUser @end
@protocol TOEmployee @end


/**
 * (no documentation provided)
 */
@interface RsApplyBillRequest : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *employeeId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface RsApplyBillRequest */



/**
 *  流水请求
 
 @author nevermore
 @since 0.1
 
 */
@interface RsCommissionRequest : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *emploreeId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface RsCommissionRequest */



/**
 *  easyui的datagrid向后台传递参数使用的model
 
 @author
 
 
 */
@interface DataPage : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger total;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger page;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger rows;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *sort;
/**
 * (no documentation provided)
 *
 * 取值: SORTDIRECTION_ASC, SORTDIRECTION_DESC,
 */
@property (nonatomic, copy) NSString *order;
@end /* interface DataPage */



/**
 *  分页类
 
 @author Administrator
 @since 0.1
 
 */
@interface PageRows : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger page;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger rows;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger total;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger totalpages;
@end /* interface PageRows */



/**
 *  Restful Service response base
 
 @author Debenson
 @since 0.1
 
 */
@interface RsResponse : JSONModel
/**
 * 0:正常， 非0异常。
 *
 *
 */
@property (nonatomic, assign) long long code;
/**
 * 异常描述
 *
 *
 */
@property (nonatomic, copy) NSString *message;
/**
 * 返回数据
 *
 *
 */
@property (nonatomic, strong) NSObject *data;
@end /* interface RsResponse */



/**
 *  经销商用户登录信息。
 
 @author Debenson
 @since 0.1
 
 */
@interface LoginInfo : JSONModel
/**
 * 用户名
 *
 *
 */
@property (nonatomic, copy) NSString *username;
/**
 * 密码
 *
 *
 */
@property (nonatomic, copy) NSString *password;
@end /* interface LoginInfo */



/**
 *  修改密码请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface ModifyPasswordRequest : JSONModel
/**
 * 员工标识。
 *
 *
 */
@property (nonatomic, copy) NSString *employeeId;
/**
 * 原密码。
 *
 *
 */
@property (nonatomic, copy) NSString *oldPassword;
/**
 * 新密码
 *
 *
 */
@property (nonatomic, copy) NSString *fnewPassword;
@end /* interface ModifyPasswordRequest */



/**
 *  @author MHk
 @since 0.1
 
 */
@interface RsEmployeeRequest : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOEmployee *employee;
@end /* interface RsEmployeeRequest */



/**
 *  @author Debenson
 @since 0.1
 
 */
@interface GoodsCategory : JSONModel
/**
 * 分类id
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 分类名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 下级分类列表
 * @see GoodsCategory
 *
 */
@property (nonatomic, strong) NSArray<GoodsCategory> *children;
@end /* interface GoodsCategory */



/**
 *  @author Debenson
 @since 0.1
 
 */
@interface GoodsFilter : JSONModel
/**
 * 风格
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *styles;
/**
 * (no documentation provided)
 * @see GoodsCategory
 *
 */
@property (nonatomic, strong) NSArray<GoodsCategory> *categories;
/**
 * 空间
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *space;
/**
 * 材质
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *material;
/**
 * 价格
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *price;
@end /* interface GoodsFilter */



/**
 *  @author Administrator
 @since 0.1
 
 */
@interface HotFilter : JSONModel
/**
 * (no documentation provided)
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *list;
@end /* interface HotFilter */



/**
 *  订单筛选条件。
 
 @author Debenson
 @since 0.1
 
 */
@interface OrderFilter : JSONModel
/**
 * 经销商代码
 *
 *
 */
@property (nonatomic, copy) NSString *resellerCodeEquals;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *orderStateEquals;
/**
 * 消费者名称或手机号等于
 *
 *
 */
@property (nonatomic, copy) NSString *consumerNameOrMobileEquals;
/**
 * 客户标识等于
 *
 *
 */
@property (nonatomic, copy) NSString *consumerIdEquals;
/**
 * 分页数据
 *
 *
 */
@property (nonatomic, strong) DataPage *dp;
@end /* interface OrderFilter */



/**
 *  订单支付
 
 @author wsx
 @since 0.1
 
 */
@interface OrderPayRequest : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *oldstate;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *fnewstate;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *payType;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *isbill;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *billType;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *billTitle;
@end /* interface OrderPayRequest */



/**
 *  @author Administrator
 @since 0.1
 
 */
@interface SceneFilter : JSONModel
/**
 * (no documentation provided)
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *styles;
/**
 * (no documentation provided)
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *space;
@end /* interface SceneFilter */



/**
 *  @author Administrator
 @since 0.1
 
 */
@interface RsShippingAddrEntity : JSONModel
/**
 * (no documentation provided)
 * @see TOShippingAddrEntity
 *
 */
@property (nonatomic, strong) NSArray<TOShippingAddrEntity> *list;
@end /* interface RsShippingAddrEntity */



/**
 *  @author Debenson
 @since 0.1
 
 */
@interface SaveShoppingCartRequest : JSONModel
/**
 * 消费者标识
 *
 *
 */
@property (nonatomic, copy) NSString *consumerId;
/**
 * 商品标识
 *
 *
 */
@property (nonatomic, copy) NSString *goodsId;
/**
 * 商品数量，>0表示添加, <0表示减少
 *
 *
 */
@property (nonatomic, copy) NSString *count;
@end /* interface SaveShoppingCartRequest */



/**
 *  购物车查询条件。
 
 @author Debenson
 @since 0.1
 
 */
@interface ShopCartFilter : JSONModel
/**
 * 消费者标识
 *
 *
 */
@property (nonatomic, copy) NSString *consumerId;
/**
 * 分页数据
 *
 *
 */
@property (nonatomic, strong) DataPage *dp;
@end /* interface ShopCartFilter */



/**
 *
 @Title: Entity
 @Description: 提现申请
 @author onlineGenerator
 @date 2016-08-24 09:40:02
 @version V1.0
 
 
 */
@interface TOApplyBillEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *billNumber;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *guideId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *guideName;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *applyMoney;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *beforeMoney;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *afterMoney;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *billStates;
@end /* interface TOApplyBillEntity */



/**
 *  @Title: Entity
 @Description: 客户
 @author onlineGenerator
 @date 2016-05-08 18:08:58
 @version V1.0
 
 
 */
@interface TOConsumerEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *mobile;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *province;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *city;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *country;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *address;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *picture;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *lastVisitedTime;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *company;
@end /* interface TOConsumerEntity */



/**
 * (no documentation provided)
 */
@interface TOGoodsForResellerEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *resellerId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOGoodsEntity *goods;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *path;
@end /* interface TOGoodsForResellerEntity */



/**
 *  @Title: Entity
 @Description: 商品品牌
 @author onlineGenerator
 @date 2016-05-05 16:14:51
 @version V1.0
 
 
 */
@interface TOGoodsBrandEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *logo;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fdescription;
@end /* interface TOGoodsBrandEntity */



/**
 *  @Title: Entity
 @Description: 商品标签
 @author onlineGenerator
 @date 2016-05-05 17:18:15
 @version V1.0
 
 
 */
@interface TOGoodsLabelEntity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOGoodsLabelCategoryEntity *category;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *categoryId;
@end /* interface TOGoodsLabelEntity */



/**
 *  @Title: Entity
 @Description: 订单
 @author onlineGenerator
 @date 2016-05-06 12:53:09
 @version V1.0
 
 
 */
@interface TOOrderEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *orderTime;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *guideId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderState;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *consumerId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsNum;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *orderPrice;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *receiverName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *receiverMobile;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *receiverAddress;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *isBill;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *billType;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *billTitle;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *payType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *consumerName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *guideName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *resellerName;
@end /* interface TOOrderEntity */



/**
 *  @Title: Entity
 @Description: 经销商员工职位
 @author onlineGenerator
 @date 2016-05-02 17:39:21
 @version V1.0
 
 
 */
@interface TOPositionEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *commission;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSNumber *lowestDiscount;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *resellerCode;
@end /* interface TOPositionEntity */



/**
 *  @Title: Entity
 @Description: t_o_shipping_addr
 @author onlineGenerator
 @date 2016-05-14 16:14:15
 @version V1.0
 
 
 */
@interface TOShippingAddrEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *miblephone;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *province;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *city;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *country;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *address;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *consumerId;
@end /* interface TOShippingAddrEntity */



/**
 *  @Title: Entity
 @Description: t_o_shopcart
 @author onlineGenerator
 @date 2016-05-13 14:26:57
 @version V1.0
 
 
 */
@interface TOShopcartEntity : JSONModel
/**
 * 商品详情
 *
 *
 */
@property (nonatomic, strong) VOResellerGoodsEntity *goods;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsId;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger goodsNum;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *consumerId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *resellerId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, strong) NSNumber *costPrice;
@end /* interface TOShopcartEntity */



/**
 * (no documentation provided)
 */
@interface IdEntity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
@end /* interface IdEntity */



/**
 *  @Title: Entity
 @Description: 场景
 @author onlineGenerator
 @date 2016-05-05 18:39:39
 @version V1.0
 
 
 */
@interface TOSceneEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sceneCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *pricure;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *category;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *style;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *space;
@end /* interface TOSceneEntity */



/**
 *  @Title: Entity
 @Description: 订单详情
 @author onlineGenerator
 @date 2016-05-06 12:53:09
 @version V1.0
 
 
 */
@interface TOOrderdetailEntity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *brandName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsCover;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsSpec;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsBrand;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsNum;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *goodsPrice;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *goodsTotalPrice;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsUnit;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
@end /* interface TOOrderdetailEntity */



/**
 *  @Title: Entity
 @Description: 商品标签分类
 @author onlineGenerator
 @date 2016-05-05 16:57:27
 @version V1.0
 
 
 */
@interface TOGoodsLabelCategoryEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
@end /* interface TOGoodsLabelCategoryEntity */



/**
 *  @Title: Entity
 @Description: 商品分类
 @author onlineGenerator
 @date 2016-05-10 10:17:53
 @version V1.0
 
 
 */
@interface TOGoodsCategoryEntity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *upperName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *upperId;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger level;
@end /* interface TOGoodsCategoryEntity */



/**
 *  经销商和商品关系表。
 
 @author Debenson
 @since 0.1
 
 */
@interface VOResellerGoodsEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *onlineTime;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *company;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *number;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *categoryId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *brandId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *keyword;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *guidePrice;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *tagPrice;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *costPrice;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger inv;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *detailedIntro;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double weight;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *unit;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *productProfile;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *power;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *colorTemperature;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *spec;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *function;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *material;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *lightSource;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsStyle;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *series;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *area;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *size;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *space;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *installMethod;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *lightNumber;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *pictures;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *barcode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *resellerId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *categoryName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *brandName;
@end /* interface VOResellerGoodsEntity */



/**
 *  @Title: Entity
 @Description: t_o_goods
 @author onlineGenerator
 @date 2016-05-12 15:44:01
 @version V1.0
 
 
 */
@interface TOGoodsEntity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger resellerInv;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSNumber *resellerTagPrice;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *resellerState;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *categoryName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *brandName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *onlineTime;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *company;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *number;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *categoryId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *brandId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *keyword;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *guidePrice;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *tagPrice;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *costPrice;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger inv;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *detailedIntro;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double weight;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *unit;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *productProfile;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *power;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *colorTemperature;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *spec;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *function;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *material;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *lightSource;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsStyle;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *series;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *area;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *size;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *space;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *installMethod;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *lightNumber;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *pictures;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *barcode;
/**
 * (no documentation provided)
 * @see TOGoodsForResellerEntity
 *
 */
@property (nonatomic, strong) NSArray<TOGoodsForResellerEntity> *goodsResellerList;
@end /* interface TOGoodsEntity */



/**
 *  @Title: Entity
 @Description: 导购分成表
 @author onlineGenerator
 @date 2016-05-16 16:15:27
 @version V1.0
 
 
 */
@interface TOCommissionHistEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *resellerCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *employeeId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderId;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *amount;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *afteramount;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 方法: 设置java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *employeeName;
/**
 * 方法: 设置java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *state;
@end /* interface TOCommissionHistEntity */



/**
 *  商品分享返回数据。
 
 @author Debenson
 @since 0.1
 
 */
@interface RsShareResponse : JSONModel
/**
 * 分享记录标识
 *
 *
 */
@property (nonatomic, copy) NSString *shareId;
/**
 * 分享页面链接
 *
 *
 */
@property (nonatomic, copy) NSString *url;
@end /* interface RsShareResponse */



/**
 *  @author Debenson
 @since 0.1
 
 */
@interface DeleteCartRequest : JSONModel
/**
 * 购物车标识列表
 * @see NSString
 *
 */
@property (nonatomic, strong) NSArray<NSString *> *cartIds;
@end /* interface DeleteCartRequest */



/**
 *  @author Administrator
 @since 0.1
 
 */
@interface SceneCondition : JSONModel
/**
 * 查询条件:风格
 *
 *
 */
@property (nonatomic, copy) NSString *styleEquals;
/**
 * 查询条件:空间
 *
 *
 */
@property (nonatomic, copy) NSString *spaceEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface SceneCondition */



/**
 *  @author Flash
 @since 0.1
 
 */
@interface OrderBill : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *datapage;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOOrderEntity *order;
/**
 * (no documentation provided)
 * @see TOOrderdetailEntity
 *
 */
@property (nonatomic, strong) NSArray<TOOrderdetailEntity> *orderdetailList;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOConsumerEntity *consumer;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOEmployee *employee;
@end /* interface OrderBill */



/**
 *  @author NuoSa
 
 @since 0.1
 
 */
@interface GoodsCondition : JSONModel
/**
 * 查询条件是 商品名称
 *
 *
 */
@property (nonatomic, copy) NSString *nameLike;
/**
 * 查询条件是 类型id，取值: GoodsCategory#getId()
 *
 *
 */
@property (nonatomic, copy) NSString *categoryEquals;
/**
 * 查询条件是 风格
 *
 *
 */
@property (nonatomic, copy) NSString *styleEquals;
/**
 * 查询条件是 空间
 *
 *
 */
@property (nonatomic, copy) NSString *spaceEquals;
/**
 * 查询条件是 材质
 *
 *
 */
@property (nonatomic, copy) NSString *materialEqueals;
/**
 * 查询条件是 起始价格
 *
 *
 */
@property (nonatomic, strong) NSNumber *startprice;
/**
 * 查询条件是 起始价格
 *
 *
 */
@property (nonatomic, strong) NSNumber *endprice;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface GoodsCondition */



/**
 *  @author Administrator
 @since 0.1
 
 */
@interface DataDict : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *typename;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *typecode;
@end /* interface DataDict */



/**
 *  重置密码请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface ResetPasswordRequest : JSONModel
/**
 * 用户名
 *
 *
 */
@property (nonatomic, copy) NSString *username;
/**
 * 短信验证码，请先调用发送短信接口
 * com.gomore.opple.rest.system.RsSystemService#sendSms(String)
 *
 *
 */
@property (nonatomic, copy) NSString *smsCode;
/**
 * 新密码
 *
 *
 */
@property (nonatomic, copy) NSString *fnewPassword;
@end /* interface ResetPasswordRequest */



/**
 *  登录结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface LoginResult : JSONModel
/**
 * 员工
 *
 *
 */
@property (nonatomic, strong) TOEmployee *employee;
/**
 * 分成比例
 *
 *
 */
@property (nonatomic, strong) NSNumber *commissionRate;
/**
 * 提成金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *commissionTotal;
/**
 * 最低分成比例
 *
 *
 */
@property (nonatomic, strong) NSNumber *lowestDiscount;
@end /* interface LoginResult */



/**
 *  客户查询条件。
 
 @author Debenson
 @since 0.1
 
 */
@interface ConsumerQueryCondition : JSONModel
/**
 * 经销商代码等于
 *
 *
 */
@property (nonatomic, copy) NSString *resellerCodeEquals;
/**
 * 名称等于
 *
 *
 */
@property (nonatomic, copy) NSString *nameEquals;
/**
 * 手机号等于
 *
 *
 */
@property (nonatomic, copy) NSString *mobileEquals;
/**
 * 创建时间起始于，格式: yyyy-MM-dd HH:mm:ss
 *
 *
 */
@property (nonatomic, copy) NSString *createTimeBegin;
/**
 * 创建时间截止于，格式: yyyy-MM-dd HH:mm:ss
 *
 *
 */
@property (nonatomic, copy) NSString *createTimeEnd;
/**
 * 分布查询条件， 可空
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface ConsumerQueryCondition */



/**
 *  异常代码。
 
 @author Debenson
 @since 0.1
 
 */
@interface ExceptionCode : JSONModel
/**
 * 异常代码
 *
 *
 */
@property (nonatomic, assign) NSInteger code;
/**
 * 异常信息
 *
 *
 */
@property (nonatomic, copy) NSString *message;
@end /* interface ExceptionCode */



/**
 * (no documentation provided)
 */
@interface EarningsResponse : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSNumber *accountTotal;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSNumber *yesterdayEarnings;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSNumber *historyEarning;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSNumber *applytotal;
@end /* interface EarningsResponse */



/**
 *  @author Administrator
 @since 0.1
 
 */
@interface ApplyRequest : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSNumber *amount;
@end /* interface ApplyRequest */



/**
 *  订单返回对象
 
 @author wsx
 @since 0.1
 
 */
@interface OrderResponse : PageRows
/**
 * (no documentation provided)
 * @see OrderBill
 *
 */
@property (nonatomic, strong) NSArray<OrderBill> *orderBillList;
@end /* interface OrderResponse */



/**
 *  部门机构表
 @author  张代浩
 
 */
@interface TSDepart : IdEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *TSPDepart;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *departname;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fdescription;
/**
 * (no documentation provided)
 * @see TSDepart
 *
 */
@property (nonatomic, strong) NSArray<TSDepart> *TSDeparts;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orgCode;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orgType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *mobile;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fax;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *address;
@end /* interface TSDepart */



/**
 *  系统用户父类表
 @author  张代浩
 
 */
@interface TSBaseUser : IdEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *departid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSData *signature;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *browser;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *userKey;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) short status;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) short activitiSync;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *password;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *realName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *currentDepart;
/**
 * (no documentation provided)
 * @see TSUserOrg
 *
 */
@property (nonatomic, strong) NSArray<TSUserOrg> *userOrgList;
@end /* interface TSBaseUser */



/**
 *  用户-组织机构 实体
 <p/>
 <p><b>User:</b> zhanggm <a href="mailto:guomingzhang2008@gmail.com">guomingzhang2008@gmail.com</a></p>
 <p><b>Date:</b> 2014-08-22 15:39</p>
 
 @author 张国明
 
 */
@interface TSUserOrg : IdEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSUser *tsUser;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *tsDepart;
@end /* interface TSUserOrg */



/**
 *  购物车返回对象
 
 @author Flash
 @since 0.1
 
 */
@interface ShopCartResponse : PageRows
/**
 * (no documentation provided)
 * @see TOShopcartEntity
 *
 */
@property (nonatomic, strong) NSArray<TOShopcartEntity> *shopcart;
@end /* interface ShopCartResponse */



/**
 *  @author Administrator
 @since 0.1
 
 */
@interface SceneResponse : PageRows
/**
 * (no documentation provided)
 * @see TOSceneEntity
 *
 */
@property (nonatomic, strong) NSArray<TOSceneEntity> *list;
@end /* interface SceneResponse */



/**
 *  @author NuoSa
 
 @since 0.1
 
 */
@interface GoodsResponse : PageRows
/**
 * 商品列表
 * @see TOGoodsEntity
 *
 */
@property (nonatomic, strong) NSArray<TOGoodsEntity> *goodsEntity;
@end /* interface GoodsResponse */



/**
 *  客户分页查询结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface ConsumerPageResult : PageRows
/**
 * 客户列表
 * @see TOConsumerEntity
 *
 */
@property (nonatomic, strong) NSArray<TOConsumerEntity> *results;
@end /* interface ConsumerPageResult */



/**
 *  流水明细分页查询结果
 
 @author nevermore
 @since 0.1
 
 */
@interface RsCommissionResponse : PageRows
/**
 * (no documentation provided)
 * @see TOCommissionHistEntity
 *
 */
@property (nonatomic, strong) NSArray<TOCommissionHistEntity> *list;
@end /* interface RsCommissionResponse */



/**
 *  查询提现进度分页
 
 @author nevermore
 @since 0.1
 
 */
@interface RsApplyBillResponse : PageRows
/**
 * (no documentation provided)
 * @see TOApplyBillEntity
 *
 */
@property (nonatomic, strong) NSArray<TOApplyBillEntity> *list;
@end /* interface RsApplyBillResponse */



/**
 *  系统用户表
 
 @author 张代浩
 
 */
@interface TSUser : TSBaseUser
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *signatureFile;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *mobilePhone;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *officePhone;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *email;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *position;
@end /* interface TSUser */



/**
 *  经销商员工。
 
 @author Debenson
 @since 0.1
 
 */
@interface TOEmployee : TSUser
/**
 * 职位编码列表， (多个职位编码用逗号分隔，非必填)
 *
 *
 */
@property (nonatomic, copy) NSString *positions;
/**
 * 个人头像
 *
 *
 */
@property (nonatomic, copy) NSString *picture;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *positionsName;
@end /* interface TOEmployee */


