//
//  RebateDetailsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/8/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "RebateDetailsViewController.h"
#import "RebateSuccessTableViewController.h"

@interface RebateDetailsViewController ()<UITextFieldDelegate>

/**
 *  输入提现金额
 */
@property (weak, nonatomic) IBOutlet UITextField *inputRebateTextField;

/**
 *  本次申请的UUID
 */
@property (nonatomic,copy) NSString *applyUUID;


@end

@implementation RebateDetailsViewController

- (void)viewDidLoad {
    [super viewDidLoad];

    self.inputRebateTextField.placeholder = [NSString stringWithFormat:@"当前可提现:%.2f",self.rebateAmount];
}

- (IBAction)rebateButtonClickAction:(UIButton *)sender {
    
    WS(weakSelf);
    if ([[self class]isBlankString:self.inputRebateTextField.text]) {
        [self SHOWPrompttext:@"请输入提现金额"];return;
    }
    if ([self.inputRebateTextField.text floatValue] > self.rebateAmount) {
        [self SHOWPrompttext:@"当前账户余额不足"];return;
    }
    if ([self.inputRebateTextField.text floatValue] <= 0) {
        [self SHOWPrompttext:@"格式不正确"];return;
    }
    if ([self includeChinese:self.inputRebateTextField.text]) {
        [self SHOWPrompttext:@"格式不正确"];return;
    }
    UIAlertController *alertVC = [UIAlertController alertControllerWithTitle:nil message:[NSString stringWithFormat:@"请确认提现金额:%@元",self.inputRebateTextField.text] preferredStyle:UIAlertControllerStyleAlert];
    [alertVC addAction:[UIAlertAction actionWithTitle:@"确认" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [weakSelf CreateMBProgressHUDLoding];
        [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:SERVERREQUESTURL(WITHDRAWAL) WithCallClass:weakSelf WithRequestType:0 WithParameter:@{@"amount":self.inputRebateTextField.text} WithReturnValueBlock:^(id returnValue) {

            [weakSelf RemoveMBProgressHUDLoding];
            if ([returnValue[@"code"] isEqualToNumber:@0]) {
                weakSelf.applyUUID = returnValue[@"data"];
                [weakSelf rebateApplySuccess];
            }else
            {
                [weakSelf SHOWPrompttext:returnValue[@"message"]];
            }
        } WithErrorCodeBlock:^(id errorCodeValue) {
            [weakSelf RemoveMBProgressHUDLoding];
            [weakSelf SHOWPrompttext:NETWORK];
        } WithFailureBlock:^(NSError *error) {
            [weakSelf RemoveMBProgressHUDLoding];
            [weakSelf SHOWPrompttext:error.localizedDescription];
        }];
    }]];
    [alertVC addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
    }]];
    [self presentViewController:alertVC animated:YES completion:nil];
}

#pragma mark - 提现申请成功
- (void)rebateApplySuccess
{
    WS(weakSelf);
    RebateSuccessTableViewController *success = [self.getStoryboardWithName instantiateViewControllerWithIdentifier:@"RebateSuccessTableViewController"];
    success.titleArray = @[@"提现申请已提交，审核中",@"查看详情",@"返回账户"];
    [success setClickEvent:^(NSIndexPath *indexPath) {
        if (indexPath.row == 1) {
            [weakSelf.navigationController popViewControllerAnimated:YES];
        }else if (indexPath.row == 0)
        {
            [weakSelf queryDetails];
        }
    }];
    success.preferredContentSize = CGSizeMake(315, 320);
    success.modalPresentationStyle = UIModalPresentationFormSheet;
    UIPopoverPresentationController *pop = success.popoverPresentationController;
    pop.permittedArrowDirections = UIPopoverArrowDirectionAny;
    pop.sourceView = success.view;
    [self presentViewController:success animated:YES completion:nil];
}

#pragma mark - 查询详情
- (void)queryDetails
{
    [self CreateMBProgressHUDLoding];
    WS(weakSelf);
    NSString *urlString = [NSString stringWithFormat:@"%@/%@",WITHDRAWALPROGRESSDETAILS,self.applyUUID];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:SERVERREQUESTURL(urlString) WithCallClass:weakSelf WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            TOApplyBillEntity *result = [[TOApplyBillEntity alloc]initWithDictionary:returnValue[@"data"] error:nil];
            [weakSelf.navigationController popViewControllerAnimated:NO];
            if (weakSelf.showApplyDetails) {
                weakSelf.showApplyDetails(result);
            }
        }else
        {
            [weakSelf SHOWPrompttext:returnValue[@"message"]];
        }
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf SHOWPrompttext:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf SHOWPrompttext:error.localizedDescription];
    }];
}

#pragma mark - <UITextFieldDelegate>
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    NSScanner      *scanner    = [NSScanner scannerWithString:string];
    NSCharacterSet *numbers;
    NSRange         pointRange = [textField.text rangeOfString:@"."];
    if ( (pointRange.length > 0) && (pointRange.location < range.location  || pointRange.location > range.location + range.length) ){
        numbers = [NSCharacterSet characterSetWithCharactersInString:@"0123456789"];
    }else{
        numbers = [NSCharacterSet characterSetWithCharactersInString:@"0123456789."];
    }
    if ( [textField.text isEqualToString:@""] && [string isEqualToString:@"."] ){
        return NO;
    }
    short remain = 2; //保留 number位小数
    NSString *tempStr = [textField.text stringByAppendingString:string];
    NSUInteger strlen = [tempStr length];
    if(pointRange.length > 0 && pointRange.location > 0){ //判断输入框内是否含有“.”。
        if([string isEqualToString:@"."]){ //当输入框内已经含有“.”时，如果再输入“.”则被视为无效。
            return NO;
        }
        if(strlen > 0 && (strlen - pointRange.location) > remain+1){ //当输入框内已经含有“.”，当字符串长度减去小数点前面的字符串长度大于需要要保留的小数点位数，则视当次输入无效。
            return NO;
        }
    }
    NSRange ZERORange = [textField.text rangeOfString:@"0"];
    if(ZERORange.length == 1 && ZERORange.location == 0){ //判断输入框第一个字符是否为“0”
        if(![string isEqualToString:@"0"] && ![string isEqualToString:@"."] && [textField.text length] == 1){ //当输入框只有一个字符并且字符为“0”时，再输入不为“0”或者“.”的字符时，则将此输入替换输入框的这唯一字符。
            textField.text = string;
            return NO;
        }else{
            if(pointRange.length == 0 && pointRange.location > 0){ //当输入框第一个字符为“0”时，并且没有“.”字符时，如果当此输入的字符为“0”，则视当此输入无效。
                if([string isEqualToString:@"0"]){
                    return NO;
                }
            }
        }
    }
    NSString *buffer;
    if ( ![scanner scanCharactersFromSet:numbers intoString:&buffer] && ([string length] != 0) ){
        return NO;
    }else{
        return YES;
    }
}

#pragma mark - 判断是否是汉字
- (BOOL)includeChinese:(NSString *)string
{
    for(int i=0; i< [string length];i++)
    {
        int a =[string characterAtIndex:i];
        if( a >0x4e00&& a <0x9fff){
            return YES;
        }
    }
    return NO;
}

@end
