//
//  ShareGoodsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/6/3.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ShareGoodsViewController.h"

@interface ShareGoodsViewController ()

@end

@implementation ShareGoodsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
}

#pragma mark - 压缩图片
- (void)setShareImage:(UIImage *)shareImage
{
    _shareImage = [UIImage imageWithData:UIImageJPEGRepresentation(shareImage, 0.2)];
}

#pragma mark -分享
- (IBAction)ShareWeiChatAntWeiboAction:(UIButton *)sender {
    
    WS(weakSelf);
    if (self.isShareOrderbill) {//分享订单
         [self dismissViewControllerAnimated:YES completion:nil];
        [weakSelf CreateMBProgressHUDLoding];
        NSString *shareOrderString = [NSString stringWithFormat:@"%@/%@",SHAREORDERBILL,self.orderBillNumber];
        [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:SERVERREQUESTURL(shareOrderString) WithCallClass:weakSelf WithRequestType:ZERO WithParameter:nil WithReturnValueBlock:^(id returnValue) {
            
            [weakSelf RemoveMBProgressHUDLoding];
            if ([returnValue[@"code"] isEqualToNumber:@0]) {
                [weakSelf callSharePlatform:returnValue[@"data"][@"url"] withPlatformTag:sender withTitle:@"欧立方订单一键分享"];
            }else
            {
                [weakSelf SHOWPrompttext:returnValue[@"message"]];
            }
            
        } WithErrorCodeBlock:^(id errorCodeValue) {
            [weakSelf ErrorMBProgressView:NETWORK];
        } WithFailureBlock:^(NSError *error) {
            [weakSelf ErrorMBProgressView:error.localizedDescription];
        }];
    }else//分享商品
    {
        [self dismissViewControllerAnimated:YES completion:nil];
        NSData *imageData = UIImageJPEGRepresentation(self.shareImage, 0.5);
        NSString *goodsID = [self.goodsIds substringToIndex:[self.goodsIds length]-1];
        NSDictionary *parameterDict = [NSDictionary dictionaryWithObjectsAndKeys:[goodsID substringToIndex:self.goodsIds.length-1],@"goodsIds",@"",@"title",@"",@"remark",nil];
        //上传图片
        MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:SHARED_APPDELEGATE.window animated:YES];
        hud.mode = MBProgressHUDModeDeterminate;
        hud.labelText = @"上传中....";
        hud.removeFromSuperViewOnHide = YES;
        [[NetworkRequestClassManager Manager] UploadImageWithURL:SERVERREQUESTURL(SHARE) WithRequestType:ZERO WithImageDatas:imageData WithParameter:parameterDict WithReturnValueBlock:^(id returnValue) {
            
            if ([returnValue[@"code"] isEqualToNumber:@0]) {
                NSString *shareWeb = returnValue[@"data"][@"url"];
                [self callSharePlatform:shareWeb withPlatformTag:sender withTitle:ShareTitle];
            }else
            {
                [weakSelf ErrorMBProgressView:returnValue[@"message"]];
            }
        }WithprogressBlock:^(double progress) {
            if (progress >= 1) {
                dispatch_async(dispatch_get_main_queue(), ^{
                    [hud hide:YES];
                });
            }else{
                dispatch_async(dispatch_get_main_queue(), ^{
                    hud.progress = progress;
                });
            }
            
        } WithErrorCodeBlock:^(id errorCodeValue) {
            [hud hide:YES];
        } WithFailureBlock:^(NSError *error) {
            dispatch_async(dispatch_get_main_queue(), ^{
                hud.labelText = @"上传失败";
                [hud hide:YES afterDelay:1];
            });
        }];
    }
}

#pragma mark - 调用分享
- (void)callSharePlatform:(NSString *)shareWeb withPlatformTag:(UIButton *)sender withTitle:(NSString *)title
{
    WS(weakSelf);
    switch (sender.tag) {
        case 100: //微信好友
        {//自定义样式
            //使用UMShareToWechatSession,UMShareToWechatTimeline,UMShareToWechatFavorite分别代表微信好友、微信朋友圈、微信收藏
            [UMSocialData defaultData].extConfig.wechatSessionData.url = shareWeb;
            [[UMSocialDataService defaultDataService]  postSNSWithTypes:@[UMShareToWechatSession] content:title image:self.shareImage location:nil urlResource:nil presentedController:self completion:^(UMSocialResponseEntity *response){
                if (response.responseCode == UMSResponseCodeSuccess) {
                    [weakSelf SuccessMBProgressView:@"分享微信好友成功"];
                }
            }];
        }
            break;
        case 101://微信朋友圈
        {
            //使用UMShareToWechatSession,UMShareToWechatTimeline,UMShareToWechatFavorite分别代表微信好友、微信朋友圈、微信收藏
            [UMSocialData defaultData].extConfig.wechatTimelineData.url = shareWeb;
            [[UMSocialDataService defaultDataService]  postSNSWithTypes:@[UMShareToWechatTimeline] content:title image:self.shareImage location:nil urlResource:nil presentedController:self completion:^(UMSocialResponseEntity *response){
                if (response.responseCode == UMSResponseCodeSuccess) {
                    [weakSelf SuccessMBProgressView:@"分享微信朋友圈成功"];
                }
            }];
        }
            break;
        case 102://新浪微博
        {
            //自定义分享样式
            [UMSocialData defaultData].extConfig.sinaData.shareText = [NSString stringWithFormat:@"%@%@",@"欧普照明",shareWeb];
            [[UMSocialDataService defaultDataService]  postSNSWithTypes:@[UMShareToSina] content:title image:self.shareImage location:nil urlResource:nil presentedController:self completion:^(UMSocialResponseEntity *shareResponse){
                if (shareResponse.responseCode == UMSResponseCodeSuccess) {
                    [weakSelf SuccessMBProgressView:@"分享新浪微博成功"];
                }
            }];
        }
            break;
        default:
            break;
    }
}


@end
