//
//  CommodityListTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CommodityListTableViewCell.h"

@implementation CommodityListTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

#pragma mark 赋值
- (void)setModel:(ShopcarModel *)model
{
    _model = model;
    [self.goodsHeader sd_setImageWithURL:[NSURL URLWithString:_model.goods.pictures] placeholderImage:ReplaceImage];
    self.goodsName.text = _model.goods.name;
    self.goodsNumber.text = [NSString stringWithFormat:@"数量  X%d",_model.goodsNum];
    self.clinchPrice.text = [NSString stringWithFormat:@"成交价  ￥%@",[_model.goods.costPrice stringValue]];
    //计算总价格
    NSInteger number = _model.goodsNum;
    NSInteger price = [_model.goods.costPrice integerValue];
    NSInteger allPrice = number*price;
    self.totalPrice.text = [NSString stringWithFormat:@"%ld",allPrice];
}



#pragma mark -订单详情页赋值
- (void)setOrderDetailslist:(TOOrderdetailEntity *)orderDetailslist
{
    _orderDetailslist = orderDetailslist;
    [self.goodsHeader sd_setImageWithURL:[NSURL URLWithString:_orderDetailslist.goodsBrand] placeholderImage:ReplaceImage];
    self.goodsNumber.text = [NSString stringWithFormat:@"数量   X%@",_orderDetailslist.goodsNum];
    self.clinchPrice.text = [NSString stringWithFormat:@"成交价  ￥%@",[_orderDetailslist.goodsPrice stringValue]];
    //小计
    NSInteger totalPrice = [_orderDetailslist.goodsNum integerValue] * [_orderDetailslist.goodsPrice integerValue];
    self.totalPrice.text = [NSString stringWithFormat:@"￥%ld",totalPrice];
    self.goodsName.text = _orderDetailslist.goodsSpec;
    
    
    
}




- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
