//
//  CustomerOrderTableViewCell.h
//  Lighting
//
//  Created by 曹云霄 on 16/5/6.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>

/**
 *  撤销订单、去支付
 */
@protocol undoOrderDelegate <NSObject>


@optional

/**
 *  撤销订单
 *
 *  @param cellindex cell下标
 */
- (void)undoOrderButtonClick:(NSInteger)cellindex;

/**
 *  去支付
 */
- (void)TopayButtonClick:(NSInteger)cellindex;

@end




@interface CustomerOrderTableViewCell : UITableViewCell


/**
 *  日期
 */
@property (weak, nonatomic) IBOutlet UILabel *orderDate;


/**
 *  订单编号
 */
@property (weak, nonatomic) IBOutlet UILabel *orderSerialNumber;


/**
 *  操作员
 */
@property (weak, nonatomic) IBOutlet UILabel *shoppersName;


/**
 *  客户头像
 */
@property (weak, nonatomic) IBOutlet UIImageView *customerHeader;

/**
 *  订单状态
 */
@property (weak, nonatomic) IBOutlet UILabel *orderStatus;


/**
 *  客户名称
 */
@property (weak, nonatomic) IBOutlet UILabel *customerName;

/**
 *  款式数量
 */
@property (weak, nonatomic) IBOutlet UILabel *styleNumber;


/**
 *  收货人
 */
@property (weak, nonatomic) IBOutlet UILabel *consigneeName;


/**
 *  收货人电话
 */
@property (weak, nonatomic) IBOutlet UILabel *consigneePhoneNumber;


/**
 *  商品品牌
 */
@property (weak, nonatomic) IBOutlet UILabel *goodsBrandName;


/**
 *  联系电话
 */
@property (weak, nonatomic) IBOutlet UILabel *phoneNumber;


/**
 *  购买数量
 */
@property (weak, nonatomic) IBOutlet UILabel *buyNumber;


/**
 *  收货地址
 */
@property (weak, nonatomic) IBOutlet UILabel *consigneeAddress;

/**
 *  订单总计
 */
@property (weak, nonatomic) IBOutlet UILabel *orderTotalPrice;

/**
 *  cell背景
 */
@property (weak, nonatomic) IBOutlet UIView *cellBackView;


/**
 *  订单详情model
 */
@property (nonatomic,strong) OrderBill *model;

/**
 *  撤销订单
 */
@property (weak, nonatomic) IBOutlet UIButton *delecteOrder;


/**
 *  收货人电话title
 */
@property (weak, nonatomic) IBOutlet UILabel *consigneeNumber;


/**
 *  订单总计title
 */
@property (weak, nonatomic) IBOutlet UILabel *orderAll;



/**
 *  撤销订单代理
 */
@property (nonatomic,assign) id<undoOrderDelegate>delegate;


/**
 *  传入cell下标
 */
@property (nonatomic,assign) NSInteger cellIndex;



/**
 *  订单状态图片
 */
@property (weak, nonatomic) IBOutlet UIImageView *orderStateImageView;

/**
 *  去支付
 */
@property (weak, nonatomic) IBOutlet UIButton *gotoPayButton;




@end
